/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import net.handle.dnslib.DomainName;
import net.handle.dnslib.ParseException;
import net.handle.dnslib.Question;
import net.handle.hdllib.Util;

public class ResourceRecord {
    public static final int TYPE_A = 1;
    public static final int TYPE_NS = 2;
    public static final int TYPE_MD = 3;
    public static final int TYPE_MF = 4;
    public static final int TYPE_CNAME = 5;
    public static final int TYPE_SOA = 6;
    public static final int TYPE_MB = 7;
    public static final int TYPE_MG = 8;
    public static final int TYPE_MR = 9;
    public static final int TYPE_NULL = 10;
    public static final int TYPE_WKS = 11;
    public static final int TYPE_PTR = 12;
    public static final int TYPE_HINFO = 13;
    public static final int TYPE_MINFO = 14;
    public static final int TYPE_MX = 15;
    public static final int TYPE_TXT = 16;
    public static final int TYPE_RP = 17;
    public static final int TYPE_AFSDB = 18;
    public static final int TYPE_X25 = 19;
    public static final int TYPE_ISDN = 20;
    public static final int TYPE_RT = 21;
    public static final int TYPE_SIG = 24;
    public static final int TYPE_PX = 26;
    public static final int TYPE_AAAA = 28;
    public static final int TYPE_NXT = 30;
    public static final int TYPE_SRV = 33;
    public static final int TYPE_NAPTR = 35;
    public static final int TYPE_KX = 36;
    public static final int TYPE_SPF = 99;
    public static final int CLASS_IN = 1;
    private static final int DATA_TOKEN_OPAQUE = 0;
    private static final int DATA_TOKEN_STRING = -1;
    private static final int DATA_TOKEN_MULTIPLE_STRINGS = -2;
    private static final int DATA_TOKEN_DOMAIN_NAME = -3;
    private static final int[] DATA_DOMAIN_NAME = new int[]{-3};
    private static final int[] DATA_MX = new int[]{2, -3};
    private static final int[] DATA_RP = new int[]{-3, -3};
    private static final int[] DATA_SOA = new int[]{-3, -3, 4, 4, 4, 4, 4};
    private static final int[] DATA_TXT = new int[]{-2};
    private static final int[] DATA_OPAQUE = new int[]{0};
    private static final int[] DATA_SIG = new int[]{18, -3, 0};
    private static final int[] DATA_PX = new int[]{2, -3, -3};
    private static final int[] DATA_NXT = new int[]{-3, 0};
    private static final int[] DATA_SRV = new int[]{2, 2, 2, -3};
    private static final int[] DATA_NAPTR = new int[]{2, 2, -1, -1, -1, -3};
    private final DomainName owner;
    private final int type;
    private final int klass;
    private int ttl;
    private Object[] dataTokens;
    private final int[] dataTokenTypes;
    private Question _question;
    private final Question[] noQuestions = new Question[0];

    private int[] expectedDataTokenTypes() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                return DATA_DOMAIN_NAME;
            }
            case 6: {
                return DATA_SOA;
            }
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 99: {
                return DATA_TXT;
            }
            case 14: 
            case 17: {
                return DATA_RP;
            }
            case 15: 
            case 18: 
            case 21: {
                return DATA_MX;
            }
            case 24: {
                return DATA_SIG;
            }
            case 26: {
                return DATA_PX;
            }
            case 30: {
                return DATA_NXT;
            }
            case 33: {
                return DATA_SRV;
            }
            case 35: {
                return DATA_NAPTR;
            }
        }
        return DATA_OPAQUE;
    }

    public ResourceRecord(DomainName owner, int type, int klass, int ttl, String data) throws ParseException {
        this.owner = owner;
        this.type = type;
        this.klass = klass;
        this.ttl = ttl;
        this.dataTokenTypes = this.expectedDataTokenTypes();
        this.parseMasterFileData(data);
    }

    public ResourceRecord(DomainName owner, int type, int klass, int ttl, byte[] data, int offset, int length) throws ParseException {
        this.owner = owner;
        this.type = type;
        this.klass = klass;
        this.ttl = ttl;
        this.dataTokenTypes = this.expectedDataTokenTypes();
        this.parseWireData(data, offset, length);
    }

    public ResourceRecord(DomainName owner, int ttl, ResourceRecord rr) {
        this.owner = owner;
        this.type = rr.type;
        this.klass = rr.klass;
        this.ttl = ttl;
        this.dataTokenTypes = rr.dataTokenTypes;
        this.dataTokens = rr.dataTokens;
    }

    public DomainName getOwner() {
        return this.owner;
    }

    public int getType() {
        return this.type;
    }

    public int getKlass() {
        return this.klass;
    }

    public int getTTL() {
        return this.ttl;
    }

    void setTTL(int ttl) {
        this.ttl = ttl;
    }

    private static String[] tokenizeMasterFileFormatData(String data) {
        ArrayList<String> res = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        boolean whitespace = true;
        boolean comment = false;
        boolean quote = false;
        boolean slash = false;
        boolean output = false;
        for (int i = 0; i < data.length(); ++i) {
            boolean isNewline;
            char ch = data.charAt(i);
            boolean bl = isNewline = ch == '\n';
            if (comment && !isNewline) continue;
            comment = false;
            if (isNewline) {
                ch = ' ';
            }
            if (!(quote || slash || comment || ch != '(' && ch != ')')) {
                ch = ' ';
            }
            if (whitespace && ch == ' ') continue;
            if (slash) {
                buf.append('\\');
                buf.append(ch);
                slash = false;
                output = isNewline;
            } else if (quote) {
                buf.append(ch);
                slash = ch == '\\';
                quote = ch != '\"';
                output = isNewline;
            } else if (ch == ' ') {
                output = true;
            } else if (ch == ';') {
                if (!whitespace) {
                    output = true;
                }
                comment = true;
                whitespace = true;
            } else {
                whitespace = false;
                buf.append(ch);
                slash = ch == '\\';
                boolean bl2 = quote = ch == '\"';
            }
            if (!output) continue;
            res.add(buf.toString());
            buf = new StringBuilder();
            whitespace = true;
            quote = false;
            slash = false;
            output = false;
        }
        if (!whitespace) {
            res.add(buf.toString());
        }
        return res.toArray(new String[res.size()]);
    }

    public static byte[] parseMasterFileDataString(String s) throws ParseException {
        byte[] label = Util.encodeString(s);
        int next = 0;
        int i = 0;
        while (i < label.length) {
            if (label[i] == 92) {
                if (i + 1 >= label.length) {
                    throw new ParseException("Error parsing " + s);
                }
                if (label[i + 1] >= 48 && label[i + 1] <= 57) {
                    if (i + 3 < label.length && label[i + 2] >= 48 && label[i + 2] <= 57 && label[i + 3] >= 48 && label[i + 3] <= 57) {
                        int replacement = (label[i + 1] - 48) * 100 + (label[i + 2] - 48) * 10 + (label[i + 3] - 48);
                        label[next] = (byte)replacement;
                        ++next;
                        i += 4;
                        continue;
                    }
                    throw new ParseException("Error parsing " + s);
                }
                label[next] = label[i + 1];
                ++next;
                i += 2;
                continue;
            }
            ++next;
            ++i;
        }
        if (next < label.length) {
            byte[] oldLabel = label;
            label = new byte[next];
            System.arraycopy(oldLabel, 0, label, 0, next);
        }
        return label;
    }

    private void parseMasterFileData(String data) throws ParseException {
        String[] tokens = ResourceRecord.tokenizeMasterFileFormatData(data);
        if (tokens.length >= 2 && "\\#".equals(tokens[0])) {
            try {
                int n = Integer.parseInt(tokens[1]);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Expected length after \\#");
            }
            StringBuilder hex = new StringBuilder();
            for (int i = 2; i < tokens.length; ++i) {
                hex.append(tokens[i]);
            }
            this.parseWireData(Util.encodeHexString(hex.toString()));
            return;
        }
        if (tokens.length == 1 && (this.type == 1 || this.type == 28)) {
            this.dataTokens = (Object[])new byte[1][];
            try {
                this.dataTokens[0] = InetAddress.getByName(tokens[0]).getAddress();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ParseException("Couldn't parse this address: " + tokens[0]);
            }
            return;
        }
        ArrayList<Object> parsedTokens = new ArrayList<Object>(tokens.length);
        int typei = 0;
        for (String token : tokens) {
            if (typei >= this.dataTokenTypes.length) {
                throw new ParseException("Couldn't parse " + data + " for type " + this.type);
            }
            int thisType = this.dataTokenTypes[typei];
            try {
                switch (thisType) {
                    case 4: {
                        parsedTokens.add((int)Long.parseLong(token));
                        break;
                    }
                    case 2: {
                        parsedTokens.add(Integer.parseInt(token));
                        break;
                    }
                    case -2: 
                    case -1: {
                        byte[] s = ResourceRecord.parseMasterFileDataString(token);
                        if (thisType == -1 && s.length > 255) {
                            throw new ParseException("string too long");
                        }
                        int offset = 0;
                        while (s.length - offset > 255) {
                            byte[] firstPart = new byte[255];
                            System.arraycopy(s, offset, firstPart, 0, 255);
                            parsedTokens.add(firstPart);
                            offset += 255;
                        }
                        if (offset > 0) {
                            byte[] lastPart = new byte[s.length - offset];
                            System.arraycopy(s, offset, lastPart, 0, s.length - offset);
                            s = lastPart;
                        }
                        parsedTokens.add(s);
                        break;
                    }
                    case -3: {
                        parsedTokens.add(DomainName.ofString(token));
                        break;
                    }
                    default: {
                        throw new ParseException("Can't parse this type " + this.type);
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new ParseException("Expected number in " + token);
            }
            if (thisType == -2) continue;
            ++typei;
        }
        if (typei < this.dataTokenTypes.length && this.dataTokenTypes[typei] != -2) {
            throw new ParseException("data incomplete");
        }
        this.dataTokens = parsedTokens.toArray();
    }

    private void parseWireData(byte[] data) throws ParseException {
        this.parseWireData(data, 0, data.length);
    }

    /*
     * Exception decompiling
     */
    private void parseWireData(byte[] data, int offset, int length) throws ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[DOLOOP]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ResourceRecord parseWire(byte[] wire, int[] offsetArr) throws ParseException {
        int rdlen;
        DomainName owner = DomainName.parseWire(wire, offsetArr);
        int offset = offsetArr[0];
        if (offset + 10 > wire.length) {
            throw new ParseException("IndexOutOfBounds parsing resource record");
        }
        int type = (wire[offset++] & 0xFF) << 8 | wire[offset++] & 0xFF;
        int klass = (wire[offset++] & 0xFF) << 8 | wire[offset++] & 0xFF;
        int ttl = (wire[offset++] & 0xFF) << 24 | (wire[offset++] & 0xFF) << 16 | (wire[offset++] & 0xFF) << 8 | wire[offset++] & 0xFF;
        if (offset + (rdlen = (wire[offset++] & 0xFF) << 8 | wire[offset++] & 0xFF) > wire.length) {
            throw new ParseException("IndexOutOfBounds parsing resource record");
        }
        ResourceRecord rr = new ResourceRecord(owner, type, klass, ttl, wire, offset, rdlen);
        offsetArr[0] = offset += rdlen;
        return rr;
    }

    public int appendToWireWithCompression(OutputStream wire, int offset, Map<DomainName, Integer> compressionTable) throws IOException {
        offset = this.owner.appendToWireWithCompression(wire, offset, compressionTable);
        wire.write(this.type >> 8 & 0xFF);
        wire.write(this.type & 0xFF);
        wire.write(this.klass >> 8 & 0xFF);
        wire.write(this.klass & 0xFF);
        wire.write(this.ttl >> 24 & 0xFF);
        wire.write(this.ttl >> 16 & 0xFF);
        wire.write(this.ttl >> 8 & 0xFF);
        wire.write(this.ttl & 0xFF);
        int rdlenOffset = offset += 8;
        offset += 2;
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        int typei = 0;
        for (Object dataToken : this.dataTokens) {
            int thisType = this.dataTokenTypes[typei];
            switch (thisType) {
                case 4: {
                    int i = (Integer)dataToken;
                    dataOut.write(i >> 24 & 0xFF);
                    dataOut.write(i >> 16 & 0xFF);
                    dataOut.write(i >> 8 & 0xFF);
                    dataOut.write(i & 0xFF);
                    offset += 4;
                    break;
                }
                case 2: {
                    int i = (Integer)dataToken;
                    dataOut.write(i >> 8 & 0xFF);
                    dataOut.write(i & 0xFF);
                    offset += 2;
                    break;
                }
                case -2: 
                case -1: {
                    byte[] s = (byte[])dataToken;
                    dataOut.write(s.length);
                    ++offset;
                    dataOut.write(s);
                    offset += s.length;
                    break;
                }
                case -3: {
                    offset = ((DomainName)dataToken).appendToWireWithCompression(dataOut, offset, compressionTable, this.requiresCompression());
                    break;
                }
                default: {
                    byte[] s = (byte[])dataToken;
                    dataOut.write(s);
                    offset += s.length;
                }
            }
            if (thisType == -2) continue;
            ++typei;
        }
        int rdlen = offset - rdlenOffset - 2;
        wire.write(rdlen >> 8 & 0xFF);
        wire.write(rdlen & 0xFF);
        wire.write(dataOut.toByteArray());
        return offset;
    }

    public Question getKey() {
        if (this._question == null) {
            this._question = new Question(this.owner, this.type, this.klass);
        }
        return this._question;
    }

    public DomainName nameFromData() {
        for (int i = 0; i < this.dataTokenTypes.length; ++i) {
            if (this.dataTokenTypes[i] != -3) continue;
            return (DomainName)this.dataTokens[i];
        }
        return null;
    }

    public InetAddress addressFromData() {
        if (this.type == 1 || this.type == 28) {
            try {
                return InetAddress.getByAddress((byte[])this.dataTokens[0]);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public int minimumFromSOAData() {
        if (this.type == 6 && this.dataTokens.length > 7 && this.dataTokens[6] instanceof Integer) {
            return (Integer)this.dataTokens[6];
        }
        return 0;
    }

    void writeData(OutputStream dataOut) throws IOException {
        int typei = 0;
        for (Object dataToken : this.dataTokens) {
            int thisType = this.dataTokenTypes[typei];
            switch (thisType) {
                case 4: {
                    int i = (Integer)dataToken;
                    dataOut.write(i >> 24 & 0xFF);
                    dataOut.write(i >> 16 & 0xFF);
                    dataOut.write(i >> 8 & 0xFF);
                    dataOut.write(i & 0xFF);
                    break;
                }
                case 2: {
                    int i = (Integer)dataToken;
                    dataOut.write(i >> 8 & 0xFF);
                    dataOut.write(i & 0xFF);
                    break;
                }
                case -2: 
                case -1: {
                    byte[] s = (byte[])dataToken;
                    dataOut.write(s.length);
                    dataOut.write(s);
                    break;
                }
                case -3: {
                    ((DomainName)dataToken).appendToWireWithCompression(dataOut, 0, null);
                    break;
                }
                default: {
                    byte[] s = (byte[])dataToken;
                    dataOut.write(s);
                }
            }
            if (thisType == -2) continue;
            ++typei;
        }
    }

    public boolean requiresDecompression() {
        return this.type < 36;
    }

    public boolean requiresCompression() {
        return this.type <= 16;
    }

    public Question[] additionalSectionProcessing() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 15: 
            case 18: 
            case 33: 
            case 36: {
                for (int pos = 0; pos < this.dataTokenTypes.length; ++pos) {
                    if (this.dataTokenTypes[pos] != -3) continue;
                    DomainName name = (DomainName)this.dataTokens[pos];
                    return new Question[]{new Question(name, 1, this.klass), new Question(name, 28, this.klass)};
                }
                return this.noQuestions;
            }
            case 21: {
                DomainName name = (DomainName)this.dataTokens[1];
                return new Question[]{new Question(name, 1, this.klass), new Question(name, 28, this.klass), new Question(name, 19, this.klass), new Question(name, 20, this.klass)};
            }
            case 17: {
                DomainName name = (DomainName)this.dataTokens[1];
                if (name != DomainName.ROOT) {
                    return new Question[]{new Question(name, 16, this.klass)};
                }
                return this.noQuestions;
            }
        }
        return this.noQuestions;
    }
}

