/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.FileOutputStream;
import java.net.InetAddress;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;

public abstract class GetRootInfo {
    public static final void main(String[] argv) throws Exception {
        if (argv.length < 3) {
            System.err.println("usage: java net.handle.apps.tools.GetRootInfo <root-server> <port> <output-file>");
            System.exit(1);
        }
        String rootAddrStr = argv[0];
        String rootPortStr = argv[1];
        String outputFileStr = argv[2];
        InetAddress addr = InetAddress.getByName(rootAddrStr);
        int port = Integer.parseInt(rootPortStr);
        ResolutionRequest req = new ResolutionRequest(Common.ROOT_HANDLE, null, null, null);
        AbstractResponse aresponse = new HandleResolver().sendHdlTcpRequest(req, addr, port, null);
        FileOutputStream out = null;
        if (aresponse.responseCode == 1) {
            ResolutionResponse response = (ResolutionResponse)aresponse;
            out = new FileOutputStream(outputFileStr);
            out.write(Encoder.encodeGlobalValues(response.getHandleValues()));
            out.close();
        } else {
            System.err.println("Error: got response: " + aresponse);
        }
    }
}

