/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.File;
import java.io.FileInputStream;
import java.security.PrivateKey;
import net.handle.apps.simple.SiteInfoConverter;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.SecretKeyAuthenticationInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class DoCheckpoint {
    private AuthenticationInfo authInfo = null;
    private SiteInfo siteToCheckpoint = null;
    private static HandleResolver resolver = new HandleResolver();

    public static void printUsageAndExit() {
        System.err.println("java net.handle.apps.tools.DoCheckpoint [siteinfo] [admin-hdl] [admin-index] [keytype] [key]");
        System.err.println("key-type is either PRIVATE or SECRET");
        System.exit(1);
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 5) {
            DoCheckpoint.printUsageAndExit();
        }
        SiteInfo siteInfo = DoCheckpoint.createSiteInfo(argv[0]);
        AuthenticationInfo auth = DoCheckpoint.createAuth(argv[1], argv[2], argv[3], argv[4]);
        if (auth == null) {
            DoCheckpoint.printUsageAndExit();
        }
        DoCheckpoint checkpointer = new DoCheckpoint(auth, siteInfo);
        checkpointer.doIt();
    }

    private static SiteInfo createSiteInfo(String siteInfoFileName) throws Exception {
        File siteFile = new File(siteInfoFileName);
        byte[] buf = new byte[(int)siteFile.length()];
        try (FileInputStream in = new FileInputStream(siteFile);){
            int r;
            for (int n = 0; n < buf.length && (r = in.read(buf, n, buf.length - n)) >= 0; n += r) {
            }
        }
        SiteInfo siteInfo = new SiteInfo();
        if (Util.looksLikeBinary(buf)) {
            Encoder.decodeSiteInfoRecord(buf, 0, siteInfo);
        } else {
            siteInfo = SiteInfoConverter.convertToSiteInfo(new String(buf, "UTF-8"));
        }
        return siteInfo;
    }

    private static AuthenticationInfo createAuth(String id, String idIdx, String type, String key) throws Exception {
        if (type.equals("PRIVATE")) {
            File privateKeyFile = new File(key);
            byte[] encKeyBytes = new byte[(int)privateKeyFile.length()];
            try (FileInputStream in = new FileInputStream(privateKeyFile);){
                int r;
                for (int n = 0; n < encKeyBytes.length && (r = in.read(encKeyBytes, n, encKeyBytes.length - n)) >= 0; n += r) {
                }
            }
            byte[] keyBytes = null;
            byte[] secKey = null;
            if (Util.requiresSecretKey(encKeyBytes)) {
                secKey = Util.getPassphrase("Enter the passphrase for the private key: ");
            }
            keyBytes = Util.decrypt(encKeyBytes, secKey);
            for (int i = 0; secKey != null && i < secKey.length; ++i) {
                secKey[i] = 0;
            }
            PrivateKey privateKey = Util.getPrivateKeyFromBytes(keyBytes, 0);
            return new PublicKeyAuthenticationInfo(Util.encodeString(id), Integer.parseInt(idIdx), privateKey);
        }
        if (type.equals("SECRET")) {
            return new SecretKeyAuthenticationInfo(Util.encodeString(id), Integer.parseInt(idIdx), Util.encodeString(key));
        }
        return null;
    }

    public DoCheckpoint(AuthenticationInfo auth, SiteInfo siteInfo) {
        this.authInfo = auth;
        this.siteToCheckpoint = siteInfo;
    }

    public void doIt() {
        GenericRequest req = new GenericRequest(Common.BLANK_HANDLE, 1003, this.authInfo);
        req.isAdminRequest = true;
        req.certify = true;
        for (int i = 0; i < this.siteToCheckpoint.servers.length; ++i) {
            try {
                System.out.println("----------------------------------------------------");
                System.out.println("Checkpointing server " + i + ": " + this.siteToCheckpoint.servers[i]);
                req.clearBuffers();
                AbstractResponse resp = resolver.sendRequestToServer((AbstractRequest)req, this.siteToCheckpoint, this.siteToCheckpoint.servers[i]);
                if (resp != null && resp.responseCode == 1) continue;
                System.err.println("Error sending backup message: " + resp);
                continue;
            }
            catch (Throwable t) {
                System.err.println("Error checkpointing server " + i + ": " + t);
                t.printStackTrace(System.err);
            }
        }
    }
}

