/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.simple;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivateKey;
import java.util.Vector;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AddValueRequest;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.Util;

public class HDLSetServiceHandle {
    public static void main(String[] argv) throws Exception {
        String prefix;
        if (argv.length < 4) {
            System.err.println("usage: java net.handle.apps.simple.HDLSetServiceHandle <auth handle> <privkey> <service handle> <prefixfile>");
            System.exit(-1);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (FileInputStream fs = new FileInputStream(new File(argv[1]));){
            int r;
            byte[] buf = new byte[1024];
            while ((r = fs.read(buf)) >= 0) {
                bout.write(buf, 0, r);
            }
        }
        catch (Throwable t) {
            System.err.println("Cannot read private key " + argv[1] + ": " + t);
            System.exit(-1);
        }
        byte[] key = bout.toByteArray();
        HandleResolver resolver = new HandleResolver();
        PrivateKey privkey = null;
        byte[] secKey = null;
        try {
            if (Util.requiresSecretKey(key)) {
                secKey = Util.getPassphrase("passphrase: ");
            }
            key = Util.decrypt(key, secKey);
            privkey = Util.getPrivateKeyFromBytes(key, 0);
        }
        catch (Throwable t) {
            System.err.println("Can't load private key in " + argv[1] + ": " + t);
            System.exit(-1);
        }
        PublicKeyAuthenticationInfo auth = new PublicKeyAuthenticationInfo(Util.encodeString(argv[0]), 300, privkey);
        String serviceHandle = argv[2].trim();
        BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(argv[3])), "UTF-8"));
        while ((prefix = rdr.readLine()) != null) {
            if ((prefix = prefix.trim()).length() <= 0) continue;
            ResolutionRequest rreq = new ResolutionRequest(Util.convertSlashlessHandleToZeroNaHandle(Util.encodeString(prefix)), null, null, null);
            rreq.authoritative = true;
            AbstractResponse rresp = resolver.processRequest(rreq);
            HandleValue servHdlvalue = null;
            HandleValue[] values = null;
            if (rresp != null && rresp instanceof ResolutionResponse) {
                values = ((ResolutionResponse)rresp).getHandleValues();
                for (int i = 0; values != null && i < values.length; ++i) {
                    if (values[i] == null || !values[i].hasType(Common.STD_TYPE_HSSERV)) continue;
                    servHdlvalue = values[i];
                    break;
                }
            } else {
                System.err.println("Error response for prefix '" + prefix + "': " + rresp);
                continue;
            }
            if (servHdlvalue == null) {
                HandleValue newServValue = new HandleValue(HDLSetServiceHandle.getFirstAvailableIndex(values), Common.STD_TYPE_HSSERV, Util.encodeString(serviceHandle));
                AddValueRequest addreq = new AddValueRequest(rreq.handle, newServValue, (AuthenticationInfo)auth);
                AbstractResponse addresp = resolver.processRequest(addreq);
                if (addresp == null || addresp.responseCode != 1) {
                    System.err.println("Error adding HS_SERV for prefix '" + prefix + "': " + addresp);
                    continue;
                }
            } else {
                servHdlvalue.setData(Util.encodeString(serviceHandle));
                ModifyValueRequest modreq = new ModifyValueRequest(rreq.handle, servHdlvalue, (AuthenticationInfo)auth);
                AbstractResponse modresp = resolver.processRequest(modreq);
                if (modresp == null || modresp.responseCode != 1) {
                    System.err.println("Error modifying HS_SERV for prefix '" + prefix + "': " + modresp);
                    continue;
                }
            }
            Vector<HandleValue> valuesToRemove = new Vector<HandleValue>();
            for (int i = 0; values != null && i < values.length; ++i) {
                if (values[i] == null || !values[i].hasType(Common.STD_TYPE_HSSITE)) continue;
                valuesToRemove.addElement(values[i]);
            }
            if (valuesToRemove.size() <= 0) continue;
            HandleValue[] indexesToRemove = new HandleValue[valuesToRemove.size()];
            for (int i = 0; i < valuesToRemove.size(); ++i) {
                indexesToRemove[i] = (HandleValue)valuesToRemove.elementAt(i);
                indexesToRemove[i].setType(Util.encodeString("X-HS_SITE"));
            }
            ModifyValueRequest modreq = new ModifyValueRequest(rreq.handle, indexesToRemove, (AuthenticationInfo)auth);
            AbstractResponse modresp = resolver.processRequest(modreq);
            if (modresp != null && modresp.responseCode == 1) continue;
            System.err.println("Error removing extra HS_SITE values from prefix '" + prefix + "': " + modresp);
        }
        rdr.close();
    }

    private static final int getFirstAvailableIndex(HandleValue[] values) {
        int idx = 1;
        while (true) {
            boolean hasIndex = false;
            for (int i = 0; !hasIndex && values != null && i < values.length; ++i) {
                if (values[i] == null || values[i].getIndex() != idx) continue;
                hasIndex = true;
                break;
            }
            if (!hasIndex) {
                return idx;
            }
            if (++idx < 100 || idx >= 1000) continue;
            idx = 1000;
        }
    }
}

