/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch.operations;

import java.security.PrivateKey;
import java.util.ArrayList;
import net.handle.apps.batch.HandleRecordOperationInterface;
import net.handle.apps.batch.operations.JoseSignHandleRecordOperation;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.trust.HandleClaimsSet;
import net.handle.hdllib.trust.HandleSigner;
import net.handle.hdllib.trust.HandleVerifier;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.JsonWebSignatureFactory;
import net.handle.hdllib.trust.TrustException;

public class ResignCertAndHandleRecordOperation
implements HandleRecordOperationInterface {
    private static final JsonWebSignatureFactory factory = JsonWebSignatureFactory.getInstance();
    private static final HandleVerifier verifier = new HandleVerifier();
    private static final HandleSigner signer = new HandleSigner();
    private PrivateKey issPrivateKey;
    private final ValueReference issIdentity;
    private final String firstLinkInChain;
    private String baseUri;
    private String username;
    private String password;
    private String privateKeyId;
    private String privateKeyPassphrase;
    private boolean isRemote = false;
    private final ValueReference oldSignerId;
    private boolean dryRun;

    public ResignCertAndHandleRecordOperation(ValueReference oldSignerId, PrivateKey issPrivateKey, ValueReference issIdentity, String firstLinkInChain) {
        this.oldSignerId = oldSignerId;
        this.issPrivateKey = issPrivateKey;
        this.issIdentity = issIdentity;
        this.firstLinkInChain = firstLinkInChain;
    }

    public ResignCertAndHandleRecordOperation(ValueReference oldSignerId, ValueReference issIdentity, String firstLinkInChain, String baseUri, String username, String password, String privateKeyId, String privateKeyPassphrase) {
        this.oldSignerId = oldSignerId;
        this.issIdentity = issIdentity;
        this.firstLinkInChain = firstLinkInChain;
        this.baseUri = baseUri;
        this.username = username;
        this.password = password;
        this.privateKeyId = privateKeyId;
        this.privateKeyPassphrase = privateKeyPassphrase;
        this.isRemote = true;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Override
    public void process(String handle, HandleValue[] values, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        ArrayList<String> chain = null;
        boolean foundCert = false;
        boolean foundSig = false;
        try {
            for (HandleValue value : values) {
                HandleClaimsSet claims;
                JsonWebSignature jws;
                String data;
                if (value.hasType(Common.HS_CERT_TYPE)) {
                    data = value.getDataAsString();
                    jws = factory.deserialize(data);
                    claims = verifier.getHandleClaimsSet(jws);
                    if (!this.oldSignerId.toString().equals(claims.iss)) continue;
                    foundCert = true;
                    claims.iss = this.issIdentity.toString();
                    if (claims.chain != null) {
                        if (this.firstLinkInChain == null) {
                            claims.chain = null;
                        } else {
                            claims.chain = new ArrayList<String>(claims.chain);
                            claims.chain.set(0, this.firstLinkInChain);
                        }
                    }
                    claims.iat = System.currentTimeMillis() / 1000L;
                    claims.nbf = claims.iat - 600L;
                    claims.exp = claims.iat + 63244800L;
                    JsonWebSignature newJws = this.isRemote ? signer.signClaimsRemotely(claims, this.baseUri, this.username, this.password, this.privateKeyId, this.privateKeyPassphrase) : signer.signClaims(claims, this.issPrivateKey);
                    value.setData(Util.encodeString(newJws.serialize()));
                    System.out.println("Resigned HS_CERT for " + handle);
                    continue;
                }
                if (!value.hasType(Common.HS_SIGNATURE_TYPE)) continue;
                data = value.getDataAsString();
                jws = factory.deserialize(data);
                claims = verifier.getHandleClaimsSet(jws);
                if (!this.oldSignerId.toString().equals(claims.iss)) continue;
                foundSig = true;
                if (claims.chain != null) {
                    if (this.firstLinkInChain == null) {
                        chain = null;
                    } else {
                        chain = new ArrayList<String>(claims.chain);
                        chain.set(0, this.firstLinkInChain);
                    }
                }
                System.out.println("Resigned HS_SIGNATURE for " + handle);
            }
        }
        catch (TrustException e) {
            throw new HandleException(10, (Throwable)e);
        }
        if (!foundSig) {
            if (foundCert) {
                throw new HandleException(10, "Found HS_CERT but not HS_SIGNATURE, manual resigning required");
            }
            return;
        }
        if (this.dryRun) {
            return;
        }
        JoseSignHandleRecordOperation resignHandleOp = this.isRemote ? new JoseSignHandleRecordOperation(this.issIdentity, chain, this.baseUri, this.username, this.password, this.privateKeyId, this.privateKeyPassphrase) : new JoseSignHandleRecordOperation(this.issPrivateKey, this.issIdentity, chain);
        resignHandleOp.process(handle, values, resolver, authInfo, site);
    }
}

