/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch.operations;

import java.util.List;
import net.handle.apps.batch.BatchUtil;
import net.handle.apps.batch.HandleRecordOperationInterface;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;

public class AliasRemoverOperation
implements HandleRecordOperationInterface {
    @Override
    public void process(String handle, HandleValue[] values, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        List<HandleValue> aliases = BatchUtil.getValuesOfType(values, "HS_ALIAS");
        if (aliases.size() > 1) {
            throw new HandleException(1, handle + " has more than one alias");
        }
        if (aliases.size() == 0) {
            return;
        }
        HandleValue alias = aliases.get(0);
        AbstractResponse response = BatchUtil.removeValueRequest(handle, alias, resolver, authInfo, site);
        if (response.responseCode != 1) {
            throw new HandleException(1, response.toString());
        }
    }
}

