/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch.operations;

import java.util.Map;
import net.handle.apps.batch.BatchUtil;
import net.handle.apps.batch.HandleRecordOperationInterface;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;

public class AliasAdderOperation
implements HandleRecordOperationInterface {
    public Map<String, String> aliasMap;

    public AliasAdderOperation(Map<String, String> aliasMap) {
        this.aliasMap = aliasMap;
    }

    @Override
    public void process(String handle, HandleValue[] values, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        int availableIndex = BatchUtil.lowestAvailableIndex(values);
        String alias = this.aliasMap.get(handle);
        if (alias == null) {
            throw new HandleException(1, handle + " does not have an alias in map.");
        }
        AbstractResponse response = BatchUtil.addAliasToHandleRecord(handle, alias, availableIndex, resolver, authInfo, site);
        if (response.responseCode != 1) {
            throw new HandleException(1, response.toString());
        }
    }
}

