/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.handle.apps.batch.BatchUtil;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class ParallelBatchDeleteHandles {
    private final List<String> handlesToDelete;
    private final SiteInfo site;
    private final AuthenticationInfo authInfo;
    private final HandleResolver resolver;
    private final List<String> errorHandles;
    private final List<Exception> exceptions;
    private final AtomicInteger atomicCount;
    private final ExecutorService executor;

    public ParallelBatchDeleteHandles(List<String> handlesToDelete, SiteInfo site, AuthenticationInfo authInfo, HandleResolver resolver, int numThreads) {
        this.handlesToDelete = handlesToDelete;
        this.site = site;
        this.authInfo = authInfo;
        this.resolver = resolver;
        this.errorHandles = Collections.synchronizedList(new ArrayList());
        this.exceptions = Collections.synchronizedList(new ArrayList());
        this.executor = Executors.newFixedThreadPool(numThreads);
        this.atomicCount = new AtomicInteger(0);
    }

    public void deleteHandles() {
        for (String handle : this.handlesToDelete) {
            if ("".equals(handle)) continue;
            DeleteHandleTask task = new DeleteHandleTask(handle, this.resolver, this.authInfo);
            this.executor.execute(task);
        }
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            System.out.println("error shutting down");
        }
    }

    public List<String> getErrorHandles() {
        return this.errorHandles;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public class DeleteHandleTask
    implements Runnable {
        private final String handle;
        private final HandleResolver resolver;
        private final AuthenticationInfo authInfo;

        public DeleteHandleTask(String handle, HandleResolver resolver, AuthenticationInfo authInfo) {
            this.handle = handle;
            this.resolver = resolver;
            this.authInfo = authInfo;
        }

        @Override
        public void run() {
            try {
                int count = ParallelBatchDeleteHandles.this.atomicCount.getAndIncrement();
                System.out.println(count + ": " + this.handle);
                byte[] handleBytes = Util.encodeString(this.handle);
                DeleteHandleRequest deleteHandleRequest = new DeleteHandleRequest(handleBytes, this.authInfo);
                AbstractResponse response = this.resolver.sendRequestToSite(deleteHandleRequest, ParallelBatchDeleteHandles.this.site);
                BatchUtil.throwIfNotSuccess(response);
            }
            catch (HandleException e) {
                e.printStackTrace();
                ParallelBatchDeleteHandles.this.exceptions.add(e);
                ParallelBatchDeleteHandles.this.errorHandles.add(this.handle);
            }
        }
    }
}

