/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch;

import java.util.ArrayList;
import java.util.List;
import net.handle.apps.batch.BatchUtil;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.SiteInfo;

public class BatchUnhomePrefixes {
    private final SiteInfo site;
    private final AuthenticationInfo authInfo;
    private final HandleResolver resolver;

    public BatchUnhomePrefixes(SiteInfo site, AuthenticationInfo authInfo, HandleResolver resolver) {
        this.site = site;
        this.authInfo = authInfo;
        this.resolver = resolver;
    }

    public List<String> unhomePrefixes(List<String> prefixesToUnhome) {
        ArrayList<String> fails = new ArrayList<String>();
        for (String prefix : prefixesToUnhome) {
            try {
                AbstractResponse response = BatchUtil.unhomePrefix(prefix, this.resolver, this.authInfo, this.site);
                if (response.responseCode != 1) {
                    fails.add(prefix);
                    continue;
                }
                System.out.println("UNHOMED: " + prefix);
            }
            catch (HandleException e) {
                fails.add(prefix);
                e.printStackTrace();
            }
        }
        System.out.println("The following prefixes could not be unhomed");
        BatchUtil.writeHandlesToConsole(fails);
        return fails;
    }
}

