/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch;

import java.util.ArrayList;
import java.util.List;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class BatchDeleteHandles {
    private final SiteInfo site;
    private final AuthenticationInfo authInfo;
    private final HandleResolver resolver;

    public BatchDeleteHandles(SiteInfo site, AuthenticationInfo authInfo, HandleResolver resolver) {
        this.site = site;
        this.authInfo = authInfo;
        this.resolver = resolver;
    }

    public List<String> deleteHandles(List<String> handlesToDelete) {
        ArrayList<String> fails = new ArrayList<String>();
        for (String handle : handlesToDelete) {
            byte[] handleBytes = Util.encodeString(handle);
            DeleteHandleRequest deleteHandleRequest = new DeleteHandleRequest(handleBytes, this.authInfo);
            try {
                AbstractResponse response = this.resolver.sendRequestToSite(deleteHandleRequest, this.site);
                if (response.responseCode != 1) {
                    fails.add(handle);
                    continue;
                }
                System.out.println("DELETED: " + handle);
            }
            catch (HandleException e) {
                fails.add(handle);
                e.printStackTrace();
            }
        }
        return fails;
    }
}

