/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Enumeration;
import net.cnri.util.StreamObject;
import net.cnri.util.StreamTable;
import net.cnri.util.StreamVector;

public class StreamObjectToJsonConverter {
    public static JsonElement toJson(StreamObject streamObject) {
        JsonObject result = null;
        if (streamObject.isStreamTable()) {
            result = StreamObjectToJsonConverter.toJson((StreamTable)streamObject);
        } else if (streamObject.isStreamVector()) {
            result = StreamObjectToJsonConverter.toJson((StreamVector)streamObject);
        }
        return result;
    }

    private static JsonObject toJson(StreamTable streamTable) {
        JsonObject jsonObject = new JsonObject();
        Enumeration e = streamTable.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = streamTable.get(key);
            if (value instanceof StreamObject) {
                StreamObject childObject = (StreamObject)value;
                JsonElement childElement = StreamObjectToJsonConverter.toJson(childObject);
                jsonObject.add((String)key, childElement);
                continue;
            }
            if (!(value instanceof String)) continue;
            jsonObject.addProperty((String)key, (String)value);
        }
        return jsonObject;
    }

    private static JsonArray toJson(StreamVector streamVector) {
        JsonArray jsonArray = new JsonArray();
        Enumeration e = streamVector.elements();
        while (e.hasMoreElements()) {
            Object item = e.nextElement();
            if (item instanceof StreamObject) {
                StreamObject childObject = (StreamObject)item;
                JsonElement childElement = StreamObjectToJsonConverter.toJson(childObject);
                jsonArray.add(childElement);
                continue;
            }
            if (!(item instanceof String)) continue;
            jsonArray.add((JsonElement)new JsonPrimitive((String)item));
        }
        return jsonArray;
    }
}

