/**
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.disy.ogc.wpspd.v_1_0_0;

import java.net.URL;
import java.text.MessageFormat;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

import org.xml.sax.SAXException;

public class WpspdUtils {

  private static ObjectFactory OBJECT_FACTORY;

  public static ObjectFactory createObjectFactory() {
    if (OBJECT_FACTORY == null) {
      OBJECT_FACTORY = new ObjectFactory();
    }
    return OBJECT_FACTORY;
  }

  private static Schema SCHEMA;

  public static Schema createSchema() throws SAXException {

    if (SCHEMA != null) {
      return SCHEMA;
    }
    else {

      final SchemaFactory schemaFactory = SchemaFactory
          .newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

      final URL schemaResource = WpspdUtils.class.getClassLoader().getResource(
          "wps-pd/1.0.0/wps-pd.xsd"); //$NON-NLS-1$

      SCHEMA = schemaFactory.newSchema(new StreamSource(schemaResource.toString()));
      return SCHEMA;
    }

  }

  private static JAXBContext CONTEXT = null;

  public static JAXBContext createJaxbContext() {
    if (CONTEXT == null) {
      try {
        CONTEXT = JAXBContext.newInstance(WpspdConstants.CONTEXT_PATH);
      }
      catch (JAXBException jaxbex) {
        throw new ExceptionInInitializerError(MessageFormat.format(
            "Could not create a JAXB context for the context path [{0}].",
            WpspdConstants.CONTEXT_PATH));
      }
    }
    return CONTEXT;
  }

}
