/*
 * Decompiled with CFR 0.152.
 */
package net.disy.legato.mojo;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MojoGoal(value="concatenate")
@MojoPhase(value="generate-sources")
public class ConcatenateFilesMojo
extends AbstractMojo {
    private MavenProject project;
    private String encoding;
    private File[] fileSetDescriptors;
    private File sourceDirectory;
    private File targetDirectory;
    private boolean addCompileSourceRoot = false;
    private boolean addResource = false;
    private String targetFile;
    private String delimiter = "\n";

    @MojoParameter(expression="${project}", required=true, readonly=true)
    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    @MojoParameter(expression="${project.build.sourceEncoding}", required=false, readonly=true)
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @MojoParameter(required=true)
    public File[] getFileSetDescriptors() {
        return this.fileSetDescriptors;
    }

    public void setFileSetDescriptor(File[] filesDescriptors) {
        this.fileSetDescriptors = filesDescriptors;
    }

    @MojoParameter(required=true)
    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File directory) {
        this.sourceDirectory = directory;
    }

    @MojoParameter(required=true)
    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    @MojoParameter(defaultValue="false")
    public boolean getAddCompileSourceRoot() {
        return this.addCompileSourceRoot;
    }

    public void setAddCompileSourceRoot(boolean sourceRoot) {
        this.addCompileSourceRoot = sourceRoot;
    }

    @MojoParameter(defaultValue="false")
    public boolean getAddResource() {
        return this.addResource;
    }

    public void setAddResource(boolean addResource) {
        this.addResource = addResource;
    }

    @MojoParameter(required=true)
    public String getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }

    @MojoParameter(defaultValue="\n")
    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] fileSetDescriptors;
        this.getLog().info((CharSequence)("Encoding is set to: " + this.getEncoding()));
        for (File fileSetDescriptor : fileSetDescriptors = this.getFileSetDescriptors()) {
            if (fileSetDescriptor.isFile()) continue;
            throw new MojoExecutionException("Fileset descriptor [" + fileSetDescriptor.getAbsolutePath() + "] must point to a file.");
        }
        File sourceDirectory = this.getSourceDirectory();
        if (!sourceDirectory.isDirectory()) {
            throw new MojoExecutionException("Source directory [" + sourceDirectory.getAbsolutePath() + "] must point to a directory.");
        }
        try {
            this.concatFiles();
            if (this.getAddCompileSourceRoot()) {
                this.getProject().addCompileSourceRoot(this.getTargetDirectory().getAbsolutePath());
            }
            if (this.getAddResource()) {
                Resource resource = new Resource();
                resource.setDirectory(this.getTargetDirectory().getAbsolutePath());
                resource.addInclude(this.getTargetFile());
                this.getProject().addResource(resource);
            }
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Error concatenating the files.", (Exception)ioex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getFiles() throws IOException {
        LinkedList<File> files;
        block4: {
            files = new LinkedList<File>();
            File[] fileSetDescriptors = this.getFileSetDescriptors();
            if (fileSetDescriptors == null) break block4;
            for (File fileSetDescriptor : fileSetDescriptors) {
                FileReader reader = null;
                try {
                    reader = new FileReader(fileSetDescriptor);
                    List readLines = IOUtils.readLines((Reader)reader);
                    for (String name : readLines) {
                        files.add(this.getFile(fileSetDescriptor, name));
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        return files;
    }

    public File getFile(File fileSetDescriptor, String name) {
        if (name.startsWith("/")) {
            return new File(this.getSourceDirectory(), name.substring(1));
        }
        return new File(fileSetDescriptor.toURI().resolve(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void concatFiles() throws IOException {
        Writer writer = null;
        try {
            File targetFile = new File(this.getTargetDirectory(), this.getTargetFile());
            targetFile.getParentFile().mkdirs();
            if (null != this.getEncoding()) {
                this.getLog().info((CharSequence)("Writing aggregated file with encoding '" + this.getEncoding() + "'"));
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), this.getEncoding()));
            } else {
                this.getLog().info((CharSequence)"WARNING: writing aggregated file with system encoding");
                writer = new FileWriter(targetFile);
            }
            for (File file : this.getFiles()) {
                Reader reader = null;
                try {
                    if (null != this.getEncoding()) {
                        this.getLog().info((CharSequence)("Reading file " + file.getCanonicalPath() + " with encoding  '" + this.getEncoding() + "'"));
                        reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.getEncoding()));
                    } else {
                        this.getLog().info((CharSequence)("WARNING: Reading file " + file.getCanonicalPath() + " with system encoding"));
                        reader = new FileReader(file);
                    }
                    IOUtils.copy((Reader)reader, (Writer)writer);
                    String delimiter = this.getDelimiter();
                    if (delimiter != null) {
                        writer.write(delimiter.toCharArray());
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }
}

