/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Polygon = OpenLayers.Class(WPS.Result.Geometry, {
  coordinates :null,

  initialize : function(id, map, coordinates, options) {
    WPS.Result.Geometry.prototype.initialize.apply(this, [ id, map, options ]);
    Legato.Util.Ensure.ensureArray(coordinates, "coordinates should be defined as array");
    this.coordinates = coordinates;
  },

  destroy : function() {
    this.coordinates = null;
    WPS.Result.Geometry.prototype.destroy.apply(this, arguments);
  },

  createResultGeometry : function() {
    var geometryToRender = {
      "type" : "Polygon",
      "coordinates" : this.coordinates
    };
    return geometryToRender;
  },

  CLASS_NAME :'WPS.Result.Polygon'
});

WPS.Result.Polygon.ComplexFactory = OpenLayers.Class(
    WPS.Result.ComplexFactory, {
      schema :'http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#Polygon',
      name : new Legato.XML.QName('http://www.opengis.net/gml', 'Polygon', 'gml'),
      createResult : function(id, outputData, options) {
        var complexData = outputData.data.complexData;
        var value = complexData.content[0].value;
        var type = value.type;
        var coordinates = value.coordinates;
        return new WPS.Result.Polygon(id, this.map, coordinates, options);

      },
      CLASS_NAME :'WPS.Result.Polygon.ComplexFactory'
    });