/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.AbstractInput = OpenLayers.Class(WPS.Component, {

  container : null,
  titleElement : null,
  checkedBox : null,
  validitySymbol : null,
  hidden : false,

  initializeAdditionalElements : function(id, model, map, options) {

    this.container = document.createElement('div');
    this.container.id = this.id + '_Container';
    if (this.model.required) {
      OpenLayers.Element.addClass(this.container, 'required');
    }
    this.container.onmouseover = OpenLayers.Function.bindAsEventListener(
        this.hoverIn, this);
    this.container.onmouseout = OpenLayers.Function.bindAsEventListener(
        this.hoverOut, this);
    this.container.component = this;


    var checkedElement = document.createElement('div');
    OpenLayers.Element.addClass(checkedElement, 'isInputChecked');

    this.container.appendChild(checkedElement);

    this.checkedBox = document.createElement('input');
    this.checkedBox.type = 'checkbox';
    this.checkedBox.name = this.id + '_Checked';
    this.checkedBox.checked = this.model.checked;
    this.checkedBox.onclick = OpenLayers.Function.bindAsEventListener(
        this.checkedChanged, this);
    checkedElement.appendChild(this.checkedBox);

    this.validitySymbol = document.createElement('div');
    OpenLayers.Element.addClass(this.validitySymbol, 'validitySymbol');
    this.container.appendChild(this.validitySymbol);

    this.titleElement = document.createElement('div');
    OpenLayers.Element.addClass(this.titleElement, 'title');
    this.titleElement.innerHTML = model.title;
    this.container.appendChild(this.titleElement);

    var inputElement = this.initializeInputs();
    /*jslint sub:true*/
    inputElement.title = model['abstract'];

    this.initializeMetaData();
    this.updateValiditySymbol();
  },
  destroy : function() {

    WPS.Component.prototype.destroy.apply(this, arguments);

    this.container = null;

    if (Legato.Lang.ObjectUtils.exists(this.checkedBox)) {
      this.checkedBox.onclick = null;
      this.checkedBox = null;
    }

    if (Legato.Lang.ObjectUtils.exists(this.container)) {
      this.container.component = null;
      this.container.onmouseover = null;
      this.container.onmouseout = null;
      this.container = null;
    }
  },

  initializeInputs : function() {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
        ' must implement the initializeInputs function from from abstract class ' +
        WPS.Component.CLASS_NAME);
  },

  initializeMetaData : function() {
    if (!Legato.Lang.ObjectUtils.isNotEmptyArray(this.model.metadata)) {
      return;
    }
    for ( var i = 0; i < this.model.metadata.length; i++) {
      this.handleMetaData(this.model.metadata[i]);
    }
  },

  handleMetaData : function(metadata) {
    var about = Legato.Lang.ObjectUtils.exists(metadata.about) ? metadata.about : null;
    var href = Legato.Lang.ObjectUtils.exists(metadata.href) ? metadata.href : null;
    var title = Legato.Lang.ObjectUtils.exists(metadata.title) ? metadata.title : null;

    if (about === 'visibility' && href === 'hidden') {
      this.hidden = true;
      Legato.XML.ElementUtils.hide(this.container);
    }
  },

  isAccessable : function(){
    return OpenLayers.Element.visible(this.container);
  },

  checkedChanged : function(event) {
    var checked = (event.target || event.srcElement).checked;
    this.model.setChecked(checked);
  },


  onModelValueChange : function(event) {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
        ' must implement the onModelValueChange function from from abstract class ' +
        WPS.Component.CLASS_NAME);
  },

  updateValiditySymbol : function() {
    this.validitySymbol.title = '';
    if (this.model.valid) {
      OpenLayers.Element.addClass(this.container, 'valid');
      OpenLayers.Element.removeClass(this.container, 'invalid');
    } else {
      OpenLayers.Element.addClass(this.container, 'invalid');
      OpenLayers.Element.removeClass(this.container, 'valid');
      this.validitySymbol.title += this.model.validationMessages.join('; ');
    }
  },

  onModelValidityChange : function(event) {
    this.updateValiditySymbol();
    this.events.triggerEvent('validitychange', {
      component : this
    });
  },

  appendTo: function(componentsElement) {
    componentsElement.appendChild(this.container);
  },

  activate : function() {
    this.onActivation();
  },

  deactivate : function() {
    this.onDeactivation();
  },

  onActivation : function(triggerEvent) {
    WPS.Component.prototype.onActivation.apply(this, arguments);
    this.replaceStatusClass('inputContainerActive');
    this.checkedBox.checked = true;
  },

  onDeactivation : function(triggerEvent) {
    this.status = WPS.Component.STATUS_INACTIVE;
    this.replaceStatusClass('inputContainerInactive');
    if (triggerEvent) {
      this.events.triggerEvent('deactivate', {
        component : this
      });
    }
  },

  onHoverIn : function() {
    var formerStatus = this.status;
    WPS.Component.prototype.onHoverIn.apply(this, arguments);
    if (WPS.Component.STATUS_INACTIVE === formerStatus) {
      this.replaceStatusClass('inputContainerInactiveHover');
    } else {
      this.replaceStatusClass('inputContainerActiveHover');
    }
  },

  onHoverOut : function(triggerEvent) {
    var formerStatus = this.status;
    WPS.Component.prototype.onHoverOut.apply(this, arguments);
    if (WPS.Component.STATUS_ACTIVE_HOVER === formerStatus) {
      this.replaceStatusClass('inputContainerActive');
    } else {
      this.replaceStatusClass('inputContainerInactive');
    }
  },

  replaceStatusClass : function(currentClass) {
    if (this.container) {
      OpenLayers.Element.removeClass(this.container,
          'inputContainerInactive');
      OpenLayers.Element.removeClass(this.container,
          'inputContainerInactiveHover');
      OpenLayers.Element.removeClass(this.container,
          'inputContainerActive');
      OpenLayers.Element.removeClass(this.container,
          'inputContainerActiveHover');
      OpenLayers.Element.addClass(this.container,
          currentClass);
    }
  },

  CLASS_NAME : 'WPS.Component.AbstractInput'
});

