/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPSPD.Result.Marker = OpenLayers
    .Class(
        WPS.Result,
        {
          map : null,
          factory : null,
          marker : null,

          initialize : function(id, map, factory, marker, options) {
            WPS.Result.prototype.initialize.apply(this, [ id, options ]);
            Legato.Util.Ensure.ensureExists(map, 'map should be defined');
            Legato.Util.Ensure.ensureExists(factory, 'factory should be defined');
            Legato.Util.Ensure.ensureExists(marker, 'marker should be defined');
            this.map = map;
            this.factory = factory;
            this.marker = marker;
          },
          execute : function(executionContext) {
            this.createAndAddMarkerFeature(executionContext);
          },
          createAndAddMarkerFeature : function(executionContext) {

            var feature;

            if (Legato.Lang.ObjectUtils.exists(this.marker.geometry)) {
              var outputData = {
                data : {
                  complexData : {
                    schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Geometry',
                    mimeType : 'text/xml',
                    encoding : 'utf-8',
                    content : [ this.marker.geometry ]
                  }
                }
              };
              var geometryResult = this.factory.createSingleNormalResult(outputData, null, null);
              feature = geometryResult.createFeature();
            } else if (Legato.Lang.ObjectUtils.exists(this.marker.position) && Legato.Lang.ObjectUtils.isArray(this.marker.position.value)
                && (this.marker.position.value.length) >= 2 && Legato.Lang.ObjectUtils.isNumber(this.marker.position.value[0])
                && Legato.Lang.ObjectUtils.isNumber(this.marker.position.value[1])) {
              feature = new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(this.marker.position.value[0], this.marker.position.value[1]));
            } else {
              throw new Legato.Lang.Exception("Marker contains neither geometry nor position.");
            }
            executionContext.getOrCreateFeatureLayer().addFeatures([ feature ]);

            var geometry = feature.geometry;

            if (Legato.Lang.ObjectUtils.exists(this.marker.message)) {

              // Create message
              // Add message to feature
              var messageOutputData = {
                data : {
                  complexData : {
                    schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Message',
                    mimeType : 'text/xml',
                    encoding : 'utf-8',
                    content : [ this.marker.message ]
                  }
                }
              };

              var messageResult = this.factory.createSingleNormalResult(messageOutputData, null, null);
              var messageContent = messageResult.createContent();
              var messageContentText = Legato.Lang.ObjectUtils.isString(messageContent) ? messageContent : messageContent.innerHTML;

              var geometries = (geometry.CLASS_NAME === 'OpenLayers.Geometry.MultiPoint' || geometry.CLASS_NAME === 'OpenLayers.Geometry.MultiLineString' || geometry.CLASS_NAME === 'OpenLayers.Geometry.MultiPolygon') ? geometry.components
                  : [ geometry ];

              var click = function(evt) {
                this.popup.toggle();
                OpenLayers.Event.stop(evt);
              };

              for ( var cindex = 0; cindex < geometries.length; cindex++) {
                var centroid = geometries[cindex].getCentroid();
                var lonlat = new OpenLayers.LonLat(centroid.x, centroid.y);
                var popup = new OpenLayers.Popup.FramedCloud(
                // id
                null,
                // lonlat
                lonlat,
                // contentSize
                null,
                // contentHTML
                messageContentText,
                // anchor
                null,
                // closeBox
                true,
                // closeBoxCallback
                null);
                popup.panMapIfOutOfView = false;
                popup.closeOnMove = true;
                popup.autoSize = true;
                popup.hide();
                var marker = new Legato.Marker.PopupMarker(lonlat, OpenLayers.Marker.defaultIcon(), popup);
                marker.events.register('click', marker, click);
                executionContext.getOrCreateMarkersLayer().addMarker(marker);
              }
            }
            return feature;
          },
          destroy : function() {
            this.marker = null;
            WPS.Result.prototype.destroy.apply(this, arguments);
          },

          CLASS_NAME : 'WPSPD.Result.Marker'
        });

WPSPD.Result.Marker.ComplexFactory = OpenLayers.Class(WPS.Result.ComplexFactory, {
  schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Marker',

  name : new Legato.XML.QName('http://www.disy.net/pd', 'Marker', 'pd'),

  map : null,

  factory : null,

  initialize : function(map, factory) {
    Legato.Util.Ensure.ensureExists(map, 'map should be defined');
    Legato.Util.Ensure.ensureExists(factory, 'factory should be defined');
    this.map = map;
    this.factory = factory;
  },

  createResult : function(id, outputData, options) {
    var complexData = outputData.data.complexData;
    var value = complexData.content[0].value;

    return new WPSPD.Result.Marker(id, this.map, this.factory, value, options);

  },
  CLASS_NAME : 'WPSPD.Result.Marker.ComplexFactory'
});