/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.ProcessDescription = OpenLayers.Class(WPS.Result, {
  form : null,
  processDescription : null,
  initialize : function(id, form, processDescription, options) {
    WPS.Result.prototype.initialize.apply(this, [ id, options ]);
    Legato.Util.Ensure.ensureExists(form, 'form should be defined');
    Legato.Util.Ensure.ensureExists(processDescription,
        'process description should be defined');
    this.form = form;
    this.processDescription = processDescription;
  },

  execute : function() {
    this.form.activateProcessDescription(this.processDescription);
  },

  createContent : function() {
    throw new Legato.Lang.Exception("Not supported.");
  },

  destroy : function() {
    WPS.Result.prototype.destroy.apply(this, arguments);
    this.form = null;
    this.processDescription = null;
  },

  CLASS_NAME : 'WPS.Result.ProcessDescription'
});

WPS.Result.ProcessDescription.ComplexFactory = OpenLayers
    .Class(
        WPS.Result.ComplexFactory,
        {
          schema : 'http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd#ProcessDescription',
          name : new Legato.XML.QName('http://www.opengis.net/wps/1.0.0',
              'ProcessDescription', 'wps'),
          initialize : function(map, form) {
            Legato.Util.Ensure.ensureExists(map, 'map should be defined');
            Legato.Util.Ensure.ensureExists(form, 'form should be defined');
            this.map = map;
            this.form = form;
          },
          createResult : function(id, outputData, options) {
            return new WPS.Result.ProcessDescription(id, this.form,
                outputData.data.complexData.content[0].value, options);
          },
          destroy : function() {
            WPS.Result.ComplexFactory.prototype.destroy.apply(
                this, arguments);
            this.form = null;
          },
          CLASS_NAME : 'WPS.Result.ProcessDescription.ComplexFactory'
        });