/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.MultiPolygon = OpenLayers.Class(WPS.Result.Geometry, {
  coordinates :null,

  initialize : function(id, map, coordinates, options) {
    WPS.Result.Geometry.prototype.initialize.apply(this, [ id, map, options ]);
    Legato.Util.Ensure.ensureArray(coordinates, "coordinates should be defined as array");
    this.coordinates = coordinates;
  },

  destroy : function() {
    this.coordinates = null;
    WPS.Result.Geometry.prototype.destroy.apply(this, arguments);
  },

  createResultGeometry : function() {
    var geometryToRender = {
      "type" : "MultiPolygon",
      "coordinates" : this.coordinates
    };
    return geometryToRender;
  },

  CLASS_NAME :'WPS.Result.MultiPolygon'
});

WPS.Result.MultiPolygon.ComplexFactory = OpenLayers.Class(
    WPS.Result.ComplexFactory, {
      schema :'http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#MultiPolygon',
      name : new Legato.XML.QName('http://www.opengis.net/gml', 'MultiPolygon', 'gml'),
      createResult : function(id, outputData, options) {
        var complexData = outputData.data.complexData;
        var value = complexData.content[0].value;
        var type = value.type;
        var coordinates = value.coordinates;
        return new WPS.Result.MultiPolygon(id, this.map, coordinates, options);

      },
      CLASS_NAME :'WPS.Result.MultiPolygon.ComplexFactory'
    });