/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Link = OpenLayers.Class(WPS.Result, {
  href :null,
  show :null,
  actuate :null,
  contentType :null,

  initialize : function(id, href, options) {
    WPS.Result.prototype.initialize.apply(this, [ id,
        options ]);
    Legato.Util.Ensure.ensureString(href, "href should be defined");
    this.href = href;
  },

  destroy : function() {
    this.href = null;
    this.show = null;
    this.actuate = null;
    this.contentType = null;
    WPS.Result.prototype.destroy.apply(this, arguments);
  },

  createContent : function() {
    if (this.show === 'embed') {
      // If it is an image
      if (Legato.Lang.ObjectUtils.exists(this.contentType)
          && (this.contentType.substring(0, 6) === 'image/')) {
        var img = document.createElement('img');
        img.id = this.id;
        img.src = this.href;
        img.title = this.title;
        return img;
      }
      // If it is something else
      else {
        var iframe = document.createElement('iframe');
        iframe.id = this.id;
        iframe.src = this.href;
        iframe.title = this.title;
        return iframe;
      }
    } else {
      var a = document.createElement('a');
      a.id = this.id;
      a.href = this.href;
      a.innerHTML = Legato.Lang.ObjectUtils.exists(this.title) ? this.title : this.href;
      a.target = this.show === 'new' ? '_blank' : '_self';
      return a;
    }
  },

  execute : function() {
    this.navigateToLocation(this.href);
  },

  navigateToLocation : function(location) {
    if (this.show === 'new')
    {
      window.open(location);
    }
    else if (this.show === 'replace')
    {
      window.location = location;
    }
    else
    {
      window.open(location);
    }
  },

  CLASS_NAME :'WPS.Result.Link'
});

WPS.Result.Link.ComplexFactory = OpenLayers.Class(
    WPS.Result.ComplexFactory, {
      schema :'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Link',
      name :new Legato.XML.QName('http://www.disy.net/pd', 'Link', 'pd'),
      createResult : function(id, outputData, options) {
        var complexData = outputData.data.complexData;
        var value = complexData.content[0].value;
        var href = value.href;
        options.show = value.show;
        options.actuate = value.actuate;
        options.contentType = value.contentType;
        return new WPS.Result.Link(id, href, options);

      },
      CLASS_NAME :'WPS.Result.Link.ComplexFactory'
    });