/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.ExecutionContext = OpenLayers.Class({
  map : null,
  featureLayer : null,
  markersLayer : null,
  initialize : function(map) {
    this.map = map;
    Legato.Util.Ensure.ensureExists(map, 'Execution context must be defined with a map parameter.');
  },
  getOrCreateFeatureLayer : function() {
    if (!Legato.Lang.ObjectUtils.exists(this.featureLayer)) {
      this.featureLayer = this.createFeatureLayer();
    }
    return this.featureLayer;
  },
  createFeatureLayer : function() {
    var layerOptions = {
      isFeatureLayer : true,
      legatoIgnore : true,
      // indicate that the temp vector layer will never be out of range
      // without this, resolution properties must be specified at the
      // map-level for this temporary layer to init its resolutions
      // correctly
      calculateInRange : function() {
        return true;
      }
    };
    var layer = new OpenLayers.Layer.Vector(WPS.I18n.getMessage('WPS.Result.ExecutionContext.ResultLayerName'), layerOptions);
    layer.style = WPS.Feature.Style.ACTIVE;
    this.map.addLayer(layer);
    return layer;
  },
  getOrCreateMarkersLayer: function()
  {
    if (!Legato.Lang.ObjectUtils.exists(this.markersLayer)) {
      this.markersLayer = this.createMarkersLayer();
    }
    return this.markersLayer;
  },
  createMarkersLayer : function() {
    var layerOptions = {
        isMarkersLayer : true
    };
    var layer = new OpenLayers.Layer.Markers(WPS.I18n.getMessage('WPS.Result.ExecutionContext.MarkerLayerName'), layerOptions);
    this.map.addLayer(layer);
    return layer;
  },
  destroy : function() {
    this.map = null;
  },
  CLASS_NAME : 'WPS.Result.ExecutionContext'
});