/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Predicate.Metadata = OpenLayers.Class( {
  about :'tag',
  value :null,
  initialize : function(value, options) {
    Legato.Util.Ensure.ensureString(value);
    this.value = value;
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(processDescription) {
    var metadata = processDescription.metadata;
    for ( var index = 0; index < metadata.length; index++) {
      var item = metadata[index];
      if (item.about === this.about) {
        if (this.value === item.href) {
          return true;
        }
      }
    }
    return false;
  },
  CLASS_NAME :'WPS.Predicate.Metadata'
});