/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Model.Process = OpenLayers.Class({

	EVENT_TYPES : [ 'validitychange' ],

	map : null,

	processDescription : null,

	processIdentifier : null,

	modelFactory : null,

	models : null,

	events : null,

	initialize : function(map, processDescription, options) {
		OpenLayers.Util.extend(this, options);
		this.events = new OpenLayers.Events(this, null, this.EVENT_TYPES);
		this.map = map;
		this.processDescription = processDescription;
		this.processIdentifier = processDescription.identifier.value;
		this.models = [];
		if (!Legato.Lang.ObjectUtils.exists(this.modelFactory)) {
			this.modelFactory = new WPS.Model.Factory(this.map);
		}
		if (this.processDescription.dataInputs
				&& this.processDescription.dataInputs.input) {
			var inputDescriptions = this.processDescription.dataInputs.input;
			for ( var index = 0; index < inputDescriptions.length; index++) {
				var inputDescription = inputDescriptions[index];
				var model = this.modelFactory.createModel(inputDescription);
				this.models.push(model);
			}
		}
	},

	destroy : function() {
		if (Legato.Lang.ObjectUtils.exists(this.events)) {
			this.events.destroy();
			this.events = null;
		}
		this.processDescription = null;
		if (Legato.Lang.ObjectUtils.exists(this.modelFactory)) {
			this.modelFactory.destroy();
			this.modelFactory = null;
		}
		if (Legato.Lang.ObjectUtils.exists(this.models)) {
			for ( var index = 0; index < this.models.length; index++) {
				this.models[index].destroy();
			}
			this.models = null;
		}
	},

	getData : function() {
		var inputs = [];
		for ( var index = 0; index < this.models.length; index++) {
			var modelData = this.models[index].getData();
			if (Legato.Lang.ObjectUtils.exists(modelData)) {
				for ( var jndex = 0; jndex < modelData.length; jndex++) {
					inputs.push(modelData[jndex]);
				}
			}
		}
		var data = {
			service : 'WPS',
			version : '1.0.0',
			identifier : this.processDescription.identifier,
			dataInputs : {
				input : inputs
			}
		};
		return data;
	},

	needsUserInput : function() {
		for ( var index = 0; index < this.models.length; index++) {
			if (this.models[index].needsUserInput()) {
				return true;
			}
		}
		return false;
	},

	CLASS_NAME : 'WPS.Model.Process'
});