/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Model.Complex = OpenLayers.Class(WPS.Model, {

  defaultFormat : null,

  populateData : function(data) {
    data.data.complexData = {};
    data.data.complexData.content = this.getContent();
    if (Legato.Lang.ObjectUtils.exists(this.defaultFormat) && Legato.Lang.ObjectUtils.exists(this.defaultFormat.schema)) {
      data.data.complexData.schema = this.defaultFormat.schema;
    }
    return data;
  },

  getContent: function() {
    return this.inverse(this.getValue());
  },

  setContent: function( content ) {
    this.setValue(this.direct(content));
  },

  setDefaultContent: function( content ) {
    this.setDefaultValue(this.direct(content));
  },

  direct: function( content ) {
    return content;
  },

  inverse: function( content ) {
    return content;
  },

  getSchema: function() {
    if (this.defaultFormat === null) { return null; }
    return this.defaultFormat.schema;
  },

  CLASS_NAME :'WPS.Model.Complex'
});