/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.Process = OpenLayers
    .Class({

      EVENT_TYPES : [ 'geoInputActivation' ],

      processModel : null,

      processIdentifier : null,

      processTitle : null,

      processAbstract : null,

      componentFactory : null,

      components : null,

      container : null,

      titleElement : null,

      abstractElement : null,

      componentsElement : null,

      executeElement : null,

      map : null,

      currentComponentId : null,

      activated : false,

      valid : false,

      events : null,

      buttonsElement : null,

      executeButton : null,

      executeCallback : null,

      cancelCallback : null,

      validationErrorElement : null,

      validationErrorContainer : null,

      txtExecute : null,

      txtCancel : null,

      hideCancelButton : null,

      componentFactoryOptions : null,

      initialize : function(processModel, map, executeCallback, cancelCallback, options) {
        Legato.Util.Ensure.ensureExists(processModel, "model should be defined");
        Legato.Util.Ensure.ensureExists(map, "map should be defined");
        Legato.Util.Ensure.ensureFunction(executeCallback, "execute callback should be a function");
        Legato.Util.Ensure.ensureFunction(cancelCallback, "cancel callback should be a function");
        this.processModel = processModel;
        this.processIdentifier = processModel.processIdentifier;
        this.executeCallback = executeCallback;
        this.cancelCallback = cancelCallback;
        OpenLayers.Util.extend(this, options);
        this.events = new OpenLayers.Events(this, null, this.EVENT_TYPES);

        if (!Legato.Lang.ObjectUtils.isObject(this.componentFactoryOptions)) {
          this.componentFactoryOptions = {};
        }

        if (processModel.processDescription.title) {
          this.processTitle = processModel.processDescription.title.value;
        }
        /*jslint sub:true */
        if (processModel.processDescription['abstract']) {
          /*jslint sub:true*/
          this.processAbstract = processModel.processDescription['abstract'].value;
        }
        this.map = map;
        if (!Legato.Lang.ObjectUtils.exists(this.componentFactory)) {
          this.componentFactory = new WPS.Component.Factory(map, this.componentFactoryOptions);
        }

        if (!Legato.Lang.ObjectUtils.isString(this.txtExecute)) {
          this.txtExecute = WPS.I18n.getMessage('WPS.Button.OK');
        }

        if (!Legato.Lang.ObjectUtils.isString(this.txtCancel)) {
          this.txtCancel = WPS.I18n.getMessage('WPS.Button.Cancel');
        }

        if (!Legato.Lang.ObjectUtils.isTrue(this.hideCancelButton)) {
            this.hideCancelButton = false;
        }

        this.createProcessForm();
        this.validate();
        this.activate();
      },

      createProcessForm : function() {
        if (this.container === null) {
          this.container = document.createElement('div');
          this.container.className = 'wpsContainer';
        }

        this.titleElement = document.createElement('div');
        this.titleElement.className = 'wpsProcessTitle';
        this.titleElement.innerHTML = this.processModel.processDescription.title.value;
        this.container.appendChild(this.titleElement);

        this.abstractElement = document.createElement('div');
        this.abstractElement.className = 'wpsProcessAbstract';
        /*jslint sub:true*/
        this.abstractElement.innerHTML = this.processModel.processDescription['abstract'].value;
        this.container.appendChild(this.abstractElement);

        this.validationErrorContainer = document.createElement('div');
        this.validationErrorContainer.className = 'validationError';
        Legato.XML.ElementUtils.hide(this.validationErrorContainer);
        this.container.appendChild(this.validationErrorContainer);

        this.loadingIndicatorContainer = document.createElement('div');
        this.loadingIndicatorContainer.className = 'loadingIndicatorContainer';
        this.loadingSpinner = document.createElement('div');
        this.loadingSpinner.className = 'loadingSpinner';
        this.loadingIndicatorContainer.appendChild(this.loadingSpinner);
        Legato.XML.ElementUtils.hide(this.loadingIndicatorContainer);
        this.container.appendChild(this.loadingIndicatorContainer);

        var validationErrorIcon = document.createElement('div');
        validationErrorIcon.className = 'validationErrorIcon';
        this.validationErrorContainer.appendChild(validationErrorIcon);

        this.validationErrorElement = document.createElement('div');
        this.validationErrorContainer.appendChild(this.validationErrorElement);

        this.validationErrorContainer.appendChild(this.validationErrorElement);

        this.components = [];
        this.componentsElement = document.createElement('div');
        this.componentsElement.className = 'wpsProcessInputsContainer';
        this.container.appendChild(this.componentsElement);

        for ( var index = 0; index < this.processModel.models.length; index++) {
          var component = this.componentFactory.createComponent(this.processModel.models[index]);
          this.components[index] = component;
          component.appendTo(this.componentsElement);
          component.events.on({
            'activate' : this.componentActivated,
            'deactivate' : this.componentDeactivated,
            'validitychange' : this.componentValidityChanged,
            scope : this
          });
        }

        this.buttonsElement = document.createElement('div');
        this.buttonsElement.className = 'wpsButtons';
        this.container.appendChild(this.buttonsElement);

        this.executeButton = document.createElement('input');
        this.executeButton.type = 'button';
        this.executeButton.value = this.txtExecute;
        this.executeButton.onclick = OpenLayers.Function.bindAsEventListener(this.executeButtonClicked, this);
        this.buttonsElement.appendChild(this.executeButton);

        if (!this.hideCancelButton) {
            var cancelButton = document.createElement('input');
            cancelButton.type = 'button';
            cancelButton.value = this.txtCancel;
            cancelButton.onclick = OpenLayers.Function.bindAsEventListener(this.cancelButtonClicked, this);
            this.buttonsElement.appendChild(cancelButton);
        }
      },

      executeButtonClicked : function() {
        this.showLoadingSpinner();
        var executeRequest = this.processModel.getData();
        this.deactivate();
        this.executeCallback(this, executeRequest);
      },

      showLoadingSpinner : function() {
        this.loadingIndicatorContainer.style.width = this.getContainerElementWidth();
        this.loadingIndicatorContainer.style.height = this.getContainerElementHeight();
        Legato.XML.ElementUtils.show(this.loadingIndicatorContainer);
      },

      hideLoadingSpinner : function() {
        Legato.XML.ElementUtils.hide(this.loadingIndicatorContainer);
      },

      getContainerElementWidth : function() {
        if (Legato.Lang.Function.isInstance(window.getComputedStyle)) {
          return window.getComputedStyle(this.container,null).width;
        }
        return this.container.clientWidth;
      },

      getContainerElementHeight : function() {
        if (Legato.Lang.Function.isInstance(window.getComputedStyle)) {
          return window.getComputedStyle(this.container,null).height;
        }
        return this.container.clientHeight;
      },

      cancelButtonClicked : function() {
        this.deactivate();
        this.cancelCallback(this);
      },

      executeComplete : function() {
        this.hideLoadingSpinner();
      },

      activate : function() {
        var index = 0;
        var component = null;
        if (this.currentComponentId) {
          for (index = 0; index < this.components.length; index++) {
            component = this.components[index];
            if (this.currentComponentId === component.id) {
              component.activate();
            }
          }
        } else {
          for (index = 0; index < this.components.length; index++) {
            component = this.components[index];
            if (component.isAccessable()) {
              component.activate();
            }
          }
        }

        this.activated = true;
        return true;
      },

      deactivate : function() {
        this.activated = false;
        for ( var index = 0; index < this.components.length; index++) {
          var component = this.components[index];
          if (!(WPS.Component.STATUS_INACTIVE === component.status || WPS.Component.STATUS_INACTIVE === component.status)) {
            component.deactivate();
          }
        }
        return true;
      },

      validate : function() {
        Legato.XML.ElementUtils.hide(this.validationErrorContainer);
        var valid = true;
        var firstError = '';
        for ( var i = 0; i < this.components.length; i++) {
          if (!this.components[i].model.valid) {
            valid = false;
            firstError = this.components[i].model.validationMessages[0];
            break;
          }
        }
        this.valid = valid;
        this.executeButton.disabled = !this.valid;
        if (!valid && this.currentComponentId) {
          // show global validation
          // messages
          // only when a component is
          // already active
          this.validationErrorElement.innerHTML = firstError;
          Legato.XML.ElementUtils.show(this.validationErrorContainer);
        }
      },

      componentActivated : function(event) {
        var changedComponent = event.component;
        this.currentComponentId = changedComponent.id;
        for ( var index = 0; index < this.components.length; index++) {
          var component = this.components[index];
          if (!(WPS.Component.STATUS_INACTIVE === component.status || WPS.Component.STATUS_INACTIVE_HOVER === component.status || changedComponent.id === component.id)) {
            component.deactivate();
          }
        }
        if (changedComponent.CLASS_NAME === 'WPS.Component.Point' || changedComponent.CLASS_NAME === 'WPS.Component.MultiPoint'
            || changedComponent.CLASS_NAME === 'WPS.Component.LineString' || changedComponent.CLASS_NAME === 'WPS.Component.MultiLineString'
            || changedComponent.CLASS_NAME === 'WPS.Component.Polygon' || changedComponent.CLASS_NAME === 'WPS.Component.MultiPolygon') {
          this.events.triggerEvent('geoInputActivation', {
            component : this
          });
        }
      },

      componentDeactivated : function(event) {
        var changedComponent = event.component;
        if (this.activated && changedComponent.id === this.currentComponentId) {
          this.currentComponentId = null;
        }
      },

      componentValidityChanged : function(event) {
        this.validate();
      },

      destroy : function() {
        this.deactivate();
        for ( var index = 0; index < this.processModel.models.length; index++) {
          var component = this.components[index];
          component.events.un({
            'activate' : this.componentActivated,
            'deactivate' : this.componentDeactivated,
            'validitychange' : this.componentValidityChanged,
            scope : this
          });
          component.destroy();
        }
        this.components = [];
        this.componentsElement.innerHTML = '';
        this.componentsElement = null;
        if (Legato.Lang.ObjectUtils.exists(this.events)) {
          this.events.destroy();
          this.events = null;
        }
        this.executeCallback = null;
        this.cancelCallback = null;
      },

      CLASS_NAME : 'WPS.Component.Process'
    });