/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.MultiLineString = OpenLayers.Class(WPS.Component.AbstractGeometry, {
  geometryType : 'MultiLineString',

  createGeoInputControl : function() {
    return new Legato.Control.DrawMultiLineString(this.layer, {
      title : WPS.I18n.getMessage('WPS.MultiLineString.Draw'),
      mode : Legato.Control.DrawFeature.MODE_ADD_FEATURE,
      type : OpenLayers.Control.TYPE_TOGGLE,
      style : this.getDefaultStyle()
    });
  },
  createGeoModifyControl : function() {
    return new Legato.Control.ModifyMultiLineString(this.layer, {
      title : WPS.I18n.getMessage('WPS.MultiLineString.Edit'),
      mode : Legato.Control.ModifyFeature.MODE_RESHAPE,
      style : this.getDefaultStyle()
    });
  },
  getDefaultStyle : function(){
    return this.getNamedStyle('Line');
  },
  getLayerGeometry : function() {
    var geometries = this.getLayerGeometries();
    if (Legato.Lang.ObjectUtils.isArray(geometries)) {
      if (geometries.length > 0) {
        return new OpenLayers.Geometry.MultiLineString(geometries);
      } else {
        return null;
      }
    } else {
      return null;
    }
  },
  setLayerGeometry : function(geometry) {
    if (Legato.Lang.ObjectUtils.exists(geometry)) {
      // Must be a MultiLineString
      this.setLayerGeometries(geometry.components);
    } else {
      this.setLayerGeometries(null);
    }
  },
  CLASS_NAME : 'WPS.Component.MultiLineString'
});