/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.BoundingBox = OpenLayers.Class(WPS.Component, {

  initialize : function(id, model, map, options) {
    WPS.Component.prototype.initialize.apply(this, arguments);

    this.map.events.on({
      'moveend' : this.onMoveEnd,
      scope : this
    });
    this.setExtent();
  },
  onMoveEnd : function(event) {
    this.setExtent();
  },

  setExtent : function() {
    var extent = this.map.getExtent();
    this.model.setExtent(extent);
  },

  destroy : function() {
    this.map.events.un({
      'moveend' : this.onMoveEnd,
      scope : this
    });
    WPS.Component.prototype.destroy.apply(this, arguments);
  },

  onModelValueChange : function(event) {

  },

  CLASS_NAME : 'WPS.Component.BoundingBox'
});