/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPSPD.Result.StyledFeatureCollection = OpenLayers
    .Class(
        WPS.Result,
        {
          map : null,
          factory : null,
          styledFeatureCollection : null,

          initialize : function(id, map, factory, styledFeatureCollection, options) {
            WPS.Result.prototype.initialize.apply(this, [ id, options ]);
            Legato.Util.Ensure.ensureExists(map, 'map should be defined');
            Legato.Util.Ensure.ensureExists(factory, 'factory should be defined');
            Legato.Util.Ensure.ensureExists(styledFeatureCollection, 'styledFeatureCollection should be defined');
            this.map = map;
            this.factory = factory;
            this.styledFeatureCollection = styledFeatureCollection;
          },
          execute : function(executionContext) {
            StyledFeatureCollectionController.save(this.styledFeatureCollection, synchronizeViewContext);
          },
          synchronizeViewContext : function(args){
            // Because the map model should now be updatet, we have to refresh the complete map
              var mainLoader = disyCommons.getLegatoBeanFactory().getBean('mainLoader');
              mainLoader.synchronize(onSynchronizeSuccess, onSynchronizeFailure);
          },
          onSynchronizeSuccess : function(){
            // Do nothing more for now
          },
          onSynchronizeFailure : function(){
            // Do nothing more for now
          },
          destroy : function() {
              this.styledFeatureCollection = null;
              WPS.Result.prototype.destroy.apply(this, arguments);
          },

          CLASS_NAME : 'WPSPD.Result.StyledFeatureCollection'
        });

WPSPD.Result.StyledFeatureCollection.ComplexFactory = OpenLayers.Class(WPS.Result.ComplexFactory, {
  schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#StyledFeatureCollection',

  name : new Legato.XML.QName('http://www.disy.net/pd', 'StyledFeatureCollection', 'pd'),

  map : null,

  factory : null,

  initialize : function(map, factory) {
    Legato.Util.Ensure.ensureExists(map, 'map should be defined');
    Legato.Util.Ensure.ensureExists(factory, 'factory should be defined');
    this.map = map;
    this.factory = factory;
  },

  createResult : function(id, outputData, options) {
    var complexData = outputData.data.complexData;
    var styledFeatureCollection = null;
    if (Legato.Lang.ObjectUtils.exists(complexData) && Legato.Lang.ObjectUtils.exists(complexData.content[0])){
      styledFeatureCollection = complexData.content[0];
    }

    return new WPSPD.Result.StyledFeatureCollection(id, this.map, this.factory, styledFeatureCollection, options);

  },
  CLASS_NAME : 'WPSPD.Result.StyledFeatureCollection.ComplexFactory'
});