/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Message = OpenLayers.Class(WPS.Result, {
  message : null,
  format : null,
  initialize : function(id, title, description, message, options) {
    WPS.Result.prototype.initialize.apply(this, [ id, options ]);
    Legato.Util.Ensure.ensureExists(message, 'message should be defined');
    this.message = message;
    this.title = title;
    this.description = description;
    this.format = new OpenLayers.Format.XML();
  },
  execute : function(executionContext) {
    var content = this.createContent();
    if (!Legato.Lang.ObjectUtils.isFunction(this.popupCallback)) {
      var contentText;
      if (Legato.Lang.ObjectUtils.isString(content)) {
        contentText = content;
      } else {
        if (Legato.Lang.ObjectUtils.isString(this.message)) {
          contentText = this.message;
        } else if (Legato.Lang.ObjectUtils.exists(content.outerHTML)) {
          contentText = content.outerHTML;
        } else if (Legato.Lang.ObjectUtils.exists(content.innerHTML)) {
          contentText = content.innerHTML;
        } else {
          contentText = this.format.write(content);
        }
      }
      alert(contentText);
      return;
    } else {
      if (Legato.Lang.ObjectUtils.exists(this.type) && this.type === 'error') {
        this.errorCallback(content);
      } else {

        this.popupCallback(content);
      }
    }
  },

  createContent : function() {

    var resultContainer = this.createResultContainer();

    var resultMessageContainer = document.createElement('div');
    resultMessageContainer.className = 'wpsResult';
    resultContainer.appendChild(resultMessageContainer);

    if (Legato.Lang.ObjectUtils.isString(this.message)) {
      resultMessageContainer.innerHTML = this.message;
    } else {
      if (Legato.Lang.ObjectUtils.exists(this.message.nodeType)) {
        var node;
        if (this.message.nodeType == 9) {
          node = this.message.documentElement;
        }
        var children = node.childNodes;
        var length = children.length;
        var innerHTML = '';
        for ( var index = 0; index < length; index++) {
          var child = children[index];
          innerHTML = innerHTML + this.format.write(child);
        }
        resultMessageContainer.innerHTML = innerHTML;
      }
    }
    if (Legato.Lang.ObjectUtils.isFunction(this.wpsFormOnCallback)) {
      var backProcessButton = document.createElement('input');
      backProcessButton.type = 'button';
      backProcessButton.className = 'wpsResultBackButton';
      backProcessButton.value = WPS.I18n.getMessage('WPS.Button.Back');
      backProcessButton.onclick = this.wpsFormOnCallback;
      resultContainer.appendChild(backProcessButton);
    }
    return resultContainer;
  },

  createResultContainer : function() {
    var resultContainer = document.createElement('div');
    if (Legato.Lang.ObjectUtils.exists(this.id)) {
      resultContainer.id = this.id;
    }

    if (Legato.Lang.ObjectUtils.exists(this.title)) {
      var resultTitle = document.createElement('div');
      resultTitle.className = 'wpsResultTitle';
      resultTitle.innerHTML = this.title;
      resultContainer.appendChild(resultTitle);
    }

    if (Legato.Lang.ObjectUtils.exists(this.description)) {
      var resultAbstract = document.createElement('div');
      resultAbstract.className = 'wpsResultAbstract';
      resultAbstract.innerHTML = this.description;
      resultContainer.appendChild(resultAbstract);
    }
    return resultContainer;
  },

  destroy : function() {
    this.format.destroy();
    this.format = null;
    this.message = null;
    WPS.Result.prototype.destroy.apply(this, arguments);
  },

  CLASS_NAME : 'WPS.Result.Message'
});

WPS.Result.Message.LiteralFactory = OpenLayers.Class(WPS.Result.SimpleFactory, {

  createResult : function(id, outputData, options) {
    var title = null;
    if (Legato.Lang.ObjectUtils.exists(outputData.title) && Legato.Lang.ObjectUtils.isString(outputData.title.value)){
      title = outputData.title.value;
    }
    /*jslint sub: true */
    var descriptionElement = outputData['abstract'];
    var description = null;
    if (Legato.Lang.ObjectUtils.isObject(descriptionElement) && Legato.Lang.ObjectUtils.exists(descriptionElement.value)){
      description = descriptionElement.value;
    }
    var message = outputData.data.literalData.value;
    return new WPS.Result.Message(id, title, description, message, options);
  },

  CLASS_NAME : 'WPS.Result.Message.LiteralFactory'
});

WPS.Result.Message.ComplexFactory = OpenLayers.Class(WPS.Result.ComplexFactory, {

  schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Message',

  name : new Legato.XML.QName('http://www.disy.net/pd', 'Message', 'pd'),

  createResult : function(id, outputData, options) {
    var title = null;
    if (Legato.Lang.ObjectUtils.exists(outputData.title) && Legato.Lang.ObjectUtils.isString(outputData.title.value)){
      title = outputData.title.value;
    }
    /*jslint sub: true */
    var descriptionElement = outputData['abstract'];
    var description = null;
    if (Legato.Lang.ObjectUtils.isObject(descriptionElement) && Legato.Lang.ObjectUtils.exists(descriptionElement.value)){
      description = descriptionElement.value;
    }

    var complexData = outputData.data.complexData;
    var value = complexData.content[0].value;

    if (Legato.Lang.ObjectUtils.exists(value.type) && Legato.Lang.ObjectUtils.isString(value.type)) {
      options.type = value.type;
    } else {
      options.type = 'none';
    }

    return new WPS.Result.Message(id, title, description, value.content, options);
  },
  CLASS_NAME : 'WPS.Result.Message.ComplexFactory'
});