/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Predicate.MapTags = OpenLayers.Class( {
  map :null,
  defaultIncludes :true,
  prefix :'wps:',
  includeInfix :'metadata:tag',
  includeTagName :null,
  predicate :null,
  predicateCallback :null,
  initialize : function(map, options) {
    Legato.Util.Ensure.ensureObject(map);
    this.map = map;
    OpenLayers.Util.extend(this, options);
    this.includeTagName = this.prefix + this.includeInfix;
    this.initializePredicate();
  },
  initializePredicate : function() {
    if (Legato.Lang.ObjectUtils.isArray(this.map.tags)) {
      this.predicate = this.createPredicate(this.map.tags);
    } else {
      this.predicate = this.createDefaultPredicate();
    }
  },
  createDefaultPredicate : function() {
    if (this.defaultIncludes) {
      return new WPS.Predicate.TrueIfTagless();
    } else {
      return new WPS.Predicate.False();
    }
  },
  createPredicate : function(tags) {
    var includePredicates = [];
    includePredicates.push(this.createDefaultPredicate());
    if (Legato.Lang.ObjectUtils.isArray(tags)) {
      for ( var index = 0; index < tags.length; index++) {
        var tag = tags[index];
        if (tag.name == this.includeTagName
            && Legato.Lang.ObjectUtils.isString(tag.value)) {
          includePredicates.push(this.predicateCallback(tag.value));
        }
      }
    }
    if (includePredicates.length === 0) {
      return this.createDefaultPredicate();
    } else {
      return new WPS.Predicate.Or(includePredicates);
    }
  },
  evaluate : function(processDescription) {
    return this.predicate.evaluate(processDescription);
  },
  CLASS_NAME :'WPS.Predicate.MapTags'
});

WPS.Predicate.MapTags.Bean = WPS.Predicate.Bean.Extend('WPS.Predicate.MapTags',
//
    WPS.Predicate.QName('MapTags'),
    //
    {
      _constructor :WPS.Predicate.MapTags,
      constructorArguments : {
        map :Legato.Beans.Object
      },
      constructorOrder : [ 'map' ],
      options : {
        prefix :Legato.Lang.String,
        includeInfix :Legato.Lang.String,
        defaultIncludes :Legato.Lang.Boolean,
        predicateCallback :Legato.Lang.Function
      }
    });
