/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Model.Factory = OpenLayers.Class({

  map : null,

  initialize : function(map) {
    this.map = map;
  },

  createModel : function(inputDescription) {
    var modelOptions = {};
    modelOptions.identifier = inputDescription.identifier.value;
    modelOptions.title = inputDescription.title.value;
    /*jslint sub: true */
    modelOptions['abstract'] = inputDescription['abstract'].value;
    if (Legato.Lang.ObjectUtils.isNotEmptyArray(inputDescription.metadata)) {
      modelOptions.metadata = inputDescription.metadata;
    }
    modelOptions.minOccurs = Legato.Lang.ObjectUtils.exists(inputDescription.minOccurs) ? inputDescription.minOccurs : 1;
    modelOptions.maxOccurs = Legato.Lang.ObjectUtils.exists(inputDescription.maxOccurs) ? inputDescription.maxOccurs : 1;

    var model;
    if (Legato.Lang.ObjectUtils.exists(inputDescription.literalData)) {
      var literalData = inputDescription.literalData;

      modelOptions.dataType = Legato.Lang.ObjectUtils.exists(literalData.dataType) ? literalData.dataType.value : null;
      modelOptions.defaultValue = {
        value : (Legato.Lang.ObjectUtils.exists(literalData.defaultValue) ? literalData.defaultValue : null),
        uom : null
      };
      // TODO uoms
      if (Legato.Lang.ObjectUtils.exists(literalData.allowedValues)) {
        modelOptions.allowedValues = [];
        for ( var i = 0; i < literalData.allowedValues.valueOrRange.length; i++) {
          modelOptions.allowedValues.push(literalData.allowedValues.valueOrRange[i].value);
        }
      } else {
        modelOptions.allowedValues = null;
      }
      model = new WPS.Model.Literal(this, modelOptions);
    } else if (Legato.Lang.ObjectUtils.exists(inputDescription.boundingBoxData)) {
      var boundingBoxData = inputDescription.boundingBoxData;
      // TODO uoms
      model = new WPS.Model.BoundingBox(this, modelOptions);

      if (Legato.Lang.ObjectUtils.exists(this.map))
      {
        model.setExtent(this.map.getExtent());
      }
    } else if (Legato.Lang.ObjectUtils.exists(inputDescription.complexData)) {
      var complexData = inputDescription.complexData;
      if (!Legato.Lang.ObjectUtils.exists(complexData['default'].format)) {
        throw new Legato.Lang.Exception("Missing default format in complex data");
      }
      modelOptions.defaultFormat = complexData['default'].format;
      if (!Legato.Lang.ObjectUtils.exists(modelOptions.defaultFormat)) {
        throw new Legato.Lang.Exception("Missing schema definition in default format");
      }
      var schema = modelOptions.defaultFormat.schema;
      if (WPS.GEOM_POINT_URI === schema || WPS.GEOM_MULTI_POINT_URI === schema || WPS.GEOM_LINE_STRING_URI === schema || WPS.GEOM_MULTI_LINE_STRING_URI === schema || WPS.GEOM_POLYGON_URI === schema || WPS.GEOM_MULTI_POLYGON_URI === schema) {
        model = new WPS.Model.Geo(this, modelOptions);
        if (Legato.Lang.ObjectUtils.exists(complexData['defaultValue'])) {
          model.setDefaultContent(complexData['defaultValue'].content);
        }
      } else {
        throw new Legato.Lang.Exception("Unsupported complex data type: " + schema);
      }
    } else {
      throw new Legato.Lang.Exception("Unsupported input description type");
    }
    return model;
  },

  destroy : function() {
  },

  CLASS_NAME : 'WPS.Model.Factory'
});
