/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Revision: 69543 $
 * @requires WPS.js
 * @requires OpenLayers/Control.js
 */

/**
 * Structure: WPS.Control
 * Abstract base class for all WPS control classes
 *
 * Inherits from:
 *  - <OpenLayers.Control>
 */
WPS.Control =
  OpenLayers.Class(Legato.Control, {
    CLASS_NAME: 'WPS.Control'
});

/*
 * Property: NAMESPACE_URI
 * Defines the Namespace URI for all Legato Control Element. Needed in XML based config
 * file.
 */
WPS.Control.NAMESPACE_URI = 'http://www.disy.net/WPS/control';

/*
 * Property: PREFIX
 * Global defined prefix for all WPS Control classes.
 */
WPS.Control.PREFIX = 'lwpsc';

/*
 * Property: QName
 * Defines the qualified name. Needed for XML based config.
 */
WPS.Control.QName = function(localPart)
{
  return new Legato.XML.QName(WPS.Control.NAMESPACE_URI, localPart, WPS.Control.PREFIX);
};

/**
 * Structure: wpc:someControl
 * XML based config for a <WPS.Control> subclass.
 *
 * See Also:
 * - <Control>
 * - <QName>
 * - <PREFIX>
 * - <Legato.Beans.BeanFactory>
 *
 * All legato controls could be configured using xml. If so, the config needs to define
 * the namespace prefix (<PREFIX>). The needed NS URL should point to <NAMESPACE_URI>.
 * After that you're able to configure all legato control subclasses via XML.
 *
 * A valid example could be
 *
 * (start code)
 * <lwpsc:someControl foo="bar"/>
 * (end)
 *
 * For detailed informations have a look at the <WPS.Control> subclass documentation.
 */
WPS.Control.Bean = Legato.Control.Bean.Extend('WPS.Control',
    //
    WPS.Control.QName('Control'),
    //
    {
   _constructor :WPS.Control
});



