/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 81311 $
 * @requires OpenLayers.js
 */

(function() {
    var singleFile = (typeof WPS == "object" && WPS.singleFile);
    /**
     * Relative path of this script.
     */
    var scriptName = (!singleFile) ? "lib/WPS.js" : 'WPS.js';
    var jsFiles = window.WPS;

    window.WPS = {
        _getScriptLocation: (function() {
            var r = new RegExp("(^|(.*?\\/))(" + scriptName + ")(\\?|$)"),
                s = document.getElementsByTagName('script'),
                src, m, l = "";
            for(var i=0, len=s.length; i<len; i++) {
                src = s[i].getAttribute('src');
                if(src) {
                    m = src.match(r);
                    if(m) {
                        l = m[1];
                        break;
                    }
                }
            }
            return (function() { return l; });
        })()
    };

    if(!singleFile) {
        if (!jsFiles) {
            jsFiles = [
             'WPS/Common.js',
             'WPS/Feature.js',
             'WPS/Component.js',
             'WPS/Model.js',
             'WPS/Form.js',
             'WPS/ToolbarManager.js',
             'WPS/Inceptor.js',
             'WPS/Predicate.js',
             'WPS/Predicate/Metadata.js',
             'WPS/Predicate/ProcessIdentifier.js',
             'WPS/Predicate/MapTags.js',
             'WPS/ProcessSelector.js',
             'WPS/Result.js',
             'WPS/Control.js',
             'WPS/Control/GeoControlSync.js',
             'WPS/Control/GeometryEditor.js',
             'WPS/Control/GeoControlSyncGeometryEditor.js',
             'WPS/Control/ObjectVisualizer.js',
             'WPS/Control/ToggleWpsForm.js',
             'WPS/Control/WpsButton.js',
             'WPS/Model/BoundingBox.js',
             'WPS/Model/Complex.js',
             'WPS/Model/Factory.js',
             'WPS/Model/Geo.js',
             'WPS/Model/Literal.js',
             'WPS/Model/Process.js',
             'WPS/Component/AbstractInput.js',
             'WPS/Component/AbstractGeometry.js',
             'WPS/Component/BoundingBox.js',
             'WPS/Component/Factory.js',
             'WPS/Component/Literal.js',
             'WPS/Component/Point.js',
             'WPS/Component/MultiPoint.js',
             'WPS/Component/LineString.js',
             'WPS/Component/MultiLineString.js',
             'WPS/Component/Polygon.js',
             'WPS/Component/MultiPolygon.js',
             'WPS/Component/Process.js',
             'WPS/I18n/Messages.js',
             'WPS/I18n/Messages/de.js',
             'WPS/I18n/Messages/en.js',
             'WPS/Result/ExecutionContext.js',
             'WPS/Result/Geometry.js',
             'WPS/Result/Factory.js',
             'WPS/Result/Link.js',
             'WPS/Result/Message.js',
             'WPS/Result/BoundingBox.js',
             'WPS/Result/ExceptionReport.js',
             'WPS/Result/Point.js',
             'WPS/Result/LineString.js',
             'WPS/Result/Polygon.js',
             'WPS/Result/MultiPoint.js',
             'WPS/Result/MultiLineString.js',
             'WPS/Result/MultiPolygon.js',
             'WPS/Result/Group.js',
             'WPS/Result/Viewport.js',
             'WPS/Result/ProcessDescription.js',
             'WPS/Result/WPSPDGeometry.js',
             'WPS/Result/WPSPDPoint.js',
             'WPS/Result/WPSPDLineString.js',
             'WPS/Result/WPSPDPolygon.js',
             'WPS/Result/WPSPDMultiPoint.js',
             'WPS/Result/WPSPDMultiLineString.js',
             'WPS/Result/WPSPDMultiPolygon.js',
             'WPS/Result/WPSPDMarker.js',
             'WPS/Result/WPSPDStyledFeatureCollection.js'
            ]; // etc.
        }

        // use "parser-inserted scripts" for guaranteed execution order
        // http://hsivonen.iki.fi/script-execution/
        var scriptTags = new Array(jsFiles.length);
        var host = WPS._getScriptLocation() + "lib/";
        for (var i=0, len=jsFiles.length; i<len; i++) {
            scriptTags[i] = "<script src='" + host + jsFiles[i] +
                                   "'></script>";
        }
        if (scriptTags.length > 0) {
            document.write(scriptTags.join(""));
        }
    }
})();

/**
 * Constant: VERSION_NUMBER
 */
WPS.VERSION_NUMBER = "$Revision: 81311 $";
WPS.NAMESPACE_URI = 'http://www.disy.net/WPS/wps';
WPS.PREFIX = 'lwps';
WPS.QName = function(localPart) {
  return new Legato.XML.QName(WPS.NAMESPACE_URI, localPart,
      WPS.PREFIX);
};

WPSPD = {
    Result : {}
};
