/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var WPS={singleFile:true};
(function(){var c=(typeof WPS=="object"&&WPS.singleFile);
var g=(!c)?"lib/WPS.js":"WPS.js";
var b=window.WPS;
window.WPS={_getScriptLocation:(function(){var p=new RegExp("(^|(.*?\\/))("+g+")(\\?|$)"),o=document.getElementsByTagName("script"),q,j,k="";
for(var n=0,h=o.length;
n<h;
n++){q=o[n].getAttribute("src");
if(q){j=q.match(p);
if(j){k=j[1];
break
}}}return(function(){return k
})
})()};
if(!c){if(!b){b=["WPS/Common.js","WPS/Feature.js","WPS/Component.js","WPS/Model.js","WPS/Form.js","WPS/ToolbarManager.js","WPS/Inceptor.js","WPS/Predicate.js","WPS/Predicate/Metadata.js","WPS/Predicate/ProcessIdentifier.js","WPS/Predicate/MapTags.js","WPS/ProcessSelector.js","WPS/Result.js","WPS/Control.js","WPS/Control/GeoControlSync.js","WPS/Control/GeometryEditor.js","WPS/Control/GeoControlSyncGeometryEditor.js","WPS/Control/ObjectVisualizer.js","WPS/Control/ToggleWpsForm.js","WPS/Control/WpsButton.js","WPS/Model/BoundingBox.js","WPS/Model/Complex.js","WPS/Model/Factory.js","WPS/Model/Geo.js","WPS/Model/Literal.js","WPS/Model/Process.js","WPS/Component/AbstractInput.js","WPS/Component/AbstractGeometry.js","WPS/Component/BoundingBox.js","WPS/Component/Factory.js","WPS/Component/Literal.js","WPS/Component/Point.js","WPS/Component/MultiPoint.js","WPS/Component/LineString.js","WPS/Component/MultiLineString.js","WPS/Component/Polygon.js","WPS/Component/MultiPolygon.js","WPS/Component/Process.js","WPS/I18n/Messages.js","WPS/I18n/Messages/de.js","WPS/I18n/Messages/en.js","WPS/Result/ExecutionContext.js","WPS/Result/Geometry.js","WPS/Result/Factory.js","WPS/Result/Link.js","WPS/Result/Message.js","WPS/Result/BoundingBox.js","WPS/Result/ExceptionReport.js","WPS/Result/Point.js","WPS/Result/LineString.js","WPS/Result/Polygon.js","WPS/Result/MultiPoint.js","WPS/Result/MultiLineString.js","WPS/Result/MultiPolygon.js","WPS/Result/Group.js","WPS/Result/ProcessDescription.js","WPS/Result/WPSPDGeometry.js","WPS/Result/WPSPDPoint.js","WPS/Result/WPSPDLineString.js","WPS/Result/WPSPDPolygon.js","WPS/Result/WPSPDMultiPoint.js","WPS/Result/WPSPDMultiLineString.js","WPS/Result/WPSPDMultiPolygon.js","WPS/Result/WPSPDMarker.js"]
}var f=new Array(b.length);
var e=WPS._getScriptLocation()+"lib/";
for(var d=0,a=b.length;
d<a;
d++){f[d]="<script src='"+e+b[d]+"'><\/script>"
}if(f.length>0){document.write(f.join(""))
}}})();
WPS.VERSION_NUMBER="$Revision: 81311 $";
WPS.NAMESPACE_URI="http://www.disy.net/WPS/wps";
WPS.PREFIX="lwps";
WPS.QName=function(a){return new Legato.XML.QName(WPS.NAMESPACE_URI,a,WPS.PREFIX)
};
WPSPD={Result:{}};
WPS.GEOM_POINT_URI="http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#Point";
WPS.GEOM_MULTI_POINT_URI="http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#MultiPoint";
WPS.GEOM_LINE_STRING_URI="http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#LineString";
WPS.GEOM_MULTI_LINE_STRING_URI="http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#MultiLineString";
WPS.GEOM_POLYGON_URI="http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#Polygon";
WPS.GEOM_MULTI_POLYGON_URI="http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#MultiPolygon";
WPS.Feature={};
WPS.Feature.Style={ACTIVE:{fillColor:"#fa8072",fillOpacity:0.6,hoverFillColor:"white",hoverFillOpacity:0.9,strokeColor:"#fa8072",strokeOpacity:1,strokeWidth:2,strokeLinecap:"round",strokeDashstyle:"solid",hoverStrokeColor:"red",hoverStrokeOpacity:1,hoverStrokeWidth:0.2,pointRadius:6,hoverPointRadius:1,hoverPointUnit:"%",pointerEvents:"visiblePainted",cursor:"inherit"},ACTIVE_HOVER:{fillColor:"#ff4500",fillOpacity:0.6,hoverFillColor:"white",hoverFillOpacity:0.9,strokeColor:"#ff4500",strokeOpacity:1,strokeWidth:2,strokeLinecap:"round",strokeDashstyle:"solid",hoverStrokeColor:"red",hoverStrokeOpacity:1,hoverStrokeWidth:0.2,pointRadius:6,hoverPointRadius:1,hoverPointUnit:"%",pointerEvents:"visiblePainted",cursor:"inherit"},INACTIVE:{fillColor:"#a9a9a9",fillOpacity:0.4,hoverFillColor:"white",hoverFillOpacity:0.6,strokeColor:"#a9a9a9",strokeOpacity:1,strokeWidth:2,strokeLinecap:"round",strokeDashstyle:"solid",hoverStrokeColor:"red",hoverStrokeOpacity:1,hoverStrokeWidth:0.2,pointRadius:6,hoverPointRadius:1,hoverPointUnit:"%",pointerEvents:"visiblePainted",cursor:"inherit"},INACTIVE_HOVER:{fillColor:"#a9a9a9",fillOpacity:0.4,hoverFillColor:"white",hoverFillOpacity:0.6,strokeColor:"#a9a9a9",strokeOpacity:1,strokeWidth:2,strokeLinecap:"round",strokeDashstyle:"solid",hoverStrokeColor:"red",hoverStrokeOpacity:1,hoverStrokeWidth:0.2,pointRadius:6,hoverPointRadius:1,hoverPointUnit:"%",pointerEvents:"visiblePainted",cursor:"inherit"}};
WPS.Component=OpenLayers.Class({EVENT_TYPES:["activate","deactivate","validitychange"],id:null,model:null,map:null,events:null,status:null,hidden:false,initialize:function(d,b,c,a){Legato.Util.Ensure.ensureExists(d,"Id must be defined.");
Legato.Util.Ensure.ensureExists(b,"Model must be defined.");
Legato.Util.Ensure.ensureExists(c,"Map must be defined.");
OpenLayers.Util.extend(this,a);
this.id=d;
this.model=b;
this.map=c;
this.events=new OpenLayers.Events(this,null,this.EVENT_TYPES);
this.model.events.on({valuechange:this.onModelValueChange,validitychange:this.onModelValidityChange,scope:this});
this.initializeAdditionalElements(d,b,c,a);
if(this.model.getValue()===null){this.onDeactivation()
}else{this.onActivation()
}if(Legato.Lang.ObjectUtils.exists(this.model.getValue())){this.onModelValueChange({value:this.model.getValue()})
}},appendTo:function(a){},initializeAdditionalElements:function(d,b,c,a){},destroy:function(){this.container=null;
if(Legato.Lang.ObjectUtils.exists(this.events)){this.events.destroy();
this.events=null
}this.model.events.un({valuechange:this.onModelValueChange,validitychange:this.onModelValidityChange,scope:this})
},isActive:function(){return(WPS.Component.STATUS_ACTIVE_HOVER===this.status||WPS.Component.STATUS_ACTIVE===this.status)
},isInactive:function(){return(WPS.Component.STATUS_INACTIVE_HOVER===this.status||WPS.Component.STATUS_INACTIVE===this.status)
},hoverIn:function(){this.onHoverIn()
},hoverOut:function(){this.onHoverOut()
},checkedChanged:function(b){var a=(b.target||b.srcElement).checked;
this.model.setChecked(a)
},onModelValueChange:function(a){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the onModelValueChange function from from abstract class "+WPS.Component.CLASS_NAME)
},onModelValidityChange:function(a){this.events.triggerEvent("validitychange",{component:this})
},activate:function(){this.onActivation()
},isAccessable:function(){return false
},deactivate:function(){this.onDeactivation()
},onHoverIn:function(){if(WPS.Component.STATUS_INACTIVE===this.status){this.status=WPS.Component.STATUS_INACTIVE_HOVER
}else{this.status=WPS.Component.STATUS_ACTIVE_HOVER
}},onHoverOut:function(a){if(WPS.Component.STATUS_ACTIVE_HOVER===this.status){this.status=WPS.Component.STATUS_ACTIVE
}else{this.status=WPS.Component.STATUS_INACTIVE
}},onActivation:function(a){this.status=WPS.Component.STATUS_ACTIVE_HOVER;
if(a){this.events.triggerEvent("activate",{component:this})
}this.model.setChecked(true)
},onDeactivation:function(a){this.status=WPS.Component.STATUS_INACTIVE;
if(a){this.events.triggerEvent("deactivate",{component:this})
}},CLASS_NAME:"WPS.Component"});
WPS.Component.STATUS_ACTIVE_HOVER=1;
WPS.Component.STATUS_ACTIVE=2;
WPS.Component.STATUS_INACTIVE_HOVER=3;
WPS.Component.STATUS_INACTIVE=4;
WPS.Model=OpenLayers.Class({EVENT_TYPES:["valuechange","validitychange"],identifier:null,title:null,"abstract":null,minOccurs:null,maxOccurs:1,value:null,defaultValue:null,events:null,valueProperty:null,checked:false,required:false,valid:false,validationMessages:null,initialize:function(b,a){OpenLayers.Util.extend(this,a);
this.events=new OpenLayers.Events(this,null,this.EVENT_TYPES);
this.required=(this.minOccurs>0);
this.validationMessages=[];
if(Legato.Lang.ObjectUtils.exists(this.defaultValue)){this.setValue(this.defaultValue);
this.setChecked(true)
}else{this.validate()
}},needsUserInput:function(){return true
},getValue:function(){return this.value
},setValue:function(a){if(a!==this.value){this.value=a;
this.events.triggerEvent("valuechange",{value:a})
}this.validate()
},resetValue:function(){this.setValue(this.getDefaultValue())
},getDefaultValue:function(){return this.defaultValue
},setDefaultValue:function(a){this.defaultValue=a;
if(this.getValue()===null){this.setValue(this.defaultValue)
}},setChecked:function(a){this.checked=a;
if(!this.checked){this.resetValue()
}this.validate()
},validate:function(){var a=this.valid;
this.validationMessages=[];
if(this.required&&!(this.getValue()&&this.checked)){this.valid=false;
var b=this.title;
this.validationMessages.push(WPS.I18n.getMessage("WPS.Model.MustFill",{title:b}))
}else{this.valid=true
}this.events.triggerEvent("validitychange",{valid:this.valid,validBefore:a})
},getData:function(){if(this.value===null||!this.checked){return null
}else{var a={identifier:{value:this.identifier},data:{}};
return[this.populateData(a)]
}},populateData:function(a){return a
},destroy:function(){if(this.events){this.events.destroy();
this.events=null
}this.value=null
},CLASS_NAME:"WPS.Model"});
WPS.Form=OpenLayers.Class({EVENT_TYPES:["geoInputActivation","processSelectionCancellation","processExecutionCancellation","on","off"],events:null,processSelector:null,processComponent:null,isOn:false,map:null,currentProcessId:null,currentProcessModel:null,capabilities:null,container:null,childContainer:null,onCallback:null,offCallback:null,wpsOperations:null,predicate:null,resultFactory:null,popupCallback:null,errorCallback:null,txtExecute:null,txtSelect:null,txtCancel:null,componentFactoryOptions:null,initialize:function(b,a){Legato.Util.Ensure.ensureExists(b,"map must be defined");
this.map=b;
OpenLayers.Util.extend(this,a);
this.events=new OpenLayers.Events(this,null,this.EVENT_TYPES);
if(this.container===null){this.container=document.createElement("div");
this.container.className="wpsForm"
}if(this.wpsOperations===null){this.wpsOperations=WpsOperations
}if(this.resultFactory===null){this.resultFactory=new WPS.Result.Factory(this.map,this)
}if(!Legato.Lang.ObjectUtils.isString(this.txtExecute)){this.txtExecute="OK"
}if(!Legato.Lang.ObjectUtils.isString(this.txtSelect)){this.txtSelect="OK"
}if(!Legato.Lang.ObjectUtils.isString(this.txtCancel)){this.txtCancel="Cancel"
}if(!Legato.Lang.ObjectUtils.isObject(this.componentFactoryOptions)){this.componentFactoryOptions={}
}this.componentFactoryOptions.styles=this.styles
},initCapabilities:function(){this.capabilitiesReady=false;
var a={service:"WPS",acceptVersions:{version:["1.0.0"]}};
this.wpsOperations.getCapabilities(a,OpenLayers.Function.bind(function(c){if(Legato.Lang.ObjectUtils.exists(c)&&Legato.Lang.ObjectUtils.exists(c.processOfferings)&&Legato.Lang.ObjectUtils.exists(c.processOfferings.process)){var b;
if(Legato.Lang.ObjectUtils.exists(this.predicate)){b=this.predicate
}else{b=this.createDefaultPredicate()
}var e=[];
for(var d=0;
d<c.processOfferings.process.length;
d++){var f=c.processOfferings.process[d];
if(b.evaluate(f)){e.push(f)
}}this.capabilities=e
}else{this.capabilities=null
}this.capabilitiesReady=true
},this))
},createDefaultPredicate:function(){return new WPS.Predicate.MapTags(this.map,{prefix:"wps:include:form:",includeInfix:"metadata:tag",defaultIncludes:true,predicateCallback:function(a){return new WPS.Predicate.Metadata(a)
}})
},onWithCapabilities:function(){if(this.capabilitiesReady){if(!Legato.Lang.ObjectUtils.exists(this.currentProcessId)){this.processSelector=new WPS.ProcessSelector(this.capabilities,OpenLayers.Function.bind(this.selectProcess,this),OpenLayers.Function.bind(this.cancelSelection,this),{txtSelect:this.txtSelect,txtCancel:this.txtCancel});
this.replaceChildContainer(this.processSelector.container)
}else{this.processComponent=new WPS.Component.Process(this.currentProcessModel,this.map,OpenLayers.Function.bind(this.execute,this),OpenLayers.Function.bind(this.cancelExecution,this),{txtExecute:this.txtExecute,txtCancel:this.txtCancel,componentFactoryOptions:this.componentFactoryOptions});
this.processComponent.events.on({geoInputActivation:this.geoInputActivated,scope:this});
this.replaceChildContainer(this.processComponent.container)
}this.isOn=true;
this.events.triggerEvent("on",{});
OpenLayers.Element.show(this.container);
if(this.onCallback){this.onCallback(this)
}return
}else{setTimeout(OpenLayers.Function.bind(this.onWithCapabilities,this),200)
}},destroy:function(){if(Legato.Lang.ObjectUtils.exists(this.events)){this.events.destroy();
this.events=null
}this.destroyChildren()
},destroyProcessSelector:function(){this.processSelector.destroy();
this.processSelector=null;
this.childContainer=null;
this.container.innerHTML=""
},destroyProcessComponent:function(){if(Legato.Lang.ObjectUtils.exists(this.processComponent.events)){this.processComponent.events.un({geoInputActivation:this.geoInputActivated,scope:this})
}this.processComponent.destroy();
this.processComponent=null;
this.childContainer=null;
this.container.innerHTML=""
},destroyChildren:function(){if(Legato.Lang.ObjectUtils.exists(this.processSelector)){this.destroyProcessSelector()
}if(Legato.Lang.ObjectUtils.exists(this.processComponent)){this.destroyProcessComponent()
}},geoInputActivated:function(a){this.events.triggerEvent("geoInputActivation",{})
},on:function(){if(!Legato.Lang.ObjectUtils.exists(this.capabilities)){this.initCapabilities()
}this.onWithCapabilities()
},replaceChildContainer:function(a){this.container.innerHTML="";
this.childContainer=a;
this.container.appendChild(this.childContainer)
},selectProcess:function(c,b){this.currentProcessId=null;
var a={identifier:[{value:c}]};
this.wpsOperations.describeProcess(a,OpenLayers.Function.bind(function(d){var e=d.processDescription[0];
if(Legato.Lang.ObjectUtils.exists(e)){this.activateProcessDescription(e,b)
}else{alert("Could not retrieve WPS process description from server")
}},this))
},activateProcessDescription:function(b,d){var a=new WPS.Model.Process(this.map,b);
if(a.needsUserInput()){this.currentProcessId=b.identifier.value;
this.currentProcessModel=a;
var f=OpenLayers.Function.bind(this.execute,this);
var e=Legato.Lang.ObjectUtils.isTrue(d)?OpenLayers.Function.bind(this.cancelExecutionAndCloseForm,this):OpenLayers.Function.bind(this.cancelExecutionAndShowSelection,this);
this.processComponent=new WPS.Component.Process(this.currentProcessModel,this.map,f,e,{txtExecute:this.txtExecute,txtCancel:this.txtCancel,componentFactoryOptions:this.componentFactoryOptions,styles:this.styles});
this.processComponent.events.on({geoInputActivation:this.geoInputActivated,scope:this});
this.replaceChildContainer(this.processComponent.container)
}else{var c=a.getData();
this.execute(null,c);
a.destroy();
if(Legato.Lang.ObjectUtils.isTrue(d)){this.off()
}}},cancelSelection:function(){this.currentProcessId=null;
this.events.triggerEvent("processSelectionCancellation",{})
},cancelExecutionAndCloseForm:function(){this.cancelExecution();
this.off()
},cancelExecutionAndShowSelection:function(){this.cancelExecution()
},cancelExecution:function(){this.destroyProcessComponent();
if(Legato.Lang.ObjectUtils.exists(this.currentProcessModel)){this.currentProcessModel.destroy();
this.currentProcessModel=null
}this.events.triggerEvent("processExecutionCancellation",{processId:this.currentProcessId});
this.currentProcessId=null;
if(!Legato.Lang.ObjectUtils.exists(this.capabilities)){this.off();
return
}this.processSelector=new WPS.ProcessSelector(this.capabilities,OpenLayers.Function.bind(this.selectProcess,this),OpenLayers.Function.bind(this.cancelSelection,this),{txtCancel:this.txtCancel,txtExecute:this.txtExecute});
this.replaceChildContainer(this.processSelector.container)
},execute:function(b,a){this.wpsOperations.execute(a,OpenLayers.Function.bind(function(e){var d=new WPS.Result.ExecutionContext(this.map);
var c=this.resultFactory.createResult(e,this.popupCallback,this.errorCallback);
c.execute(d);
d.destroy()
},this))
},off:function(){this.destroyChildren();
this.isOn=false;
this.events.triggerEvent("off",{});
OpenLayers.Element.hide(this.container);
if(this.offCallback){this.offCallback(this)
}},activate:function(){if(this.isOn&&Legato.Lang.ObjectUtils.exists(this.processComponent)){this.processComponent.activate()
}},deactivate:function(){if(this.isOn&&Legato.Lang.ObjectUtils.exists(this.processComponent)){this.processComponent.deactivate()
}},CLASS_NAME:"WPS.Form"});
WPS.Form.Bean=Legato.Beans.Object.Extend("WPS.Form",WPS.QName("Form"),{_constructor:WPS.Form,constructorArguments:{map:OpenLayers.Map.Bean},constructorOrder:["map"],options:{container:Legato.Lang.Element,onCallback:Legato.Lang.Function,offCallback:Legato.Lang.Function,popupCallback:Legato.Lang.Function,errorCallback:Legato.Lang.Function,wpsOperations:Legato.Beans.Object,predicate:Legato.Beans.Object,txtExecute:Legato.Lang.String,txtSelect:Legato.Lang.String,txtCancel:Legato.Lang.String,componentFactoryOptions:Legato.Beans["Object{}"],styles:Legato.Beans.Object.List()}});
WPS.ToolbarManager=OpenLayers.Class({map:null,panel:null,form:null,wpsOperations:null,predicate:null,initialize:function(c,a,b){Legato.Util.Ensure.ensureObject(c);
this.map=c;
this.panel=a;
OpenLayers.Util.extend(this,b);
this.map.events.on({"legato.refresh":this.manageToolbar,scope:this})
},destroy:function(){this.map.events.un({"legato.refresh":this.manageToolbar,scope:this})
},manageToolbar:function(){var a={service:"WPS",acceptVersions:{version:["1.0.0"]}};
this.wpsOperations.getCapabilities(a,OpenLayers.Function.bind(function(c){var i=new Legato.Util.HashSet();
for(var e=0;
e<this.panel.controls.length;
e++){var d=this.panel.controls[e];
if(d.CLASS_NAME=="WPS.Control.WpsButton"){i.add(d.processIdentifier)
}}var j=[];
var b=c.processOfferings.process;
var k;
if(Legato.Lang.ObjectUtils.exists(this.predicate)){k=this.predicate
}else{k=this.createDefaultPredicate()
}for(var h=0;
h<b.length;
h++){var f=b[h];
if(k.evaluate(f)&&!i.contains(f.identifier.value)){var g=new WPS.Control.WpsButton({form:this.form,wpsOperations:this.wpsOperations,processDescription:f});
j.push(g)
}}this.panel.addControls(j)
},this))
},createDefaultPredicate:function(){var a=[];
a.push(new WPS.Predicate.MapTags(this.map,{prefix:"wps:include:toolbar:",includeInfix:"metadata:tag",defaultIncludes:false,predicateCallback:function(b){return new WPS.Predicate.Metadata(b)
}}));
a.push(new WPS.Predicate.MapTags(this.map,{prefix:"wps:include:toolbar:",includeInfix:"id",defaultIncludes:false,predicateCallback:function(b){return new WPS.Predicate.ProcessIdentifier(b)
}}));
return new WPS.Predicate.Or(a)
},CLASS_NAME:"WPS.ToolbarManager"});
WPS.ToolbarManager.Bean=Legato.Beans.Object.Extend("WPS.ToolbarManager",WPS.QName("ToolbarManager"),{_constructor:WPS.ToolbarManager,constructorArguments:{map:Legato.Beans.Object,panel:Legato.Beans.Object},constructorOrder:["map","panel"],options:{form:Legato.Beans.Object,wpsOperations:Legato.Lang.Function,predicate:Legato.Beans.Object}});
WPS.Inceptor=OpenLayers.Class({map:null,form:null,inception:null,resultFactory:null,autoExecutionPredicate:null,initialize:function(d,c,b,a){Legato.Util.Ensure.ensureObject(d);
Legato.Util.Ensure.ensureObject(c);
Legato.Util.Ensure.ensureFunction(b);
this.map=d;
this.form=c;
this.inception=b;
this.autoExecutionPredicate=new WPS.Predicate.Metadata("auto",{about:"execution"});
this.resultFactory=new WPS.Result.Factory(d,null);
this.incept()
},destroy:function(){},incept:function(){var a=this;
a.inception(function(d){if(Legato.Lang.ObjectUtils.exists(d)){if(a.autoExecutionPredicate.evaluate(d)){var c=new WPS.Model.Process(a.map,d);
var b=c.getData();
a.form.execute(null,b)
}else{a.form.activateProcessDescription(d,true);
a.form.isOn=true;
if(a.form.onCallback){a.form.onCallback(a.form)
}}}})
},CLASS_NAME:"WPS.Inceptor"});
WPS.Inceptor.Bean=Legato.Beans.Object.Extend("WPS.Inceptor",WPS.QName("Inceptor"),{_constructor:WPS.Inceptor,constructorArguments:{map:Legato.Beans.Object,form:Legato.Beans.Object,inception:Legato.Lang.Function},constructorOrder:["map","form","inception"]});
WPS.Predicate=OpenLayers.Class({initialize:function(a){OpenLayers.Util.extend(this,a)
},evaluate:function(a){return true
},CLASS_NAME:"WPS.Predicate"});
WPS.Predicate.And=OpenLayers.Class({predicates:null,initialize:function(a){this.predicates=a
},evaluate:function(b){for(var a=0;
a<this.predicates.length;
a++){var c=this.predicates[a];
if(!c.evaluate(b)){return false
}}return true
},CLASS_NAME:"WPS.Predicate.And"});
WPS.Predicate.Or=OpenLayers.Class({predicates:null,initialize:function(a){Legato.Util.Ensure.ensureArray(a);
this.predicates=a
},evaluate:function(b){for(var a=0;
a<this.predicates.length;
a++){var c=this.predicates[a];
if(c.evaluate(b)){return true
}}return false
},CLASS_NAME:"WPS.Predicate.Or"});
WPS.Predicate.Not=OpenLayers.Class({predicate:null,initialize:function(a){this.predicate=a
},evaluate:function(a){return !this.predicate.evaluate(a)
},CLASS_NAME:"WPS.Predicate.Not"});
WPS.Predicate.True=OpenLayers.Class({initialize:function(a){OpenLayers.Util.extend(this,a)
},evaluate:function(a){return true
},CLASS_NAME:"WPS.Predicate.True"});
WPS.Predicate.False=OpenLayers.Class({initialize:function(a){OpenLayers.Util.extend(this,a)
},evaluate:function(a){return false
},CLASS_NAME:"WPS.Predicate.False"});
WPS.Predicate.NAMESPACE_URI="http://www.disy.net/WPS/predicate";
WPS.Predicate.PREFIX="lwpsp";
WPS.Predicate.QName=function(a){return new Legato.XML.QName(WPS.Predicate.NAMESPACE_URI,a,WPS.Predicate.PREFIX)
};
WPS.Predicate.Bean=Legato.Beans.Object.Extend("WPS.Predicate",WPS.Predicate.QName("Predicate"),{_constructor:WPS.Predicate});
WPS.Predicate.Metadata=OpenLayers.Class({about:"tag",value:null,initialize:function(b,a){Legato.Util.Ensure.ensureString(b);
this.value=b;
OpenLayers.Util.extend(this,a)
},evaluate:function(d){var b=d.metadata;
for(var a=0;
a<b.length;
a++){var c=b[a];
if(c.about===this.about){if(this.value===c.href){return true
}}}return false
},CLASS_NAME:"WPS.Predicate.Metadata"});
WPS.Predicate.ProcessIdentifier=OpenLayers.Class({value:null,initialize:function(b,a){Legato.Util.Ensure.ensureString(b);
this.value=b;
OpenLayers.Util.extend(this,a)
},evaluate:function(a){if(this.value===a.identifier.value){return true
}return false
},CLASS_NAME:"WPS.Predicate.ProcessIdentifier"});
WPS.Predicate.MapTags=OpenLayers.Class({map:null,defaultIncludes:true,prefix:"wps:",includeInfix:"metadata:tag",includeTagName:null,predicate:null,predicateCallback:null,initialize:function(b,a){Legato.Util.Ensure.ensureObject(b);
this.map=b;
OpenLayers.Util.extend(this,a);
this.includeTagName=this.prefix+this.includeInfix;
this.initializePredicate()
},initializePredicate:function(){if(Legato.Lang.ObjectUtils.isArray(this.map.tags)){this.predicate=this.createPredicate(this.map.tags)
}else{this.predicate=this.createDefaultPredicate()
}},createDefaultPredicate:function(){if(this.defaultIncludes){return new WPS.Predicate.True()
}else{return new WPS.Predicate.False()
}},createPredicate:function(d){var b=[];
if(Legato.Lang.ObjectUtils.isArray(d)){for(var c=0;
c<d.length;
c++){var a=d[c];
if(a.name==this.includeTagName&&Legato.Lang.ObjectUtils.isString(a.value)){b.push(this.predicateCallback(a.value))
}}}if(b.length===0){return this.createDefaultPredicate()
}else{return new WPS.Predicate.Or(b)
}},evaluate:function(a){return this.predicate.evaluate(a)
},CLASS_NAME:"WPS.Predicate.MapTags"});
WPS.Predicate.MapTags.Bean=WPS.Predicate.Bean.Extend("WPS.Predicate.MapTags",WPS.Predicate.QName("MapTags"),{_constructor:WPS.Predicate.MapTags,constructorArguments:{map:Legato.Beans.Object},constructorOrder:["map"],options:{prefix:Legato.Lang.String,includeInfix:Legato.Lang.String,defaultIncludes:Legato.Lang.Boolean,predicateCallback:Legato.Lang.Function}});
WPS.ProcessSelector=OpenLayers.Class({container:null,menuContainer:null,menuElement:null,processDescriptions:null,selectedCallback:null,cancelCallback:null,abstractElement:null,buttonsElement:null,okButton:null,cancelButton:null,selectedProcessId:null,txtSelect:"OK",txtCancel:"Cancel",initialize:function(a,c,b,d){Legato.Util.Ensure.ensureArray(a,"processDescriptions should be defined");
Legato.Util.Ensure.ensureFunction(c,"selected callback should be a function");
Legato.Util.Ensure.ensureFunction(b,"cancel callback should be a function");
this.processDescriptions=a;
this.selectedCallback=c;
this.cancelCallback=b;
OpenLayers.Util.extend(this,d);
if(this.container===null){this.container=document.createElement("div");
this.container.className="wpsContainer"
}this.titleElement=document.createElement("div");
this.titleElement.className="wpsContainerTitle";
this.titleElement.innerHTML=WPS.I18n.getMessage("WPS.ProcessSelector.Title");
this.container.appendChild(this.titleElement);
this.abstractElement=document.createElement("div");
this.abstractElement.className="wpsContainerAbstract";
this.abstractElement.innerHTML=WPS.I18n.getMessage("WPS.ProcessSelector.Description");
this.container.appendChild(this.abstractElement);
this.generateInputContainer();
this.buttonsElement=document.createElement("div");
this.buttonsElement.className="wpsButtons";
this.container.appendChild(this.buttonsElement);
this.okButton=document.createElement("input");
this.okButton.id="wpsProcessSelectionOKButton";
this.okButton.type="button";
this.okButton.value=this.txtSelect;
this.okButton.disabled=true;
this.okButton.onclick=OpenLayers.Function.bindAsEventListener(this.okButtonClicked,this);
this.buttonsElement.appendChild(this.okButton);
this.cancelButton=document.createElement("input");
this.cancelButton.id="wpsProcessSelectionCancelButton";
this.cancelButton.type="button";
this.cancelButton.value=this.txtCancel;
this.cancelButton.disabled=false;
this.cancelButton.onclick=OpenLayers.Function.bindAsEventListener(this.cancelButtonClicked,this);
this.buttonsElement.appendChild(this.cancelButton)
},okButtonClicked:function(){this.selectedCallback(this.selectedProcessId)
},cancelButtonClicked:function(){this.selectProcess(null);
var a=this.menuElement.childNodes;
for(var b=0;
b<a.length;
b++){var c=a[b].value;
if(""===c){a[b].selected=true
}else{a[b].selected=false
}}this.cancelCallback(this)
},generateInputContainer:function(){var d=document.createElement("div");
d.className="wpsProcessSelectionInputsContainer";
this.menuContainer=document.createElement("div");
this.menuContainer.className="wpsProcessSelectionDropDownContainer";
this.menuElement=document.createElement("select");
this.menuElement.id="wpsProcessesSelectionDropDown";
this.menuElement.className="wpsProcessesSelectionDropDown";
this.menuElement.size=this.processDescriptions.length>10?10:this.processDescriptions.length;
this.menuElement.onchange=OpenLayers.Function.bindAsEventListener(this.processChanged,this);
this.menuContainer.appendChild(this.menuElement);
d.appendChild(this.menuContainer);
this.descriptionContainer=document.createElement("div");
this.descriptionContainer.className="wpsProcessSelectionDescriptionContainer";
this.descriptionInfoText=document.createElement("div");
this.descriptionInfoText.className="wpsProcessSelectionInfoText";
this.descriptionInfoText.innerHTML="Beschreibung";
this.abstractElement=document.createElement("div");
this.abstractElement.className="wpsProcessSelectionAbstract";
this.abstractElement.innerHTML="";
OpenLayers.Element.hide(this.descriptionContainer);
this.descriptionContainer.appendChild(this.descriptionInfoText);
this.descriptionContainer.appendChild(this.abstractElement);
d.appendChild(this.descriptionContainer);
this.container.appendChild(d);
for(var b=0;
b<this.processDescriptions.length;
b++){var c=this.processDescriptions[b];
var a=this.createOption(c.title.value,c.identifier.value,false);
this.menuElement.appendChild(a)
}},createOption:function(a,d,c){var b=document.createElement("option");
b.value=d;
b.selected=c;
b.innerHTML=a;
b.title=a;
return b
},processChanged:function(b){var a=(b.target||b.srcElement).value;
this.selectProcess(a)
},selectProcess:function(c){this.selectedProcessId=null;
if(c){for(var a=0;
a<this.processDescriptions.length;
a++){var b=this.processDescriptions[a];
if(c===b.identifier.value){this.selectedProcessId=c;
this.abstractElement.innerHTML=b["abstract"].value;
OpenLayers.Element.show(this.descriptionContainer);
this.okButton.disabled=false;
break
}}}if(!this.selectedProcessId){this.abstractElement.innerHTML="";
OpenLayers.Element.hide(this.descriptionContainer);
this.okButton.disabled=true
}},destroy:function(){this.processDescriptions=null;
this.selectedCallback=null;
this.cancelCallback=null
},CLASS_NAME:"WPS.ProcessSelector"});
WPS.Result=OpenLayers.Class({id:null,title:null,description:null,popupCallback:null,errorCallback:null,initialize:function(b,a){Legato.Util.Ensure.ensureExists(b,"id should be defined");
this.id=b;
OpenLayers.Util.extend(this,a);
if(!Legato.Lang.ObjectUtils.isString(this.title)){this.title=this.createDefaultTitle()
}if(!Legato.Lang.ObjectUtils.isString(this.description)){this.description=this.createDefaultDescription()
}},createDefaultTitle:function(){return null
},createDefaultDescription:function(){return null
},destroy:function(){this.id=null;
this.title=null;
this.description=null
},execute:function(){},createContent:function(){var a=document.createElement("div");
return a
},CLASS_NAME:"WPS.Result"});
WPS.Result.SimpleFactory=OpenLayers.Class({map:null,initialize:function(a){this.map=a
},destroy:function(){this.map=null
},createResult:function(c,a,b){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the createResult function from from abstract class "+WPS.Result.SimpleFactory.CLASS_NAME)
},CLASS_NAME:"WPS.Result.SimpleFactory"});
WPS.Result.ComplexFactory=OpenLayers.Class({schema:null,elementName:null,map:null,initialize:function(a){this.map=a
},destroy:function(){this.schema=null;
this.elementName=null;
this.map=null
},createResult:function(c,a,b){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the createResult function from from abstract class "+WPS.Result.ComplexFactory.CLASS_NAME)
},CLASS_NAME:"WPS.Result.ComplexFactory"});
WPS.Control=OpenLayers.Class(Legato.Control,{CLASS_NAME:"WPS.Control"});
WPS.Control.NAMESPACE_URI="http://www.disy.net/WPS/control";
WPS.Control.PREFIX="lwpsc";
WPS.Control.QName=function(a){return new Legato.XML.QName(WPS.Control.NAMESPACE_URI,a,WPS.Control.PREFIX)
};
WPS.Control.Bean=Legato.Control.Bean.Extend("WPS.Control",WPS.Control.QName("Control"),{_constructor:WPS.Control});
WPS.Control.GeoControlSync=OpenLayers.Class(WPS.Control,{form:null,initialize:function(a){if(!a.displayClass){a.displayClass="LegatoControlInvisible"
}OpenLayers.Control.prototype.initialize.apply(this,arguments);
if(Legato.Lang.ObjectUtils.exists(this.form)){this.form.events.on({geoInputActivation:this.geoInputActivated,scope:this})
}},geoInputActivated:function(){Legato.Util.fireDOMEvent(this.panel_div,"click")
},destroy:function(){if(Legato.Lang.ObjectUtils.exists(this.form)){this.form.events.un({geoInputActivation:this.activate,scope:this})
}OpenLayers.Control.prototype.destroy.apply(this,arguments)
},activate:function(){if(Legato.Lang.ObjectUtils.exists(this.form)){this.form.activate()
}WPS.Control.prototype.activate.apply(this,arguments)
},deactivate:function(){if(Legato.Lang.ObjectUtils.exists(this.form)){this.form.deactivate()
}WPS.Control.prototype.deactivate.apply(this,arguments)
},CLASS_NAME:"WPS.Control.GeoControlSync"});
WPS.Control.GeoControlSync.Bean=WPS.Control.Bean.Extend("WPS.Control.GeoControlSync",WPS.Control.QName("GeoControlSync"),{_constructor:WPS.Control.GeoControlSync,options:{form:WPS.Form}});
WPS.Control.GeometryEditor=OpenLayers.Class(WPS.Control,{map:null,div:null,processDescription:null,currentProcessModel:null,processComponent:null,styles:null,initialize:function(a){Legato.Util.Ensure.ensureExists(a.map,"form must be defined");
OpenLayers.Control.prototype.initialize.apply(this,arguments)
},destroy:function(){OpenLayers.Control.prototype.destroy.apply(this,arguments)
},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);
return this.div
},reset:function(){if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.processComponent)&&!Legato.Lang.ObjectUtils.isNullOrUndefined(this.processComponent.container)){this.div.removeChild(this.processComponent.container);
this.processComponent.destroy();
this.currentProcessModel.destroy();
this.processComponent=null;
this.currentProcessModel=null;
this.processDescription=null
}},createGeometry:function(a,b,d,c){this.reset();
this.processDescription=this.createCreateGeometryProcressDesc(a,b);
this.execute(this.processDescription,d,c)
},editGeometry:function(a,b,e,d){this.reset();
this.processDescription=this.createEditGeometryProcressDesc(a,b);
this.execute(this.processDescription,e,d);
var f=new OpenLayers.Format.GeoJSON();
var c=f.parseGeometry(b.geometry);
this.map.zoomToExtent(c.getBounds())
},execute:function(a,c,b){this.currentProcessModel=new WPS.Model.Process(this.map,a);
this.processComponent=new WPS.Component.Process(this.currentProcessModel,this.map,OpenLayers.Function.bind(function(e,d){if(c(this.getProcessModelAsGeoJSON(e.processModel.models))===true){this.reset()
}},this),OpenLayers.Function.bind(function(d){if(b()===true){this.reset()
}},this),{componentFactoryOptions:{styles:this.styles}});
this.processComponent.events.on({geoInputActivation:this.geoInputActivated,scope:this});
this.geoInputActivated();
this.div.appendChild(this.processComponent.container)
},geoInputActivated:function(){this.events.triggerEvent("activate",{})
},createBasicProcessDesc:function(a,b){var c={identifier:{value:a.id},title:{value:a.title},"abstract":{value:a.description},dataInputs:{input:[{identifier:{value:b.id},title:{value:b.title},"abstract":{value:b.description},minOccurs:1,maxOccurs:1,complexData:{"default":{format:{schema:"http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#"}}}}]}};
return c
},createCreateGeometryProcressDesc:function(a,b){var c=this.createBasicProcessDesc(a,b);
c.dataInputs.input[0].complexData["default"].format.schema+=b.type;
return c
},createEditGeometryProcressDesc:function(a,b){var c=this.createBasicProcessDesc(a,b);
c.dataInputs.input[0].complexData["default"].format.schema+=b.geometry.type;
c.dataInputs.input[0].complexData.defaultValue={content:[{value:b.geometry}]};
return c
},getProcessModelAsGeoJSON:function(d){var c=new OpenLayers.Format.GeoJSON();
if(d.length===1){var a=d[0].value;
return c.extract.geometry.apply(c,[a])
}var b=[];
for(i=0;
i<d.length;
i++){b[i]=d[i].value
}return c.extract.geometry.apply(c,[new OpenLayers.Geometry.Collection(b)])
},activate:function(){if(!Legato.Lang.ObjectUtils.exists(this.processComponent)){return
}this.processComponent.activate()
},deactivate:function(){if(!Legato.Lang.ObjectUtils.exists(this.processComponent)){return
}this.processComponent.deactivate()
},CLASS_NAME:"WPS.Control.GeometryEditor"});
WPS.Control.GeometryEditor.Bean=WPS.Control.Bean.Extend("WPS.Control.GeometryEditor",WPS.Control.QName("GeometryEditor"),{_constructor:WPS.Control.GeometryEditor,options:{map:OpenLayers.Map,styles:Legato.Beans.Object.List()}});
WPS.Control.GeoControlSyncGeometryEditor=OpenLayers.Class(WPS.Control,{editor:null,syncEvent:null,initialize:function(a){if(!a.displayClass){a.displayClass="LegatoControlInvisible"
}OpenLayers.Control.prototype.initialize.apply(this,arguments);
if(Legato.Lang.ObjectUtils.exists(this.editor)){this.editor.events.on({activate:this.geoInputActivated,scope:this})
}},geoInputActivated:function(){Legato.Util.fireDOMEvent(this.panel_div,"click")
},destroy:function(){if(Legato.Lang.ObjectUtils.exists(this.editor)){this.editor.events.un({activate:this.geoInputActivated,scope:this})
}OpenLayers.Control.prototype.destroy.apply(this,arguments)
},activate:function(){if(Legato.Lang.ObjectUtils.exists(this.editor)){this.editor.activate()
}WPS.Control.prototype.activate.apply(this,arguments)
},deactivate:function(){if(Legato.Lang.ObjectUtils.exists(this.editor)){this.editor.deactivate()
}WPS.Control.prototype.deactivate.apply(this,arguments)
},CLASS_NAME:"WPS.Control.GeoControlSyncGeometryEditor"});
WPS.Control.GeoControlSyncGeometryEditor.Bean=WPS.Control.Bean.Extend("WPS.Control.GeoControlSyncGeometryEditor",WPS.Control.QName("GeoControlSyncGeometryEditor"),{_constructor:WPS.Control.GeoControlSyncGeometryEditor,options:{editor:WPS.Control.GeometryEditor}});
WPS.Control.ObjectVisualizer=OpenLayers.Class(WPS.Control,{map:null,currentLayerId:0,factory:null,initialize:function(a){Legato.Util.Ensure.ensureExists(a.map,"map must be defined");
OpenLayers.Control.prototype.initialize.apply(this,arguments);
this.factory=new WPS.Result.Factory(a.map,null)
},destroy:function(){OpenLayers.Control.prototype.destroy.apply(this,arguments)
},setBoundingBox:function(d,a,b,c){Legato.Util.Ensure.ensureNumber(d,"The parameter for the minimum horizontal coordinate must be a number.");
Legato.Util.Ensure.ensureNumber(a,"The parameter for the minimum vertical coordinate must be a number.");
Legato.Util.Ensure.ensureNumber(b,"The parameter for the maximum horizontal coordinate must be a number.");
Legato.Util.Ensure.ensureNumber(c,"The parameter for the maximum vertical coordinate must be a number.");
var e=new OpenLayers.Bounds(d,a,b,c);
this.map.zoomToExtent(e)
},setCenterAndScale:function(a,c,b){Legato.Util.Ensure.ensureNumber(a,"The parameter for the horizontal coordinate must be a number.");
Legato.Util.Ensure.ensureNumber(c,"The parameter for the vertical coordinate must be a number.");
if(b!==null){Legato.Util.Ensure.ensureNumber(b,"The parameter for the scale must be a number.")
}this.map.zoomToScale(b);
this.map.setCenter(new OpenLayers.LonLat(a,c))
},visualize:function(h,k){var g=this.getLayer(h);
var f={left:Number.MAX_VALUE,bottom:Number.MAX_VALUE,right:Number.MIN_VALUE,top:Number.MIN_VALUE};
for(var i=0;
i<k.length;
i++){var c=k[i];
Legato.Util.Ensure.ensureExists(c.geometry,"geometry must be defined");
var e=this.createBasicResultObject(c.geometry);
var d=this.setAndReturnBasicGraphicsInformation(e,c.geometry);
if(Legato.Lang.ObjectUtils.exists(c.style)){this.setStyleInformation(c.style,d)
}if(Legato.Lang.ObjectUtils.exists(c.mapTip)){this.setMapTipInformation(c.mapTip,e)
}var b=this.factory.createResult(e);
var j=new WPS.Result.ExecutionContext(this.map);
var l=b.createAndAddMarkerFeature(j);
var a=l.geometry.getBounds();
f.left=Math.min(f.left,a.left);
f.bottom=Math.min(f.bottom,a.bottom);
f.right=Math.max(f.right,a.right);
f.top=Math.max(f.top,a.top)
}if(k.length>0){this.map.zoomToExtent(new OpenLayers.Bounds(f.left,f.bottom,f.right,f.top))
}for(i=0;
i<this.map.layers.length;
i++){if(this.map.layers[i]==g){return
}}this.map.addLayer(g)
},getLayer:function(b){if(!Legato.Lang.ObjectUtils.isNull(b)){var e=this.map.layers;
for(var a=0;
a<e.length;
a++){var c=e[a];
if(b==c.name){return c
}}}var d={displayInLayerSwitcher:true,calculateInRange:function(){return true
},style:WPS.Feature.Style.ACTIVE};
if(!Legato.Lang.ObjectUtils.isNull(b)){return new OpenLayers.Layer.Vector(b,d)
}else{this.currentLayerId++;
return new OpenLayers.Layer.Vector("Result Marker Layer #"+this.currentLayerId,d)
}},setStyleInformation:function(a,b){fillParameters=["fill"];
strokeParameters=["stroke","stroke-width"];
b.fill={svgParameter:[]};
b.stroke={svgParameter:[]};
this.setStyleParameters(a,b.fill,fillParameters);
this.setStyleParameters(a,b.stroke,strokeParameters)
},setStyleParameters:function(d,a,c){for(var b=0;
b<c.length;
b++){var e=c[b];
if(Legato.Lang.ObjectUtils.exists(d[e])){a.svgParameter.push({name:e,content:[d[e]]})
}}},setMapTipInformation:function(b,a){a.processOutputs.output[0].data.complexData.content[0].value.message={value:{content:b}}
},setAndReturnBasicGraphicsInformation:function(c,a){var b=c.processOutputs.output[0].data.complexData.content[0].value.geometry.value.symbolizer.value;
switch(a.type){case"Point":c.processOutputs.output[0].data.complexData.content[0].value.geometry.value.symbolizer.value={graphic:{externalGraphicOrMark:[{}]}};
return c.processOutputs.output[0].data.complexData.content[0].value.geometry.value.symbolizer.value.graphic.externalGraphicOrMark[0];
case"LineString":case"Polygon":return b
}},createBasicResultObject:function(b){var a=WPSPD.Result.Marker.ComplexFactory.prototype.schema;
var c={processOutputs:{output:[{data:{complexData:{schema:a,content:[{value:{geometry:{value:{geometry:{value:b},symbolizer:{value:{}}}}}}]}}}]}};
return c
},CLASS_NAME:"WPS.Control.ObjectVisualizer"});
WPS.Control.ObjectVisualizer.Bean=WPS.Control.Bean.Extend("WPS.Control.ObjectVisualizer",WPS.Control.QName("ObjectVisualizer"),{_constructor:WPS.Control.ObjectVisualizer,options:{map:OpenLayers.Map}});
WPS.Control.ToggleWpsForm=OpenLayers.Class(WPS.Control,{type:OpenLayers.Control.TYPE_TOGGLE,form:null,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments);
if(Legato.Lang.ObjectUtils.exists(this.form)){this.form.events.on({processSelectionCancellation:this.deactivate,scope:this});
this.form.events.on({on:this.activate,scope:this});
this.form.events.on({off:this.deactivate,scope:this})
}},destroy:function(){if(Legato.Lang.ObjectUtils.exists(this.form)){this.form.events.un({processSelectionCancellation:this.deactivate,scope:this});
this.form.events.un({on:this.activate,scope:this});
this.form.events.un({off:this.deactivate,scope:this})
}OpenLayers.Control.prototype.destroy.apply(this,arguments)
},activate:function(){if(Legato.Lang.ObjectUtils.exists(this.form)&&(this.form.isOn===false)){this.form.on()
}WPS.Control.prototype.activate.apply(this,arguments)
},deactivate:function(){if(Legato.Lang.ObjectUtils.exists(this.form)&&(this.form.isOn===true)){this.form.off()
}WPS.Control.prototype.deactivate.apply(this,arguments)
},CLASS_NAME:"WPS.Control.ToggleWpsForm"});
WPS.Control.ToggleWpsForm.Bean=WPS.Control.Bean.Extend("WPS.Control.ToggleWpsForm",WPS.Control.QName("ToggleWpsForm"),{_constructor:WPS.Control.ToggleWpsForm,options:{form:WPS.Form}});
WPS.Control.WpsButton=OpenLayers.Class(WPS.Control,{type:OpenLayers.Control.TYPE_BUTTON,form:null,wpsOperations:null,processIdentifier:null,processDescription:null,initialize:function(a){Legato.Util.Ensure.ensureExists(a.form,"form must be defined");
OpenLayers.Control.prototype.initialize.apply(this,arguments);
if(Legato.Lang.ObjectUtils.exists(this.form)){this.form.events.on({processSelectionCancellation:this.deactivate,scope:this})
}OpenLayers.Util.extend(this,a);
if(!Legato.Lang.ObjectUtils.exists(this.processIdentifier)&&Legato.Lang.ObjectUtils.exists(this.processDescription)){this.processIdentifier=this.processDescription.identifier.value
}if(this.wpsOperations===null){this.wpsOperations=WpsOperations
}},parseDescriptions:function(b){if(this.panel_div===null){return
}var a=b.processDescription;
for(var c=0;
c<a.length;
c++){var e=a[c];
if(Legato.Lang.ObjectUtils.isArray(e.metadata)){for(var d=0;
d<e.metadata.length;
d++){if(e.metadata[d].about=="shortcut icon"){this.panel_div.style.backgroundImage="url("+e.metadata[d].href+")"
}}}}},draw:function(c){if(this.processDescription===null){var b={identifier:[{value:this.processIdentifier}]};
this.wpsOperations.describeProcess(b,OpenLayers.Function.bind(this.parseDescriptions,this))
}else{var a={processDescription:[this.processDescription]};
this.parseDescriptions(a)
}OpenLayers.Control.prototype.draw.apply(this,arguments);
return this.div
},destroy:function(){OpenLayers.Control.prototype.destroy.apply(this,arguments)
},trigger:function(){if(Legato.Lang.ObjectUtils.exists(this.form)){this.form.off();
if(Legato.Lang.ObjectUtils.exists(this.form.processComponent)){this.form.cancelExecution()
}this.form.selectProcess(this.processIdentifier,true);
this.form.on()
}},CLASS_NAME:"WPS.Control.WpsButton"});
WPS.Control.WpsButton.Bean=WPS.Control.Bean.Extend("WPS.Control.WpsButton",WPS.Control.QName("WpsButton"),{_constructor:WPS.Control.WpsButton,options:{form:WPS.Form,wpsOperations:Legato.Lang.Function,processIdentifier:Legato.Lang.String,processDescription:Legato.Lang.Object}});
WPS.Model.BoundingBox=OpenLayers.Class(WPS.Model,{dataType:null,populateData:function(a){a.data.boundingBoxData=this.getValue();
return a
},needsUserInput:function(){return false
},setExtent:function(a){if(Legato.Lang.ObjectUtils.exists(a)&&Legato.Lang.ObjectUtils.isNumber(a.left)&&Legato.Lang.ObjectUtils.isNumber(a.right)&&Legato.Lang.ObjectUtils.isNumber(a.bottom)&&Legato.Lang.ObjectUtils.isNumber(a.top)){this.setChecked(true);
this.setValue({lowerCorner:[a.left,a.bottom],upperCorner:[a.right,a.top]})
}else{this.setChecked=false;
this.setValue(null)
}},CLASS_NAME:"WPS.Model.BoundingBox"});
WPS.Model.Complex=OpenLayers.Class(WPS.Model,{defaultFormat:null,populateData:function(a){a.data.complexData={};
a.data.complexData.content=this.getContent();
if(Legato.Lang.ObjectUtils.exists(this.defaultFormat)&&Legato.Lang.ObjectUtils.exists(this.defaultFormat.schema)){a.data.complexData.schema=this.defaultFormat.schema
}return a
},getContent:function(){return this.inverse(this.getValue())
},setContent:function(a){this.setValue(this.direct(a))
},setDefaultContent:function(a){this.setDefaultValue(this.direct(a))
},direct:function(a){return a
},inverse:function(a){return a
},getSchema:function(){if(this.defaultFormat===null){return null
}return this.defaultFormat.schema
},CLASS_NAME:"WPS.Model.Complex"});
WPS.Model.Factory=OpenLayers.Class({map:null,initialize:function(a){this.map=a
},createModel:function(h){var g={};
g.identifier=h.identifier.value;
g.title=h.title.value;
g["abstract"]=h["abstract"].value;
if(Legato.Lang.ObjectUtils.isNotEmptyArray(h.metadata)){g.metadata=h.metadata
}g.minOccurs=Legato.Lang.ObjectUtils.exists(h.minOccurs)?h.minOccurs:1;
g.maxOccurs=Legato.Lang.ObjectUtils.exists(h.maxOccurs)?h.maxOccurs:1;
var b;
if(Legato.Lang.ObjectUtils.exists(h.literalData)){var f=h.literalData;
g.dataType=Legato.Lang.ObjectUtils.exists(f.dataType)?f.dataType.value:null;
g.defaultValue={value:(Legato.Lang.ObjectUtils.exists(f.defaultValue)?f.defaultValue:null),uom:null};
if(Legato.Lang.ObjectUtils.exists(f.allowedValues)){g.allowedValues=[];
for(var c=0;
c<f.allowedValues.valueOrRange.length;
c++){g.allowedValues.push(f.allowedValues.valueOrRange[c].value)
}}else{g.allowedValues=null
}b=new WPS.Model.Literal(this,g)
}else{if(Legato.Lang.ObjectUtils.exists(h.boundingBoxData)){var d=h.boundingBoxData;
b=new WPS.Model.BoundingBox(this,g);
if(Legato.Lang.ObjectUtils.exists(this.map)){b.setExtent(this.map.getExtent())
}}else{if(Legato.Lang.ObjectUtils.exists(h.complexData)){var a=h.complexData;
if(!Legato.Lang.ObjectUtils.exists(a["default"].format)){throw new Legato.Lang.Exception("Missing default format in complex data")
}g.defaultFormat=a["default"].format;
if(!Legato.Lang.ObjectUtils.exists(g.defaultFormat)){throw new Legato.Lang.Exception("Missing schema definition in default format")
}var e=g.defaultFormat.schema;
if(WPS.GEOM_POINT_URI===e||WPS.GEOM_MULTI_POINT_URI===e||WPS.GEOM_LINE_STRING_URI===e||WPS.GEOM_MULTI_LINE_STRING_URI===e||WPS.GEOM_POLYGON_URI===e||WPS.GEOM_MULTI_POLYGON_URI===e){b=new WPS.Model.Geo(this,g);
if(Legato.Lang.ObjectUtils.exists(a.defaultValue)){b.setDefaultContent(a.defaultValue.content)
}}else{throw new Legato.Lang.Exception("Unsupported complex data type: "+e)
}}else{throw new Legato.Lang.Exception("Unsupported input description type")
}}}return b
},destroy:function(){},CLASS_NAME:"WPS.Model.Factory"});
WPS.Model.Geo=OpenLayers.Class(WPS.Model.Complex,{geoJsonFormat:null,initialize:function(b,a){this.geoJsonFormat=new OpenLayers.Format.GeoJSON();
WPS.Model.Complex.prototype.initialize.apply(this,arguments)
},inverse:function(c){var b=this.geoJsonFormat.extract.geometry.call(this.geoJsonFormat,c);
var a={namespaceURI:"http://www.opengis.net/gml",localPart:b.type,prefix:"gml"};
var d={name:a,value:b};
return[d]
},direct:function(a){var b=a[0].value;
return this.geoJsonFormat.parseGeometry(b)
},CLASS_NAME:"WPS.Model.Geo"});
WPS.Model.Literal=OpenLayers.Class(WPS.Model,{dataType:null,populateData:function(a){a.data.literalData=this.getValue();
if(Legato.Lang.ObjectUtils.exists(this.dataType)){a.data.literalData.dataType=this.dataType
}return a
},CLASS_NAME:"WPS.Model.Literal"});
WPS.Model.Process=OpenLayers.Class({EVENT_TYPES:["validitychange"],map:null,processDescription:null,processIdentifier:null,modelFactory:null,models:null,events:null,initialize:function(f,e,d){OpenLayers.Util.extend(this,d);
this.events=new OpenLayers.Events(this,null,this.EVENT_TYPES);
this.map=f;
this.processDescription=e;
this.processIdentifier=e.identifier.value;
this.models=[];
if(!Legato.Lang.ObjectUtils.exists(this.modelFactory)){this.modelFactory=new WPS.Model.Factory(this.map)
}if(this.processDescription.dataInputs&&this.processDescription.dataInputs.input){var a=this.processDescription.dataInputs.input;
for(var c=0;
c<a.length;
c++){var g=a[c];
var b=this.modelFactory.createModel(g);
this.models.push(b)
}}},destroy:function(){if(Legato.Lang.ObjectUtils.exists(this.events)){this.events.destroy();
this.events=null
}this.processDescription=null;
if(Legato.Lang.ObjectUtils.exists(this.modelFactory)){this.modelFactory.destroy();
this.modelFactory=null
}if(Legato.Lang.ObjectUtils.exists(this.models)){for(var a=0;
a<this.models.length;
a++){this.models[a].destroy()
}this.models=null
}},getData:function(){var a=[];
for(var b=0;
b<this.models.length;
b++){var c=this.models[b].getData();
if(Legato.Lang.ObjectUtils.exists(c)){for(var e=0;
e<c.length;
e++){a.push(c[e])
}}}var d={service:"WPS",version:"1.0.0",identifier:this.processDescription.identifier,dataInputs:{input:a}};
return d
},needsUserInput:function(){for(var a=0;
a<this.models.length;
a++){if(this.models[a].needsUserInput()){return true
}}return false
},CLASS_NAME:"WPS.Model.Process"});
WPS.Component.AbstractInput=OpenLayers.Class(WPS.Component,{container:null,titleElement:null,checkedBox:null,validitySymbol:null,hidden:false,initializeAdditionalElements:function(f,b,e,a){this.container=document.createElement("div");
this.container.id=this.id+"_Container";
if(this.model.required){OpenLayers.Element.addClass(this.container,"required")
}this.container.onmouseover=OpenLayers.Function.bindAsEventListener(this.hoverIn,this);
this.container.onmouseout=OpenLayers.Function.bindAsEventListener(this.hoverOut,this);
this.container.component=this;
var c=document.createElement("div");
OpenLayers.Element.addClass(c,"isInputChecked");
this.container.appendChild(c);
this.checkedBox=document.createElement("input");
this.checkedBox.type="checkbox";
this.checkedBox.name=this.id+"_Checked";
this.checkedBox.checked=this.model.checked;
this.checkedBox.onclick=OpenLayers.Function.bindAsEventListener(this.checkedChanged,this);
c.appendChild(this.checkedBox);
this.validitySymbol=document.createElement("div");
OpenLayers.Element.addClass(this.validitySymbol,"validitySymbol");
this.container.appendChild(this.validitySymbol);
this.titleElement=document.createElement("div");
OpenLayers.Element.addClass(this.titleElement,"title");
this.titleElement.innerHTML=b.title;
this.container.appendChild(this.titleElement);
var d=this.initializeInputs();
d.title=b["abstract"];
this.initializeMetaData();
this.updateValiditySymbol()
},destroy:function(){WPS.Component.prototype.destroy.apply(this,arguments);
this.container=null;
if(Legato.Lang.ObjectUtils.exists(this.checkedBox)){this.checkedBox.onclick=null;
this.checkedBox=null
}if(Legato.Lang.ObjectUtils.exists(this.container)){this.container.component=null;
this.container.onmouseover=null;
this.container.onmouseout=null;
this.container=null
}},initializeInputs:function(){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the initializeInputs function from from abstract class "+WPS.Component.CLASS_NAME)
},initializeMetaData:function(){if(!Legato.Lang.ObjectUtils.isNotEmptyArray(this.model.metadata)){return
}for(var a=0;
a<this.model.metadata.length;
a++){this.handleMetaData(this.model.metadata[a])
}},handleMetaData:function(b){var c=Legato.Lang.ObjectUtils.exists(b.about)?b.about:null;
var a=Legato.Lang.ObjectUtils.exists(b.href)?b.href:null;
var d=Legato.Lang.ObjectUtils.exists(b.title)?b.title:null;
if(c==="visibility"&&a==="hidden"){this.hidden=true;
OpenLayers.Element.hide(this.container)
}},isAccessable:function(){return OpenLayers.Element.visible(this.container)
},checkedChanged:function(b){var a=(b.target||b.srcElement).checked;
this.model.setChecked(a)
},onModelValueChange:function(a){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the onModelValueChange function from from abstract class "+WPS.Component.CLASS_NAME)
},updateValiditySymbol:function(){this.validitySymbol.title="";
if(this.model.valid){OpenLayers.Element.addClass(this.container,"valid");
OpenLayers.Element.removeClass(this.container,"invalid")
}else{OpenLayers.Element.addClass(this.container,"invalid");
OpenLayers.Element.removeClass(this.container,"valid");
this.validitySymbol.title+=this.model.validationMessages.join("; ")
}},onModelValidityChange:function(a){this.updateValiditySymbol();
this.events.triggerEvent("validitychange",{component:this})
},appendTo:function(a){a.appendChild(this.container)
},activate:function(){this.onActivation()
},deactivate:function(){this.onDeactivation()
},onActivation:function(a){WPS.Component.prototype.onActivation.apply(this,arguments);
this.replaceStatusClass("inputContainerActive");
this.checkedBox.checked=true
},onDeactivation:function(a){this.status=WPS.Component.STATUS_INACTIVE;
this.replaceStatusClass("inputContainerInactive");
if(a){this.events.triggerEvent("deactivate",{component:this})
}},onHoverIn:function(){var a=this.status;
WPS.Component.prototype.onHoverIn.apply(this,arguments);
if(WPS.Component.STATUS_INACTIVE===a){this.replaceStatusClass("inputContainerInactiveHover")
}else{this.replaceStatusClass("inputContainerActiveHover")
}},onHoverOut:function(b){var a=this.status;
WPS.Component.prototype.onHoverOut.apply(this,arguments);
if(WPS.Component.STATUS_ACTIVE_HOVER===a){this.replaceStatusClass("inputContainerActive")
}else{this.replaceStatusClass("inputContainerInactive")
}},replaceStatusClass:function(a){if(this.container){OpenLayers.Element.removeClass(this.container,"inputContainerInactive");
OpenLayers.Element.removeClass(this.container,"inputContainerInactiveHover");
OpenLayers.Element.removeClass(this.container,"inputContainerActive");
OpenLayers.Element.removeClass(this.container,"inputContainerActiveHover");
OpenLayers.Element.addClass(this.container,a)
}},CLASS_NAME:"WPS.Component.AbstractInput"});
WPS.Component.AbstractGeometry=OpenLayers.Class(WPS.Component.AbstractInput,{inputPanelDiv:null,inputPanel:null,geoInputControl:null,geoModifyControl:null,featureSelector:null,map:null,layer:null,featureGeometrySelectionController:null,geometryType:null,initialize:function(d,b,c,a){WPS.Component.AbstractInput.prototype.initialize.apply(this,arguments);
this.geoInputControl.events.on({activate:this.geoInputControlActivated,deactivate:this.geoInputControlDeactivated,scope:this});
this.geoModifyControl.events.on({activate:this.geoModifyControlActivated,scope:this});
if(this.featureSelector){this.featureSelector.events.on({activate:this.featureSelectorActivated,scope:this})
}},destroy:function(){this.geoInputControl.events.un({activate:this.controlActivated,deactivate:this.controlDeactivated,scope:this});
this.geoModifyControl.events.un({activate:this.geoModifyControlActivated,scope:this});
if(this.featureSelector){this.featureSelector.events.un({activate:this.featureSelectorActivated,scope:this})
}this.unregisterLayerEvents();
if(Legato.Lang.ObjectUtils.exists(this.map)&&Legato.Lang.ObjectUtils.exists(this.layer)){this.map.removeLayer(this.layer)
}WPS.Component.AbstractInput.prototype.destroy.apply(this,arguments)
},checkedChanged:function(b){WPS.Component.AbstractInput.prototype.checkedChanged.call(this,b);
var a=(b.target||b.srcElement).checked;
if(!a){this.geoInputControl.deactivate();
this.geoModifyControl.deactivate();
if(this.featureSelector){this.featureSelector.deactivate()
}}},geoModifyControlActivated:function(){this.geoInputControl.deactivate();
if(this.featureSelector){this.featureSelector.deactivate()
}this.onActivation(true)
},geoInputControlActivated:function(){this.geoModifyControl.deactivate();
if(this.featureSelector){this.featureSelector.deactivate()
}this.onActivation(true)
},geoInputControlDeactivated:function(){this.onDeactivation(true)
},featureSelectorActivated:function(){this.geoModifyControl.deactivate();
this.geoInputControl.deactivate();
this.onActivation(true)
},initializeInputs:function(){var b={displayInLayerSwitcher:false,legatoIgnore:true,calculateInRange:function(){return true
},isFeatureLayer:true};
this.layer=new OpenLayers.Layer.Vector(this.model.identifier+"Input",b);
this.layer.style=this.getActiveStyle();
this.map.addLayer(this.layer);
this.layer.setZIndex(this.map.Z_INDEX_BASE.Feature-1);
this.registerLayerEvents();
this.inputPanelDiv=document.createElement("div");
OpenLayers.Element.addClass(this.inputPanelDiv,"olControlPanel");
this.container.appendChild(this.inputPanelDiv);
var a={div:this.inputPanelDiv};
this.inputPanel=new OpenLayers.Control.Panel(a);
this.map.addControl(this.inputPanel);
this.initializeGeoInputControl();
this.initializeGeoModifyControl();
this.initializeFeatureSelector();
return this.inputPanelDiv
},onGeometryChange:function(a){switch(a.type){case"featuresadded":this.updateModelGeometries();
break;
case"featuresremoved":this.updateModelGeometries();
break;
case"featuremodified":this.updateModelGeometries();
break;
default:break
}},activate:function(){if(!(this.geoInputControl.active||this.geoModifyControl.active||(this.featureSelector&&this.featureSelector.active))){if(this.featureSelector&&Legato.OpenLayers.Map.Util.getSelectedLayers(this.map.layers)){this.featureSelector.activate()
}else{this.geoInputControl.activate()
}this.onActivation()
}},deactivate:function(){this.geoInputControl.deactivate();
this.geoModifyControl.deactivate();
if(this.featureSelector){this.featureSelector.deactivate()
}this.onDeactivation()
},initializeGeoInputControl:function(){var a=this.createGeoInputControl();
this.inputPanel.addControls([a]);
this.geoInputControl=a
},initializeGeoModifyControl:function(){var a=this.createGeoModifyControl();
this.inputPanel.addControls([a]);
this.geoModifyControl=a
},initializeFeatureSelector:function(){if(Legato.Lang.ObjectUtils.exists(this.featureGeometrySelectionController)){var e=this;
var h=e.geometryType;
var b=new Legato.Predicate.And([new Legato.Layer.Predicate.SelectedLayer(),new Legato.Layer.Predicate.LayerWithAttribute({name:"featureLayer",value:"true"}),new Legato.Layer.Predicate.LayerWithAttribute({name:"geometryType",predicate:new Legato.Predicate.Contains(h)})]);
var a=e.featureGeometrySelectionController;
var g=new OpenLayers.Format.GeoJSON();
var d=e.model;
var c=function(l,k,m,o){var s=[];
for(var n=0;
n<l.length;
n++){s.push(Legato.Lang.ObjectUtils.exists(l[n].layerId)?l[n].layerId:l[n].name)
}var q=g.extract.geometry.call(g,k);
var j=g.extract.geometry.call(g,d.getValue());
var p=m===OpenLayers.Handler.MOD_CTRL?true:false;
var r=m===OpenLayers.Handler.MOD_SHIFT?true:false;
a(s,h,q,j,p,r,o)
};
var i=function(j){if(!Legato.Lang.ObjectUtils.isNullOrUndefined(j)&&j.type===h){d.setValue(g.parseGeometry(j))
}else{throw new Legato.Lang.Exception(WPS.I18n.getMessage("WPS.AbstractGeometry.InvalidSelectionGeometryType",{invalidGeometryType:j.type,validGeometryType:h}))
}};
var f=new Legato.Control.FeatureSelector({layerPredicate:b,controller:c,callback:i,title:WPS.I18n.getMessage("WPS.AbstractGeometry.Select")});
this.inputPanel.addControls([f]);
this.featureSelector=f
}else{this.featureSelector=null
}},createGeoInputControl:function(){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the createGeoInputControl function from from abstract class "+WPS.Component.AbstractGeometry.CLASS_NAME)
},createGeoModifyControl:function(){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the createGeoModifyControl function from from abstract class "+WPS.Component.AbstractGeometry.CLASS_NAME)
},registerLayerEvents:function(){this.layer.events.on({featuresadded:this.onGeometryChange,featuresremoved:this.onGeometryChange,featuremodified:this.onGeometryChange,scope:this})
},unregisterLayerEvents:function(){this.layer.events.un({featuresadded:this.onGeometryChange,featuresremoved:this.onGeometryChange,featuremodified:this.onGeometryChange,scope:this})
},getLayerGeometry:function(){var a=this.getLayerGeometries();
if(Legato.Lang.ObjectUtils.isArray(a)){if(a.length>0){return a[0]
}else{return null
}}else{return null
}},getLayerGeometries:function(){var c=this.layer.features;
if(Legato.Lang.ObjectUtils.isArray(c)){var b=[];
for(var a=0;
a<c.length;
a++){if(Legato.Lang.ObjectUtils.exists(c[a].geometry)){var e=c[a].geometry;
if((e.CLASS_NAME==="OpenLayers.Geometry.MultiPoint"||e.CLASS_NAME==="OpenLayers.Geometry.MultiLineString"||e.CLASS_NAME==="OpenLayers.Geometry.MultiPolygon")&&Legato.Lang.ObjectUtils.isArray(e.components)){for(var d=0;
d<e.components.length;
d++){if(Legato.Lang.ObjectUtils.exists(e.components[d])){b.push(e.components[d])
}}}else{b.push(e)
}}}return b
}else{return null
}},setLayerGeometry:function(a){if(Legato.Lang.ObjectUtils.exists(a)){this.setLayerGeometries([a])
}else{this.setLayerGeometries(null)
}},setLayerGeometries:function(d){if(Legato.Lang.ObjectUtils.isArray(d)){var e=this.layer.features.slice();
this.layer.destroyFeatures(null,{silent:true});
var a=[];
for(var b=0;
b<d.length;
b++){var c;
if(b<e.length){c=e[b];
c.geometry=d[b]
}else{c=new OpenLayers.Feature.Vector(d[b])
}a.push(c)
}this.layer.addFeatures(a,{silent:true})
}else{this.layer.destroyFeatures(null,{silent:true})
}},updateLayerGeometries:function(){var a=this.model.getValue();
this.layer.geometry=a;
if(a===null){this.setLayerGeometries(null)
}else{if(a.CLASS_NAME==="OpenLayers.Geometry.MultiPoint"||a.CLASS_NAME==="OpenLayers.Geometry.MultiLineString"||a.CLASS_NAME==="OpenLayers.Geometry.MultiPolygon"){this.setLayerGeometries(a.components)
}else{this.setLayerGeometries([a])
}}},updateModelGeometries:function(){var a=this.layer.geometry;
if(this.layer.geometry===undefined||this.layer.geometry===null){this.layer.geometry=this.getLayerGeometry()
}else{if(a.CLASS_NAME==="OpenLayers.Geometry.MultiPoint"||a.CLASS_NAME==="OpenLayers.Geometry.MultiLineString"||a.CLASS_NAME==="OpenLayers.Geometry.MultiPolygon"){a.removeComponents(a.components);
a.addComponents(this.getLayerGeometries())
}else{this.layer.geometry=this.getLayerGeometry()
}}this.model.setValue(this.layer.geometry)
},onModelValueChange:function(a){this.updateLayerGeometries()
},redrawFeaturesWithStyle:function(c){var b=this.layer.features;
if(b){for(var a=0;
a<b.length;
a++){this.layer.drawFeature(b[a],c)
}}},onHoverIn:function(){if(WPS.Component.STATUS_INACTIVE===this.status){this.redrawFeaturesWithStyle(this.getInactiveHoverStyle())
}else{this.redrawFeaturesWithStyle(this.getActiveHoverStyle())
}WPS.Component.AbstractInput.prototype.onHoverIn.call(this)
},onHoverOut:function(){if(WPS.Component.STATUS_ACTIVE_HOVER===this.status){this.redrawFeaturesWithStyle(this.getActiveStyle())
}else{this.redrawFeaturesWithStyle(this.getInactiveStyle())
}WPS.Component.AbstractInput.prototype.onHoverOut.call(this)
},onActivation:function(a){this.redrawFeaturesWithStyle(this.getActiveStyle());
WPS.Component.AbstractInput.prototype.onActivation.call(this,a)
},onDeactivation:function(a){WPS.Component.AbstractInput.prototype.onDeactivation.call(this,a);
this.redrawFeaturesWithStyle(this.getInactiveStyle())
},getNamedStyle:function(a){if(!Legato.Lang.ObjectUtils.exists(this.styles)){return null
}for(var b=0;
b<this.styles.length;
b++){if(this.styles[b].name===a){return this.styles[b].styles
}}return null
},getDefaultStyle:function(){return null
},getActiveStyle:function(){var a=OpenLayers.Util.extend({},WPS.Feature.Style.ACTIVE);
return OpenLayers.Util.extend(a,this.getDefaultStyle())
},getInactiveStyle:function(){var a=OpenLayers.Util.extend({},WPS.Feature.Style.INACTIVE);
return OpenLayers.Util.extend(a,this.getDefaultStyle())
},getInactiveHoverStyle:function(){var a=OpenLayers.Util.extend({},WPS.Feature.Style.INACTIVE_HOVER);
return OpenLayers.Util.extend(a,this.getDefaultStyle())
},getActiveHoverStyle:function(){var a=OpenLayers.Util.extend({},WPS.Feature.Style.ACTIVE_HOVER);
return OpenLayers.Util.extend(a,this.getDefaultStyle())
},CLASS_NAME:"WPS.Component.AbstractGeometry"});
WPS.Component.BoundingBox=OpenLayers.Class(WPS.Component,{initialize:function(d,b,c,a){WPS.Component.prototype.initialize.apply(this,arguments);
this.map.events.on({moveend:this.onMoveEnd,scope:this});
this.setExtent()
},onMoveEnd:function(a){this.setExtent()
},setExtent:function(){var a=this.map.getExtent();
this.model.setExtent(a)
},destroy:function(){this.map.events.un({moveend:this.onMoveEnd,scope:this});
WPS.Component.prototype.destroy.apply(this,arguments)
},onModelValueChange:function(a){},CLASS_NAME:"WPS.Component.BoundingBox"});
WPS.Component.Factory=OpenLayers.Class({map:null,options:null,initialize:function(b,a){Legato.Util.Ensure.ensureExists(b,"map should be defined");
this.map=b;
if(Legato.Lang.ObjectUtils.isObject(a)){this.options=a
}else{this.options={}
}},createComponent:function(a){var b=OpenLayers.Util.createUniqueID("WPS_Component_");
if("WPS.Model.Literal"===a.CLASS_NAME){return new WPS.Component.Literal(b,a,this.map,this.options)
}else{if("WPS.Model.BoundingBox"===a.CLASS_NAME){return new WPS.Component.BoundingBox(b,a,this.map,this.options)
}else{if("WPS.Model.Geo"===a.CLASS_NAME){switch(a.getSchema()){case WPS.GEOM_POINT_URI:return new WPS.Component.Point(b,a,this.map,this.options);
case WPS.GEOM_MULTI_POINT_URI:return new WPS.Component.MultiPoint(b,a,this.map,this.options);
case WPS.GEOM_LINE_STRING_URI:return new WPS.Component.LineString(b,a,this.map,this.options);
case WPS.GEOM_MULTI_LINE_STRING_URI:return new WPS.Component.MultiLineString(b,a,this.map,this.options);
case WPS.GEOM_POLYGON_URI:return new WPS.Component.Polygon(b,a,this.map,this.options);
case WPS.GEOM_MULTI_POLYGON_URI:return new WPS.Component.MultiPolygon(b,a,this.map,this.options);
default:throw new Legato.Lang.Exception("Unsupported geo model type ["+a.getSchema()+"]")
}}else{throw new Legato.Lang.Exception("Unsupported model.")
}}}},destroy:function(){},CLASS_NAME:"WPS.Component.Factory"});
WPS.Component.Literal=OpenLayers.Class(WPS.Component.AbstractInput,{input:null,initializeInputs:function(){if(this.input===null){if(this.model.allowedValues===null){this.input=document.createElement("input");
this.input.type="text"
}else{this.input=document.createElement("select");
for(var a=0;
a<this.model.allowedValues.length;
a++){var b=document.createElement("option");
b.text=this.model.allowedValues[a];
this.input.appendChild(b)
}}this.container.appendChild(this.input)
}this.input.onchange=OpenLayers.Function.bindAsEventListener(this.onInputValueChange,this);
this.input.onfocus=OpenLayers.Function.bindAsEventListener(this.onInputActivated,this);
return this.input
},isDropdown:function(){return(this.input===null?false:this.input.nodeName==="SELECT")
},getValue:function(){if(this.isDropdown()){return this.input.options[this.input.selectedIndex].text
}else{return this.input.value
}},setValue:function(a){this.input.value=a
},onInputValueChange:function(){var a=this.getValue();
this.model.setValue({value:a,uom:null})
},onInputActivated:function(){this.onActivation(true)
},onModelValueChange:function(a){this.setValue(a.value.value?a.value.value:"")
},destroy:function(){WPS.Component.prototype.destroy.apply(this,arguments);
if(Legato.Lang.ObjectUtils.exists(this.input)){this.input.onchange=null;
this.input=null
}},onDeactivation:function(){WPS.Component.prototype.onDeactivation.call(this);
this.input.blur()
},CLASS_NAME:"WPS.Component.Literal"});
WPS.Component.Point=OpenLayers.Class(WPS.Component.AbstractGeometry,{geometryType:"Point",createGeoInputControl:function(){return new Legato.Control.DrawPoint(this.layer,{title:WPS.I18n.getMessage("WPS.Point.Draw"),mode:Legato.Control.DrawFeature.MODE_REPLACE_FEATURE,type:OpenLayers.Control.TYPE_TOGGLE,style:this.getDefaultStyle()})
},createGeoModifyControl:function(){return new Legato.Control.ModifyPoint(this.layer,{title:WPS.I18n.getMessage("WPS.Point.Edit"),mode:Legato.Control.ModifyFeature.MODE_RESHAPE,style:this.getDefaultStyle()})
},getDefaultStyle:function(){return this.getNamedStyle("Point")
},CLASS_NAME:"WPS.Component.Point"});
WPS.Component.MultiPoint=OpenLayers.Class(WPS.Component.AbstractGeometry,{geometryType:"MultiPoint",createGeoInputControl:function(){return new Legato.Control.DrawMultiPoint(this.layer,{title:WPS.I18n.getMessage("WPS.MultiPoint.Draw"),mode:Legato.Control.DrawFeature.MODE_ADD_FEATURE,type:OpenLayers.Control.TYPE_TOGGLE,style:this.getDefaultStyle()})
},createGeoModifyControl:function(){return new Legato.Control.ModifyMultiPoint(this.layer,{title:WPS.I18n.getMessage("WPS.MultiPoint.Edit"),mode:Legato.Control.ModifyFeature.MODE_RESHAPE,style:this.getDefaultStyle()})
},getDefaultStyle:function(){return this.getNamedStyle("Point")
},getLayerGeometry:function(){var a=this.getLayerGeometries();
if(Legato.Lang.ObjectUtils.isArray(a)){if(a.length>0){return new OpenLayers.Geometry.MultiPoint(a)
}else{return null
}}else{return null
}},setLayerGeometry:function(a){if(Legato.Lang.ObjectUtils.exists(a)){this.setLayerGeometries(a.components)
}else{this.setLayerGeometries(null)
}},CLASS_NAME:"WPS.Component.MultiPoint"});
WPS.Component.LineString=OpenLayers.Class(WPS.Component.AbstractGeometry,{geometryType:"LineString",createGeoInputControl:function(){return new Legato.Control.DrawLineString(this.layer,{title:WPS.I18n.getMessage("WPS.LineString.Draw"),mode:Legato.Control.DrawFeature.MODE_REPLACE_FEATURE,type:OpenLayers.Control.TYPE_TOGGLE,style:this.getDefaultStyle()})
},createGeoModifyControl:function(){return new Legato.Control.ModifyLineString(this.layer,{title:WPS.I18n.getMessage("WPS.LineString.Edit"),mode:Legato.Control.ModifyFeature.MODE_RESHAPE,style:this.getDefaultStyle()})
},getDefaultStyle:function(){return this.getNamedStyle("Line")
},CLASS_NAME:"WPS.Component.LineString"});
WPS.Component.MultiLineString=OpenLayers.Class(WPS.Component.AbstractGeometry,{geometryType:"MultiLineString",createGeoInputControl:function(){return new Legato.Control.DrawMultiLineString(this.layer,{title:WPS.I18n.getMessage("WPS.MultiLineString.Draw"),mode:Legato.Control.DrawFeature.MODE_ADD_FEATURE,type:OpenLayers.Control.TYPE_TOGGLE,style:this.getDefaultStyle()})
},createGeoModifyControl:function(){return new Legato.Control.ModifyMultiLineString(this.layer,{title:WPS.I18n.getMessage("WPS.MultiLineString.Edit"),mode:Legato.Control.ModifyFeature.MODE_RESHAPE,style:this.getDefaultStyle()})
},getDefaultStyle:function(){return this.getNamedStyle("Line")
},getLayerGeometry:function(){var a=this.getLayerGeometries();
if(Legato.Lang.ObjectUtils.isArray(a)){if(a.length>0){return new OpenLayers.Geometry.MultiLineString(a)
}else{return null
}}else{return null
}},setLayerGeometry:function(a){if(Legato.Lang.ObjectUtils.exists(a)){this.setLayerGeometries(a.components)
}else{this.setLayerGeometries(null)
}},CLASS_NAME:"WPS.Component.MultiLineString"});
WPS.Component.Polygon=OpenLayers.Class(WPS.Component.AbstractGeometry,{geometryType:"Polygon",createGeoInputControl:function(){return new Legato.Control.DrawPolygon(this.layer,{title:WPS.I18n.getMessage("WPS.Polygon.Draw"),mode:Legato.Control.DrawFeature.MODE_REPLACE_FEATURE,type:OpenLayers.Control.TYPE_TOGGLE,style:this.getDefaultStyle()})
},createGeoModifyControl:function(){return new Legato.Control.ModifyPolygon(this.layer,{title:WPS.I18n.getMessage("WPS.Polygon.Edit"),mode:Legato.Control.ModifyFeature.MODE_RESHAPE,style:this.getDefaultStyle()})
},getDefaultStyle:function(){return this.getNamedStyle("Polygon")
},CLASS_NAME:"WPS.Component.Polygon"});
WPS.Component.MultiPolygon=OpenLayers.Class(WPS.Component.AbstractGeometry,{geometryType:"MultiPolygon",createGeoInputControl:function(){return new Legato.Control.DrawMultiPolygon(this.layer,{title:WPS.I18n.getMessage("WPS.MultiPolygon.Draw"),mode:Legato.Control.DrawFeature.MODE_ADD_FEATURE,type:OpenLayers.Control.TYPE_TOGGLE,style:this.getDefaultStyle()})
},createGeoModifyControl:function(){return new Legato.Control.ModifyMultiPolygon(this.layer,{title:WPS.I18n.getMessage("WPS.MultiPolygon.Edit"),mode:Legato.Control.ModifyFeature.MODE_RESHAPE,style:this.getDefaultStyle()})
},getDefaultStyle:function(){return this.getNamedStyle("Polygon")
},getLayerGeometry:function(){var a=this.getLayerGeometries();
if(Legato.Lang.ObjectUtils.isArray(a)){if(a.length>0){return new OpenLayers.Geometry.MultiPolygon(a)
}else{return null
}}else{return null
}},setLayerGeometry:function(a){if(Legato.Lang.ObjectUtils.exists(a)){this.setLayerGeometries(a.components)
}else{this.setLayerGeometries(null)
}},CLASS_NAME:"WPS.Component.MultiPolygon"});
WPS.Component.Process=OpenLayers.Class({EVENT_TYPES:["geoInputActivation"],processModel:null,processIdentifier:null,processTitle:null,processAbstract:null,componentFactory:null,components:null,container:null,titleElement:null,abstractElement:null,componentsElement:null,executeElement:null,map:null,currentComponentId:null,activated:false,valid:false,events:null,buttonsElement:null,executeButton:null,executeCallback:null,cancelCallback:null,validationErrorElement:null,validationErrorContainer:null,txtExecute:"OK",txtCancel:"Cancel",componentFactoryOptions:null,initialize:function(a,e,d,b,c){Legato.Util.Ensure.ensureExists(a,"model should be defined");
Legato.Util.Ensure.ensureExists(e,"map should be defined");
Legato.Util.Ensure.ensureFunction(d,"execute callback should be a function");
Legato.Util.Ensure.ensureFunction(b,"cancel callback should be a function");
this.processModel=a;
this.processIdentifier=a.processIdentifier;
this.executeCallback=d;
this.cancelCallback=b;
OpenLayers.Util.extend(this,c);
this.events=new OpenLayers.Events(this,null,this.EVENT_TYPES);
if(!Legato.Lang.ObjectUtils.isObject(this.componentFactoryOptions)){this.componentFactoryOptions={}
}if(a.processDescription.title){this.processTitle=a.processDescription.title.value
}if(a.processDescription["abstract"]){this.processAbstract=a.processDescription["abstract"].value
}this.map=e;
if(!Legato.Lang.ObjectUtils.exists(this.componentFactory)){this.componentFactory=new WPS.Component.Factory(e,this.componentFactoryOptions)
}this.createProcessForm();
this.validate();
this.activate()
},createProcessForm:function(){if(this.container===null){this.container=document.createElement("div");
this.container.className="wpsContainer"
}this.titleElement=document.createElement("div");
this.titleElement.className="wpsProcessTitle";
this.titleElement.innerHTML=this.processModel.processDescription.title.value;
this.container.appendChild(this.titleElement);
this.abstractElement=document.createElement("div");
this.abstractElement.className="wpsProcessAbstract";
this.abstractElement.innerHTML=this.processModel.processDescription["abstract"].value;
this.container.appendChild(this.abstractElement);
this.validationErrorContainer=document.createElement("div");
this.validationErrorContainer.className="validationError";
OpenLayers.Element.hide(this.validationErrorContainer);
this.container.appendChild(this.validationErrorContainer);
var c=document.createElement("div");
c.className="validationErrorIcon";
this.validationErrorContainer.appendChild(c);
this.validationErrorElement=document.createElement("div");
this.validationErrorContainer.appendChild(this.validationErrorElement);
this.validationErrorContainer.appendChild(this.validationErrorElement);
this.components=[];
this.componentsElement=document.createElement("div");
this.componentsElement.className="wpsProcessInputsContainer";
this.container.appendChild(this.componentsElement);
for(var b=0;
b<this.processModel.models.length;
b++){var a=this.componentFactory.createComponent(this.processModel.models[b]);
this.components[b]=a;
a.appendTo(this.componentsElement);
a.events.on({activate:this.componentActivated,deactivate:this.componentDeactivated,validitychange:this.componentValidityChanged,scope:this})
}this.buttonsElement=document.createElement("div");
this.buttonsElement.className="wpsButtons";
this.container.appendChild(this.buttonsElement);
this.executeButton=document.createElement("input");
this.executeButton.type="button";
this.executeButton.value=this.txtExecute;
this.executeButton.onclick=OpenLayers.Function.bindAsEventListener(this.executeButtonClicked,this);
this.buttonsElement.appendChild(this.executeButton);
var d=document.createElement("input");
d.type="button";
d.value=this.txtCancel;
d.onclick=OpenLayers.Function.bindAsEventListener(this.cancelButtonClicked,this);
this.buttonsElement.appendChild(d)
},executeButtonClicked:function(){var a=this.processModel.getData();
this.deactivate();
this.executeCallback(this,a)
},cancelButtonClicked:function(){this.deactivate();
this.cancelCallback(this)
},activate:function(){var b=0;
var a=null;
if(this.currentComponentId){for(b=0;
b<this.components.length;
b++){a=this.components[b];
if(this.currentComponentId===a.id){a.activate()
}}}else{for(b=0;
b<this.components.length;
b++){a=this.components[b];
if(a.isAccessable()){a.activate()
}}}this.activated=true;
return true
},deactivate:function(){this.activated=false;
for(var b=0;
b<this.components.length;
b++){var a=this.components[b];
if(!(WPS.Component.STATUS_INACTIVE===a.status||WPS.Component.STATUS_INACTIVE===a.status)){a.deactivate()
}}return true
},validate:function(){OpenLayers.Element.hide(this.validationErrorContainer);
var c=true;
var a="";
for(var b=0;
b<this.components.length;
b++){if(!this.components[b].model.valid){c=false;
a=this.components[b].model.validationMessages[0];
break
}}this.valid=c;
this.executeButton.disabled=!this.valid;
if(!c&&this.currentComponentId){this.validationErrorElement.innerHTML=a;
OpenLayers.Element.show(this.validationErrorContainer)
}},componentActivated:function(c){var d=c.component;
this.currentComponentId=d.id;
for(var b=0;
b<this.components.length;
b++){var a=this.components[b];
if(!(WPS.Component.STATUS_INACTIVE===a.status||WPS.Component.STATUS_INACTIVE_HOVER===a.status||d.id===a.id)){a.deactivate()
}}if(d.CLASS_NAME==="WPS.Component.Point"||d.CLASS_NAME==="WPS.Component.MultiPoint"||d.CLASS_NAME==="WPS.Component.LineString"||d.CLASS_NAME==="WPS.Component.MultiLineString"||d.CLASS_NAME==="WPS.Component.Polygon"||d.CLASS_NAME==="WPS.Component.MultiPolygon"){this.events.triggerEvent("geoInputActivation",{component:this})
}},componentDeactivated:function(a){var b=a.component;
if(this.activated&&b.id===this.currentComponentId){this.currentComponentId=null
}},componentValidityChanged:function(a){this.validate()
},destroy:function(){this.deactivate();
for(var b=0;
b<this.processModel.models.length;
b++){var a=this.components[b];
a.events.un({activate:this.componentActivated,deactivate:this.componentDeactivated,validitychange:this.componentValidityChanged,scope:this});
a.destroy()
}this.components=[];
this.componentsElement.innerHTML="";
this.componentsElement=null;
if(Legato.Lang.ObjectUtils.exists(this.events)){this.events.destroy();
this.events=null
}this.executeCallback=null;
this.cancelCallback=null
},CLASS_NAME:"WPS.Component.Process"});
WPS.I18n=Legato.I18n;
WPS.I18n.Messages.dictionaries.de["WPS.AbstractGeometry.Select"]="Zur Auswahl von Geometrien. Bitte vorher das gew\u00fcnschte Thema markieren.";
WPS.I18n.Messages.dictionaries.de["WPS.AbstractGeometry.InvalidSelectionGeometryType"]="Ihre Selektion war vom Typ [${invalidGeometryType}]. Sie d\u00fcrfen allerdings nur eine Geometrie des Typs [${validGeometryType}] erfassen.";
WPS.I18n.Messages.dictionaries.de["WPS.Point.Draw"]="Zeichnet einen Punkt.";
WPS.I18n.Messages.dictionaries.de["WPS.Point.Edit"]="\u00c4ndert den Punkt.";
WPS.I18n.Messages.dictionaries.de["WPS.MultiPoint.Draw"]="Zeichnet einen Multi-Punkt.";
WPS.I18n.Messages.dictionaries.de["WPS.MultiPoint.Edit"]="\u00c4ndert den Multi-Punkt.";
WPS.I18n.Messages.dictionaries.de["WPS.LineString.Draw"]="Zeichnet einen Linienzug.";
WPS.I18n.Messages.dictionaries.de["WPS.LineString.Edit"]="\u00c4ndert den Linienzug.";
WPS.I18n.Messages.dictionaries.de["WPS.MultiLineString.Draw"]="Zeichnet einen Multi-Linienzug.";
WPS.I18n.Messages.dictionaries.de["WPS.MultiLineString.Edit"]="\u00c4ndert den Multi-Linienzug.";
WPS.I18n.Messages.dictionaries.de["WPS.Polygon.Draw"]="Zeichnet ein Polygon.";
WPS.I18n.Messages.dictionaries.de["WPS.Polygon.Edit"]="\u00c4ndert das Polygon.";
WPS.I18n.Messages.dictionaries.de["WPS.MultiPolygon.Draw"]="Zeichnet ein Multi-Polygon.";
WPS.I18n.Messages.dictionaries.de["WPS.MultiPolygon.Edit"]="\u00c4ndert das Multi-Polygon.";
WPS.I18n.Messages.dictionaries.de["WPS.ProcessSelector.Title"]="Auswahl";
WPS.I18n.Messages.dictionaries.de["WPS.ProcessSelector.Description"]="Web Processing Services (WPS) erweitern den Funktionsumfang von GISterm durch zentral bereitgestellte Dienste. Bitte w\u00E4hlen Sie einen WPS-Dienst aus.";
WPS.I18n.Messages.dictionaries.de["WPS.Model.MustFill"]="${title} muss ausgef\u00fcllt werden.";
WPS.I18n.Messages.dictionaries.de["WPS.Result.ExecutionContext.ResultLayerName"]="aktuelle Geometrie";
WPS.I18n.Messages.dictionaries.de["WPS.Result.ExecutionContext.MarkerLayerName"]="aktuelle Markierung";
WPS.I18n.Messages.dictionaries.en["WPS.AbstractGeometry.Select"]="Select the geometry. Please select the layer before selecting the geometry.";
WPS.I18n.Messages.dictionaries.en["WPS.AbstractGeometry.InvalidSelectionGeometryType"]="Your selection has the type [${invalidGeometryType}]. Expected is [${validGeometryType}].";
WPS.I18n.Messages.dictionaries.en["WPS.Point.Draw"]="Draws a point.";
WPS.I18n.Messages.dictionaries.en["WPS.Point.Edit"]="Edits the point.";
WPS.I18n.Messages.dictionaries.en["WPS.MultiPoint.Draw"]="Draws a multi point.";
WPS.I18n.Messages.dictionaries.en["WPS.MultiPoint.Edit"]="Edits the multi point.";
WPS.I18n.Messages.dictionaries.en["WPS.LineString.Draw"]="Draws a line string.";
WPS.I18n.Messages.dictionaries.en["WPS.LineString.Edit"]="Edits the line string.";
WPS.I18n.Messages.dictionaries.en["WPS.MultiLineString.Draw"]="Draws a multi line string.";
WPS.I18n.Messages.dictionaries.en["WPS.MultiLineString.Edit"]="Edits the multi line string.";
WPS.I18n.Messages.dictionaries.en["WPS.Polygon.Draw"]="Draws a polygon.";
WPS.I18n.Messages.dictionaries.en["WPS.Polygon.Edit"]="Edits the polygon.";
WPS.I18n.Messages.dictionaries.en["WPS.MultiPolygon.Draw"]="Draws a multi polygon.";
WPS.I18n.Messages.dictionaries.en["WPS.MultiPolygon.Edit"]="Edits the multi polygon.";
WPS.I18n.Messages.dictionaries.en["WPS.ProcessSelector.Title"]="Process Selection";
WPS.I18n.Messages.dictionaries.en["WPS.ProcessSelector.Description"]="Web Processing Services (WPS) extend the functionality of GISterm with services provided centrally. Please choose a WPS service.";
WPS.I18n.Messages.dictionaries.en["WPS.Model.MustFill"]="${title} must be filled.";
WPS.I18n.Messages.dictionaries.de["WPS.Result.ExecutionContext.ResultLayerName"]="Current geomtry";
WPS.I18n.Messages.dictionaries.de["WPS.Result.ExecutionContext.MarkerLayerName"]="Current marker";
WPS.Result.ExecutionContext=OpenLayers.Class({map:null,featureLayer:null,markersLayer:null,initialize:function(a){this.map=a;
Legato.Util.Ensure.ensureExists(a,"Execution context must be defined with a map parameter.")
},getOrCreateFeatureLayer:function(){if(!Legato.Lang.ObjectUtils.exists(this.featureLayer)){this.featureLayer=this.createFeatureLayer()
}return this.featureLayer
},createFeatureLayer:function(){var b={isFeatureLayer:true,legatoIgnore:true,calculateInRange:function(){return true
}};
var a=new OpenLayers.Layer.Vector(WPS.I18n.getMessage("WPS.Result.ExecutionContext.ResultLayerName"),b);
a.style=WPS.Feature.Style.ACTIVE;
this.map.addLayer(a);
return a
},getOrCreateMarkersLayer:function(){if(!Legato.Lang.ObjectUtils.exists(this.markersLayer)){this.markersLayer=this.createMarkersLayer()
}return this.markersLayer
},createMarkersLayer:function(){var b={isMarkersLayer:true};
var a=new OpenLayers.Layer.Markers(WPS.I18n.getMessage("WPS.Result.ExecutionContext.MarkerLayerName"),b);
this.map.addLayer(a);
return a
},destroy:function(){this.map=null
},CLASS_NAME:"WPS.Result.ExecutionContext"});
WPS.Result.Geometry=OpenLayers.Class(WPS.Result,{map:null,layer:null,initialize:function(c,b,a){WPS.Result.prototype.initialize.apply(this,[c,a]);
this.map=b
},execute:function(c){var b=c.getOrCreateFeatureLayer();
var a=this.createFeature();
b.addFeatures([a])
},createFeature:function(){var c=new OpenLayers.Format.GeoJSON();
var a=this.createResultGeometry();
var b=new OpenLayers.Feature.Vector(c.read(a,"Geometry"));
b.style=this.createGeometryStyle();
return b
},createGeometryStyle:function(){return WPS.Feature.Style.ACTIVE
},createResultGeometry:function(){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the createResultGeometry function from from abstract class "+WPS.Result.Geometry.CLASS_NAME)
},destroy:function(){this.map=null;
this.layer=null;
WPS.Result.prototype.destroy.apply(this,arguments)
},CLASS_NAME:"WPS.Result.Geometry"});
WPS.Result.Geometry.ComplexFactory=OpenLayers.Class(WPS.Result.ComplexFactory,{schema:"http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#Geometry",name:new Legato.XML.QName("http://www.opengis.net/gml","Geometry","gml"),createResult:function(g,a,c){var b=a.data.complexData;
var e=b.content[0].value;
var d=e.type;
var f=e.coordinates;
switch(d){case"Polygon":return new WPS.Result.Polygon(g,this.map,f,c);
case"LineString":return new WPS.Result.LineString(g,this.map,f,c);
case"Point":return new WPS.Result.Point(g,this.map,f,c);
case"MultiPolygon":return new WPS.Result.MultiPolygon(g,this.map,f,c);
case"MultiLineString":return new WPS.Result.MultiLineString(g,this.map,f,c);
case"MultiPoint":return new WPS.Result.MultiPoint(g,this.map,f,c)
}},CLASS_NAME:"WPS.Result.Geometry.ComplexFactory"});
WPS.Result.Factory=OpenLayers.Class({literalFactory:null,boundingBoxFactory:null,exceptionReportFactory:null,complexFactories:null,initialize:function(b,a){Legato.Util.Ensure.ensureExists(b,"map must be defined");
this.literalFactory=new WPS.Result.Message.LiteralFactory(b);
this.boundingBoxFactory=new WPS.Result.BoundingBox.BoundingBoxFactory(b);
this.exceptionReportFactory=new WPS.Result.ExceptionReport.ExceptionReportFactory(b);
this.complexFactories=[new WPS.Result.Link.ComplexFactory(b),new WPS.Result.Message.ComplexFactory(b),new WPSPD.Result.Geometry.ComplexFactory(b),new WPSPD.Result.Marker.ComplexFactory(b,this),new WPS.Result.Group.ComplexFactory(b,this),new WPS.Result.Point.ComplexFactory(b),new WPS.Result.LineString.ComplexFactory(b),new WPS.Result.Polygon.ComplexFactory(b),new WPS.Result.MultiPoint.ComplexFactory(b),new WPS.Result.MultiLineString.ComplexFactory(b),new WPS.Result.MultiPolygon.ComplexFactory(b),new WPS.Result.Geometry.ComplexFactory(b)];
if(Legato.Lang.ObjectUtils.isObject(a)){this.complexFactories.push(new WPS.Result.ProcessDescription.ComplexFactory(b,a))
}},createResult:function(e,d,c){if(Legato.Lang.ObjectUtils.exists(e.processOutputs)){if(Legato.Lang.ObjectUtils.exists(e.status)&&Legato.Lang.ObjectUtils.exists(e.status.processFailed)){if(Legato.Lang.ObjectUtils.exists(e.status.processFailed.exceptionReport)){return this.createExceptionReportResult(e.status.processFailed.exceptionReport,d,c)
}else{var b={exception:[{exceptionText:["Der Prozess schlug fehl, es wurde aber keine Fehlermeldung zurückgegeben"],exceptionCode:"NoExceptionReport"}]};
return this.createExceptionReportResult(b,d,c)
}}else{var a=e.processOutputs.output[0];
return this.createSingleNormalResult(a,d,c)
}}else{if(Legato.Lang.ObjectUtils.exists(e.exception)){return this.createExceptionReportResult(e,d,c)
}else{throw new Legato.Lang.Exception("Unknown executeResponse")
}}},createSingleNormalResult:function(b,g,d){var a=OpenLayers.Util.createUniqueID("WPS_Result_");
var f={};
if(Legato.Lang.ObjectUtils.isFunction(g)){f.popupCallback=g
}if(Legato.Lang.ObjectUtils.isFunction(d)){f.errorCallback=d
}if(Legato.Lang.ObjectUtils.exists(b.title)&&Legato.Lang.ObjectUtils.isString(b.title.value)){f.title=b.title.value
}if(Legato.Lang.ObjectUtils.exists(b["abstract"])&&Legato.Lang.ObjectUtils.isString(b["abstract"].value)){f.description=b["abstract"].value
}if(Legato.Lang.ObjectUtils.exists(b.data.literalData)){return this.literalFactory.createResult(a,b,f)
}else{if(Legato.Lang.ObjectUtils.exists(b.data.boundingBoxData)){return this.boundingBoxFactory.createResult(a,b,f)
}else{if(Legato.Lang.ObjectUtils.exists(b.data.complexData)){for(var e=0;
e<this.complexFactories.length;
e++){var c=this.complexFactories[e];
if(c.schema===b.data.complexData.schema){return c.createResult(a,b,f)
}}throw new Legato.Lang.Exception("Unsupported complex data: "+b.data.complexData.schema)
}else{throw new Legato.Lang.Exception("Unsupported output data.")
}}}},createExceptionReportResult:function(d,e,b){var a=OpenLayers.Util.createUniqueID("WPS_ExceptionReport_");
var c={};
if(Legato.Lang.ObjectUtils.isFunction(e)){c.popupCallback=e
}if(Legato.Lang.ObjectUtils.isFunction(b)){c.errorCallback=b
}return this.exceptionReportFactory.createResult(a,d,c)
},destroy:function(){},CLASS_NAME:"WPS.Result.Factory"});
WPS.Result.Link=OpenLayers.Class(WPS.Result,{href:null,show:null,actuate:null,contentType:null,initialize:function(c,a,b){WPS.Result.prototype.initialize.apply(this,[c,b]);
Legato.Util.Ensure.ensureString(a,"href should be defined");
this.href=a
},destroy:function(){this.href=null;
this.show=null;
this.actuate=null;
this.contentType=null;
WPS.Result.prototype.destroy.apply(this,arguments)
},createContent:function(){if(this.show==="embed"){if(Legato.Lang.ObjectUtils.exists(this.contentType)&&(this.contentType.substring(0,6)==="image/")){var c=document.createElement("img");
c.id=this.id;
c.src=this.href;
c.title=this.title;
return c
}else{var d=document.createElement("iframe");
d.id=this.id;
d.src=this.href;
d.title=this.title;
return d
}}else{var b=document.createElement("a");
b.id=this.id;
b.href=this.href;
b.innerHTML=Legato.Lang.ObjectUtils.exists(this.title)?this.title:this.href;
b.target=this.show==="new"?"_blank":"_self";
return b
}},execute:function(){this.navigateToLocation(this.href)
},navigateToLocation:function(a){if(this.show==="new"){window.open(a)
}else{if(this.show==="replace"){window.location=a
}else{window.open(a)
}}},CLASS_NAME:"WPS.Result.Link"});
WPS.Result.Link.ComplexFactory=OpenLayers.Class(WPS.Result.ComplexFactory,{schema:"http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Link",name:new Legato.XML.QName("http://www.disy.net/pd","Link","pd"),createResult:function(f,a,d){var c=a.data.complexData;
var e=c.content[0].value;
var b=e.href;
d.show=e.show;
d.actuate=e.actuate;
d.contentType=e.contentType;
return new WPS.Result.Link(f,b,d)
},CLASS_NAME:"WPS.Result.Link.ComplexFactory"});
WPS.Result.Message=OpenLayers.Class(WPS.Result,{message:null,format:null,initialize:function(e,d,c,b,a){WPS.Result.prototype.initialize.apply(this,[e,a]);
Legato.Util.Ensure.ensureExists(b,"message should be defined");
this.message=b;
this.title=d;
this.description=c;
this.format=new OpenLayers.Format.XML()
},execute:function(c){var b=this.createContent();
if(!Legato.Lang.ObjectUtils.isFunction(this.popupCallback)){var a;
if(Legato.Lang.ObjectUtils.isString(b)){a=b
}else{if(Legato.Lang.ObjectUtils.exists(b.outerHTML)){a=b.outerHTML
}else{a=this.format.write(b)
}}alert(a);
return
}else{if(Legato.Lang.ObjectUtils.exists(this.type)&&this.type==="error"){this.errorCallback(b)
}else{this.popupCallback(b)
}}},createContent:function(){var b=this.createResultContainer();
var a=document.createElement("div");
a.className="wpsResult";
b.appendChild(a);
if(Legato.Lang.ObjectUtils.isString(this.message)){a.innerHTML=this.message
}else{if(Legato.Lang.ObjectUtils.exists(this.message.nodeType)){var f;
if(this.message.nodeType==9){f=this.message.documentElement
}var d=f.childNodes;
var e=d.length;
var h="";
for(var c=0;
c<e;
c++){var g=d[c];
h=h+this.format.write(g)
}a.innerHTML=h
}}return b
},createResultContainer:function(){var a=document.createElement("div");
if(Legato.Lang.ObjectUtils.exists(this.id)){a.id=this.id
}if(Legato.Lang.ObjectUtils.exists(this.title)){var c=document.createElement("div");
c.className="wpsResultTitle";
c.innerHTML=this.title;
a.appendChild(c)
}if(Legato.Lang.ObjectUtils.exists(this.description)){var b=document.createElement("div");
b.className="wpsResultAbstract";
b.innerHTML=this.description;
a.appendChild(b)
}return a
},destroy:function(){this.format.destroy();
this.format=null;
this.message=null;
WPS.Result.prototype.destroy.apply(this,arguments)
},CLASS_NAME:"WPS.Result.Message"});
WPS.Result.Message.LiteralFactory=OpenLayers.Class(WPS.Result.SimpleFactory,{createResult:function(g,a,b){var f=a.title.value;
var e=a["abstract"];
var d=e.value;
var c=a.data.literalData.value;
return new WPS.Result.Message(g,f,d,c,b)
},CLASS_NAME:"WPS.Result.Message.LiteralFactory"});
WPS.Result.Message.ComplexFactory=OpenLayers.Class(WPS.Result.ComplexFactory,{schema:"http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Message",name:new Legato.XML.QName("http://www.disy.net/pd","Message","pd"),createResult:function(h,a,c){var g=a.title.value;
var f=a["abstract"];
var d=f.value;
var b=a.data.complexData;
var e=b.content[0].value;
if(Legato.Lang.ObjectUtils.exists(e.type)&&Legato.Lang.ObjectUtils.isString(e.type)){c.type=e.type
}else{c.type="none"
}return new WPS.Result.Message(h,g,d,e.content,c)
},CLASS_NAME:"WPS.Result.Message.ComplexFactory"});
WPS.Result.BoundingBox=OpenLayers.Class(WPS.Result,{map:null,bounds:null,closest:true,initialize:function(d,c,b,a){WPS.Result.prototype.initialize.apply(this,[d,a]);
this.map=c;
this.bounds=b;
Legato.Util.Ensure.ensureExists(this.map,"map should be defined");
Legato.Util.Ensure.ensureExists(this.bounds,"bounds should be defined")
},zoomToExtent:function(a){if(!Legato.Lang.ObjectUtils.isObject(this.map)||!Legato.Lang.ObjectUtils.isFunction(this.map.zoomToExtent)){throw new Legato.Lang.Exception("Could not execute the result because given map seems to be invalid")
}this.map.zoomToExtent(a,this.closest)
},execute:function(){this.zoomToExtent(this.bounds);
return
},destroy:function(){this.map=null;
this.bounds=null;
this.closest=null;
WPS.Result.prototype.destroy.apply(this,arguments)
},CLASS_NAME:"WPS.Result.BoundingBox"});
WPS.Result.BoundingBox.BoundingBoxFactory=OpenLayers.Class(WPS.Result.SimpleFactory,{createResult:function(d,a,b){if(!Legato.Lang.ObjectUtils.isArray(a.data.boundingBoxData.lowerCorner)||!Legato.Lang.ObjectUtils.isArray(a.data.boundingBoxData.upperCorner)||a.data.boundingBoxData.lowerCorner.length!==2||a.data.boundingBoxData.upperCorner.length!==2){throw new Legato.Lang.Exception("outputData.data.boundingBoxData seems to be invalid")
}var c=new OpenLayers.Bounds(a.data.boundingBoxData.lowerCorner[0],a.data.boundingBoxData.lowerCorner[1],a.data.boundingBoxData.upperCorner[0],a.data.boundingBoxData.upperCorner[1]);
return new WPS.Result.BoundingBox(d,this.map,c,b)
},CLASS_NAME:"WPS.Result.BoundingBox.BoundingBoxFactory"});
WPS.Result.ExceptionReport=OpenLayers.Class(WPS.Result,{exceptionReport:null,initialize:function(c,b,a){Legato.Util.Ensure.ensureExists(b,"An exception report should be defined");
WPS.Result.prototype.initialize.apply(this,[c,a]);
this.exceptionReport=b
},showExceptionReport:function(a){alert(this.createExceptionMessage(a,"\r\n"))
},createExceptionMessage:function(b,a){var c="Beim Ausführen des Dienstes ist ein Fehler aufgetreten."+a;
c+="Fehler-Code: "+b.exception[0].exceptionCode+a;
c+="Fehlernachricht: ";
c+=b.exception[0].exceptionText.join(" ");
return c
},execute:function(){if(!Legato.Lang.ObjectUtils.isFunction(this.errorCallback)){this.showExceptionReport(this.exceptionReport);
return
}this.errorCallback(this.createContent())
},createContent:function(){var a=document.createElement("textarea");
a.setAttribute("readonly","true");
a.id=this.id;
OpenLayers.Element.addClass(a,"error");
a.innerHTML=this.createExceptionMessage(this.exceptionReport,"<br />");
return a
},destroy:function(){this.report=null;
WPS.Result.prototype.destroy.apply(this,arguments)
},CLASS_NAME:"WPS.Result.ExceptionReport"});
WPS.Result.ExceptionReport.ExceptionReportFactory=OpenLayers.Class(WPS.Result.SimpleFactory,{createResult:function(c,b,a){return new WPS.Result.ExceptionReport(c,b,a)
},CLASS_NAME:"WPS.Result.ExceptionReport.ExceptionReportFactory"});
WPS.Result.Point=OpenLayers.Class(WPS.Result.Geometry,{coordinates:null,initialize:function(d,b,c,a){WPS.Result.Geometry.prototype.initialize.apply(this,[d,b,a]);
Legato.Util.Ensure.ensureArray(c,"coordinates should be defined as array");
this.coordinates=c
},destroy:function(){this.coordinates=null;
WPS.Result.Geometry.prototype.destroy.apply(this,arguments)
},createResultGeometry:function(){var a={type:"Point",coordinates:[this.coordinates[0],this.coordinates[1]]};
return a
},CLASS_NAME:"WPS.Result.Point"});
WPS.Result.Point.ComplexFactory=OpenLayers.Class(WPS.Result.ComplexFactory,{schema:"http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#Point",name:new Legato.XML.QName("http://www.opengis.net/gml","Point","gml"),createResult:function(g,a,c){var b=a.data.complexData;
var e=b.content[0].value;
var d=e.type;
var f=e.coordinates;
return new WPS.Result.Point(g,this.map,f,c)
},CLASS_NAME:"WPS.Result.Point.ComplexFactory"});
WPS.Result.LineString=OpenLayers.Class(WPS.Result.Geometry,{coordinates:null,initialize:function(d,b,c,a){WPS.Result.Geometry.prototype.initialize.apply(this,[d,b,a]);
Legato.Util.Ensure.ensureArray(c,"coordinates should be defined as array");
this.coordinates=c
},destroy:function(){this.coordinates=null;
WPS.Result.Geometry.prototype.destroy.apply(this,arguments)
},createResultGeometry:function(){var a={type:"LineString",coordinates:this.coordinates};
return a
},CLASS_NAME:"WPS.Result.LineString"});
WPS.Result.LineString.ComplexFactory=OpenLayers.Class(WPS.Result.ComplexFactory,{schema:"http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#LineString",name:new Legato.XML.QName("http://www.opengis.net/gml","LineString","gml"),createResult:function(g,a,c){var b=a.data.complexData;
var e=b.content[0].value;
var d=e.type;
var f=e.coordinates;
return new WPS.Result.LineString(g,this.map,f,c)
},CLASS_NAME:"WPS.Result.LineString.ComplexFactory"});
WPS.Result.Polygon=OpenLayers.Class(WPS.Result.Geometry,{coordinates:null,initialize:function(d,b,c,a){WPS.Result.Geometry.prototype.initialize.apply(this,[d,b,a]);
Legato.Util.Ensure.ensureArray(c,"coordinates should be defined as array");
this.coordinates=c
},destroy:function(){this.coordinates=null;
WPS.Result.Geometry.prototype.destroy.apply(this,arguments)
},createResultGeometry:function(){var a={type:"Polygon",coordinates:this.coordinates};
return a
},CLASS_NAME:"WPS.Result.Polygon"});
WPS.Result.Polygon.ComplexFactory=OpenLayers.Class(WPS.Result.ComplexFactory,{schema:"http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#Polygon",name:new Legato.XML.QName("http://www.opengis.net/gml","Polygon","gml"),createResult:function(g,a,c){var b=a.data.complexData;
var e=b.content[0].value;
var d=e.type;
var f=e.coordinates;
return new WPS.Result.Polygon(g,this.map,f,c)
},CLASS_NAME:"WPS.Result.Polygon.ComplexFactory"});
WPS.Result.MultiPoint=OpenLayers.Class(WPS.Result.Geometry,{coordinates:null,initialize:function(d,b,c,a){WPS.Result.Geometry.prototype.initialize.apply(this,[d,b,a]);
Legato.Util.Ensure.ensureArray(c,"coordinates should be defined as array");
this.coordinates=c
},destroy:function(){this.coordinates=null;
WPS.Result.Geometry.prototype.destroy.apply(this,arguments)
},createResultGeometry:function(){var a={type:"MultiPoint",coordinates:[this.coordinates[0],this.coordinates[1]]};
return a
},CLASS_NAME:"WPS.Result.MultiPoint"});
WPS.Result.MultiPoint.ComplexFactory=OpenLayers.Class(WPS.Result.ComplexFactory,{schema:"http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#MultiPoint",name:new Legato.XML.QName("http://www.opengis.net/gml","MultiPoint","gml"),createResult:function(g,a,c){var b=a.data.complexData;
var e=b.content[0].value;
var d=e.type;
var f=e.coordinates;
return new WPS.Result.MultiPoint(g,this.map,f,c)
},CLASS_NAME:"WPS.Result.MultiPoint.ComplexFactory"});
WPS.Result.MultiLineString=OpenLayers.Class(WPS.Result.Geometry,{coordinates:null,initialize:function(d,b,c,a){WPS.Result.Geometry.prototype.initialize.apply(this,[d,b,a]);
Legato.Util.Ensure.ensureArray(c,"coordinates should be defined as array");
this.coordinates=c
},destroy:function(){this.coordinates=null;
WPS.Result.Geometry.prototype.destroy.apply(this,arguments)
},createResultGeometry:function(){var a={type:"MultiLineString",coordinates:this.coordinates};
return a
},CLASS_NAME:"WPS.Result.MultiLineString"});
WPS.Result.MultiLineString.ComplexFactory=OpenLayers.Class(WPS.Result.ComplexFactory,{schema:"http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#MultiLineString",name:new Legato.XML.QName("http://www.opengis.net/gml","MultiLineString","gml"),createResult:function(g,a,c){var b=a.data.complexData;
var e=b.content[0].value;
var d=e.type;
var f=e.coordinates;
return new WPS.Result.MultiLineString(g,this.map,f,c)
},CLASS_NAME:"WPS.Result.MultiLineString.ComplexFactory"});
WPS.Result.MultiPolygon=OpenLayers.Class(WPS.Result.Geometry,{coordinates:null,initialize:function(d,b,c,a){WPS.Result.Geometry.prototype.initialize.apply(this,[d,b,a]);
Legato.Util.Ensure.ensureArray(c,"coordinates should be defined as array");
this.coordinates=c
},destroy:function(){this.coordinates=null;
WPS.Result.Geometry.prototype.destroy.apply(this,arguments)
},createResultGeometry:function(){var a={type:"MultiPolygon",coordinates:this.coordinates};
return a
},CLASS_NAME:"WPS.Result.MultiPolygon"});
WPS.Result.MultiPolygon.ComplexFactory=OpenLayers.Class(WPS.Result.ComplexFactory,{schema:"http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#MultiPolygon",name:new Legato.XML.QName("http://www.opengis.net/gml","MultiPolygon","gml"),createResult:function(g,a,c){var b=a.data.complexData;
var e=b.content[0].value;
var d=e.type;
var f=e.coordinates;
return new WPS.Result.MultiPolygon(g,this.map,f,c)
},CLASS_NAME:"WPS.Result.MultiPolygon.ComplexFactory"});
WPS.Result.Group=OpenLayers.Class(WPS.Result,{results:null,factory:null,initialize:function(c,b,a){WPS.Result.prototype.initialize.apply(this,[c,a]);
Legato.Util.Ensure.ensureExists(b,"results should be defined");
this.results=b
},execute:function(c){for(var b=0;
b<this.results.length;
b++){var a=this.results[b];
a.execute(c)
}},createContent:function(){throw new Legato.Lang.Exception("The method createContent is not supported by the class"+this.CLASS_NAME)
},destroy:function(){this.items=null;
WPS.Result.prototype.destroy.apply(this,arguments)
},CLASS_NAME:"WPS.Result.Group"});
WPS.Result.Group.ComplexFactory=OpenLayers.Class(WPS.Result.ComplexFactory,{schema:"http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Group",name:new Legato.XML.QName("http://www.disy.net/pd","Group","pd"),factory:null,initialize:function(b,a){Legato.Util.Ensure.ensureExists(b,"map should be defined");
Legato.Util.Ensure.ensureExists(a,"factory should be defined");
this.map=b;
this.factory=a
},createResult:function(a,g,j){var f=g.data.complexData;
var h=f.content[0].value;
var e;
if(Legato.Lang.ObjectUtils.isArray(h.presentationDirective)){e=h.presentationDirective
}else{e=[]
}var b=[];
for(var d=0;
d<e.length;
d++){var i=e[d];
var c={data:{complexData:{schema:"http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#"+i.name.localPart,mimeType:"text/xml",encoding:"utf-8",content:[i]}}};
b.push(this.factory.createSingleNormalResult(c,null,null))
}return new WPS.Result.Group(a,b,j)
},CLASS_NAME:"WPS.Result.Group.ComplexFactory"});
WPS.Result.ProcessDescription=OpenLayers.Class(WPS.Result,{form:null,processDescription:null,initialize:function(d,c,b,a){WPS.Result.prototype.initialize.apply(this,[d,a]);
Legato.Util.Ensure.ensureExists(c,"form should be defined");
Legato.Util.Ensure.ensureExists(b,"process description should be defined");
this.form=c;
this.processDescription=b
},execute:function(){this.form.activateProcessDescription(this.processDescription)
},createContent:function(){throw new Legato.Lang.Exception("Not supported.")
},destroy:function(){WPS.Result.prototype.destroy.apply(this,arguments);
this.form=null;
this.processDescription=null
},CLASS_NAME:"WPS.Result.ProcessDescription"});
WPS.Result.ProcessDescription.ComplexFactory=OpenLayers.Class(WPS.Result.ComplexFactory,{schema:"http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd#ProcessDescription",name:new Legato.XML.QName("http://www.opengis.net/wps/1.0.0","ProcessDescription","wps"),initialize:function(b,a){Legato.Util.Ensure.ensureExists(b,"map should be defined");
Legato.Util.Ensure.ensureExists(a,"form should be defined");
this.map=b;
this.form=a
},createResult:function(c,a,b){return new WPS.Result.ProcessDescription(c,this.form,a.data.complexData.content[0].value,b)
},destroy:function(){WPS.Result.ComplexFactory.prototype.destroy.apply(this,arguments);
this.form=null
},CLASS_NAME:"WPS.Result.ProcessDescription.ComplexFactory"});
WPSPD.Result.Geometry=OpenLayers.Class(WPS.Result.Geometry,{symbolizer:null,initialize:function(d,c,b,a){WPS.Result.Geometry.prototype.initialize.apply(this,[d,c,a]);
this.symbolizer=b
},createGeometryStyle:function(){var a=OpenLayers.Util.extend({},WPS.Feature.Style.ACTIVE);
if(Legato.Lang.ObjectUtils.exists(this.symbolizer)){this.configureStyle(a)
}return a
},configureStyle:function(a){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the configureStyle function from from abstract class "+WPSPD.Result.Geometry.CLASS_NAME)
},evaluateStyleConfiguration:function(a,d){var c={stroke:"strokeColor","stroke-width":"strokeWidth",fill:"fillColor"};
if(Legato.Lang.ObjectUtils.exists(a.svgParameter)){for(index=0;
index<a.svgParameter.length;
index++){var b=a.svgParameter[index];
if(Legato.Lang.ObjectUtils.exists(c[b.name])){d[c[b.name]]=b.content[0]
}}}},destroy:function(){this.symbolizer=null;
WPS.Result.Geometry.prototype.destroy.apply(this,arguments)
},CLASS_NAME:"WPSPD.Result.Geometry"});
WPSPD.Result.Geometry.ComplexFactory=OpenLayers.Class(WPS.Result.ComplexFactory,{schema:"http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Geometry",name:new Legato.XML.QName("http://www.disy.net/pd","Geometry","pd"),createResult:function(a,e,i){var d=e.data.complexData;
var g=d.content[0].value;
var b=g.geometry.value;
var h;
if(Legato.Lang.ObjectUtils.exists(g.symbolizer)&&Legato.Lang.ObjectUtils.exists(g.symbolizer.value)){h=g.symbolizer.value
}else{h=null
}var c=b.type;
var f=b.coordinates;
switch(c){case"Polygon":return new WPSPD.Result.Polygon(a,this.map,f,h,i);
case"LineString":return new WPSPD.Result.LineString(a,this.map,f,h,i);
case"Point":return new WPSPD.Result.Point(a,this.map,f,h,i);
case"MultiPolygon":return new WPSPD.Result.MultiPolygon(a,this.map,f,h,i);
case"MultiLineString":return new WPSPD.Result.MultiLineString(a,this.map,f,h,i);
case"MultiPoint":return new WPSPD.Result.MultiPoint(a,this.map,f,h,i)
}},CLASS_NAME:"WPSPD.Result.Geometry.ComplexFactory"});
WPSPD.Result.Point=OpenLayers.Class(WPSPD.Result.Geometry,{point:null,initialize:function(e,c,d,b,a){WPSPD.Result.Geometry.prototype.initialize.apply(this,[e,c,b,a]);
point=new WPS.Result.Point(e,c,d,a)
},destroy:function(){this.point=null;
WPSPD.Result.Geometry.prototype.destroy.apply(this,arguments)
},createResultGeometry:function(){return point.createResultGeometry()
},configureStyle:function(c){if(Legato.Lang.ObjectUtils.exists(this.symbolizer.graphic)&&Legato.Lang.ObjectUtils.exists(this.symbolizer.graphic.externalGraphicOrMark)){var a=this.symbolizer.graphic.externalGraphicOrMark;
for(index=0;
index<a.length;
index++){var b=a[index];
if(Legato.Lang.ObjectUtils.exists(b.stroke)){this.evaluateStyleConfiguration(b.stroke,c)
}if(Legato.Lang.ObjectUtils.exists(b.fill)){this.evaluateStyleConfiguration(b.fill,c)
}}}},CLASS_NAME:"WPSPD.Result.Point"});
WPSPD.Result.LineString=OpenLayers.Class(WPSPD.Result.Geometry,{lineString:null,initialize:function(e,c,d,b,a){WPSPD.Result.Geometry.prototype.initialize.apply(this,[e,c,b,a]);
lineString=new WPS.Result.LineString(e,c,d,a)
},destroy:function(){this.lineString=null;
WPSPD.Result.Geometry.prototype.destroy.apply(this,arguments)
},createResultGeometry:function(){return lineString.createResultGeometry()
},configureStyle:function(a){if(Legato.Lang.ObjectUtils.exists(this.symbolizer.stroke)){this.evaluateStyleConfiguration(this.symbolizer.stroke,a)
}},CLASS_NAME:"WPSPD.Result.LineString"});
WPSPD.Result.Polygon=OpenLayers.Class(WPSPD.Result.Geometry,{polygon:null,initialize:function(e,c,d,b,a){WPSPD.Result.Geometry.prototype.initialize.apply(this,[e,c,b,a]);
polygon=new WPS.Result.Polygon(e,c,d,a)
},destroy:function(){this.polygon=null;
WPSPD.Result.Geometry.prototype.destroy.apply(this,arguments)
},createResultGeometry:function(){return polygon.createResultGeometry()
},configureStyle:function(a){if(Legato.Lang.ObjectUtils.exists(this.symbolizer.stroke)){this.evaluateStyleConfiguration(this.symbolizer.stroke,a)
}if(Legato.Lang.ObjectUtils.exists(this.symbolizer.fill)){this.evaluateStyleConfiguration(this.symbolizer.fill,a)
}},CLASS_NAME:"WPSPD.Result.Polygon"});
WPSPD.Result.MultiPoint=OpenLayers.Class(WPSPD.Result.Geometry,{multiPoint:null,initialize:function(e,c,d,b,a){WPSPD.Result.Geometry.prototype.initialize.apply(this,[e,c,b,a]);
multiPoint=new WPS.Result.MultiPoint(e,c,d,a)
},destroy:function(){this.multiPoint=null;
WPSPD.Result.Geometry.prototype.destroy.apply(this,arguments)
},createResultGeometry:function(){return multiPoint.createResultGeometry()
},configureStyle:function(c){if(Legato.Lang.ObjectUtils.exists(this.symbolizer.graphic)&&Legato.Lang.ObjectUtils.exists(this.symbolizer.graphic.externalGraphicOrMark)){var a=this.symbolizer.graphic.externalGraphicOrMark;
for(index=0;
index<a.length;
index++){var b=a[index];
if(Legato.Lang.ObjectUtils.exists(b.stroke)){this.evaluateStyleConfiguration(b.stroke,c)
}if(Legato.Lang.ObjectUtils.exists(b.fill)){this.evaluateStyleConfiguration(b.fill,c)
}}}},CLASS_NAME:"WPSPD.Result.MultiPoint"});
WPSPD.Result.MultiLineString=OpenLayers.Class(WPSPD.Result.Geometry,{multiLineString:null,initialize:function(e,c,d,b,a){WPSPD.Result.Geometry.prototype.initialize.apply(this,[e,c,b,a]);
multiLineString=new WPS.Result.MultiLineString(e,c,d,a)
},destroy:function(){this.multiLineString=null;
WPSPD.Result.Geometry.prototype.destroy.apply(this,arguments)
},createResultGeometry:function(){return multiLineString.createResultGeometry()
},configureStyle:function(a){if(Legato.Lang.ObjectUtils.exists(this.symbolizer.stroke)){this.evaluateStyleConfiguration(this.symbolizer.stroke,a)
}},CLASS_NAME:"WPSPD.Result.MultiLineString"});
WPSPD.Result.MultiPolygon=OpenLayers.Class(WPSPD.Result.Geometry,{multiPolygon:null,initialize:function(e,c,d,b,a){WPSPD.Result.Geometry.prototype.initialize.apply(this,[e,c,b,a]);
multiPolygon=new WPS.Result.MultiPolygon(e,c,d,a)
},destroy:function(){this.multiPolygon=null;
WPSPD.Result.Geometry.prototype.destroy.apply(this,arguments)
},createResultGeometry:function(){return multiPolygon.createResultGeometry()
},configureStyle:function(a){if(Legato.Lang.ObjectUtils.exists(this.symbolizer.stroke)){this.evaluateStyleConfiguration(this.symbolizer.stroke,a)
}if(Legato.Lang.ObjectUtils.exists(this.symbolizer.fill)){this.evaluateStyleConfiguration(this.symbolizer.fill,a)
}},CLASS_NAME:"WPSPD.Result.MultiPolygon"});
WPSPD.Result.Marker=OpenLayers.Class(WPS.Result,{map:null,factory:null,marker:null,initialize:function(e,d,b,a,c){WPS.Result.prototype.initialize.apply(this,[e,c]);
Legato.Util.Ensure.ensureExists(d,"map should be defined");
Legato.Util.Ensure.ensureExists(b,"factory should be defined");
Legato.Util.Ensure.ensureExists(a,"marker should be defined");
this.map=d;
this.factory=b;
this.marker=a
},execute:function(a){this.createAndAddMarkerFeature(a)
},createAndAddMarkerFeature:function(l){var p;
if(Legato.Lang.ObjectUtils.exists(this.marker.geometry)){var k={data:{complexData:{schema:"http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Geometry",mimeType:"text/xml",encoding:"utf-8",content:[this.marker.geometry]}}};
var m=this.factory.createSingleNormalResult(k,null,null);
p=m.createFeature()
}else{if(Legato.Lang.ObjectUtils.exists(this.marker.position)&&Legato.Lang.ObjectUtils.isArray(this.marker.position.value)&&(this.marker.position.value.length)>=2&&Legato.Lang.ObjectUtils.isNumber(this.marker.position.value[0])&&Legato.Lang.ObjectUtils.isNumber(this.marker.position.value[1])){p=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(this.marker.position.value[0],this.marker.position.value[1]))
}else{throw new Legato.Lang.Exception("Marker contains neither geometry nor position.")
}}l.getOrCreateFeatureLayer().addFeatures([p]);
var j=p.geometry;
if(Legato.Lang.ObjectUtils.exists(this.marker.message)){var i={data:{complexData:{schema:"http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Message",mimeType:"text/xml",encoding:"utf-8",content:[this.marker.message]}}};
var e=this.factory.createSingleNormalResult(i,null,null);
var g=e.createContent();
var d=Legato.Lang.ObjectUtils.isString(g)?g:g.innerHTML;
var c=(j.CLASS_NAME==="OpenLayers.Geometry.MultiPoint"||j.CLASS_NAME==="OpenLayers.Geometry.MultiLineString"||j.CLASS_NAME==="OpenLayers.Geometry.MultiPolygon")?j.components:[j];
var o=function(q){this.popup.toggle();
OpenLayers.Event.stop(q)
};
for(var n=0;
n<c.length;
n++){var b=c[n].getCentroid();
var h=new OpenLayers.LonLat(b.x,b.y);
var a=new OpenLayers.Popup.FramedCloud(null,h,null,d,null,true,null);
a.panMapIfOutOfView=false;
a.closeOnMove=true;
a.autoSize=true;
a.hide();
var f=new Legato.Marker.PopupMarker(h,OpenLayers.Marker.defaultIcon(),a);
f.events.register("click",f,o);
l.getOrCreateMarkersLayer().addMarker(f)
}}return p
},destroy:function(){this.marker=null;
WPS.Result.prototype.destroy.apply(this,arguments)
},CLASS_NAME:"WPSPD.Result.Marker"});
WPSPD.Result.Marker.ComplexFactory=OpenLayers.Class(WPS.Result.ComplexFactory,{schema:"http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Marker",name:new Legato.XML.QName("http://www.disy.net/pd","Marker","pd"),map:null,factory:null,initialize:function(b,a){Legato.Util.Ensure.ensureExists(b,"map should be defined");
Legato.Util.Ensure.ensureExists(a,"factory should be defined");
this.map=b;
this.factory=a
},createResult:function(e,a,c){var b=a.data.complexData;
var d=b.content[0].value;
return new WPSPD.Result.Marker(e,this.map,this.factory,d,c)
},CLASS_NAME:"WPSPD.Result.Marker.ComplexFactory"});
