/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPSPD.Result.LineString = OpenLayers.Class(WPSPD.Result.Geometry, {
  lineString : null, 
  
  initialize : function(id, map, coordinates, symbolizer, options) {
    WPSPD.Result.Geometry.prototype.initialize.apply(this, [ id, map, symbolizer, options ]);
    lineString = new WPS.Result.LineString(id, map, coordinates, options);
  },

  destroy : function() {
    this.lineString = null;
    WPSPD.Result.Geometry.prototype.destroy.apply(this, arguments);
  },

  createResultGeometry : function() {
    return lineString.createResultGeometry();
  },
  
  configureStyle : function(style) {
    if (Legato.Lang.ObjectUtils.exists(this.symbolizer.stroke)) {
      this.evaluateStyleConfiguration(this.symbolizer.stroke, style);
    }
  },

  CLASS_NAME : 'WPSPD.Result.LineString'
    
});