/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result = OpenLayers.Class({

  id :null,

  title :null,

  description :null,

  popupCallback: null,

  errorCallback: null,

  initialize : function(id, options) {
    Legato.Util.Ensure.ensureExists(id, 'id should be defined');
    this.id = id;
    OpenLayers.Util.extend(this, options);

    if (!Legato.Lang.ObjectUtils.isString(this.title)) {
      this.title = this.createDefaultTitle();
    }
    if (!Legato.Lang.ObjectUtils.isString(this.description)) {
      this.description = this.createDefaultDescription();
    }
  },

  createDefaultTitle : function() {
    return null;
  },

  createDefaultDescription : function() {
    return null;
  },

  destroy : function() {
    this.id = null;
    this.title = null;
    this.description = null;
  },

  execute : function() {
  },

  createContent : function() {
    var content = document.createElement('div');
    return content;
  },

  CLASS_NAME :'WPS.Result'
});

WPS.Result.SimpleFactory = OpenLayers.Class({

  map: null,

  initialize : function(map) {
    this.map = map;
  },

  destroy : function() {
    this.map = null;
  },

  createResult: function(id, outputData, options)
  {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
        ' must implement the createResult function from from abstract class ' +
        WPS.Result.SimpleFactory.CLASS_NAME);
  },

  CLASS_NAME :'WPS.Result.SimpleFactory'
});

WPS.Result.ComplexFactory = OpenLayers.Class({

  schema: null,

  elementName: null,

  map: null,

  initialize : function(map) {
    this.map = map;
  },

  destroy : function() {
    this.schema = null;
    this.elementName = null;
    this.map = null;
  },

  createResult: function(id, outputData, options)
  {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
        ' must implement the createResult function from from abstract class ' +
        WPS.Result.ComplexFactory.CLASS_NAME);
  },

  CLASS_NAME :'WPS.Result.ComplexFactory'
});
