/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Factory = OpenLayers.Class({

  literalFactory: null,

  boundingBoxFactory: null,

  exceptionReportFactory: null,

  complexFactories: null,

  initialize : function(map, form) {
    Legato.Util.Ensure.ensureExists(map, "map must be defined");
    this.literalFactory = new WPS.Result.Message.LiteralFactory(map);
    this.boundingBoxFactory = new WPS.Result.BoundingBox.BoundingBoxFactory(map);
    this.exceptionReportFactory = new WPS.Result.ExceptionReport.ExceptionReportFactory(map);
    this.complexFactories = [
      // WPS-PD
      new WPS.Result.Link.ComplexFactory(map),
      new WPS.Result.Message.ComplexFactory(map),
      new WPSPD.Result.Geometry.ComplexFactory(map),
      new WPSPD.Result.Marker.ComplexFactory(map, this),
      new WPS.Result.Group.ComplexFactory(map, this),
      // GML
      new WPS.Result.Point.ComplexFactory(map),
      new WPS.Result.LineString.ComplexFactory(map),
      new WPS.Result.Polygon.ComplexFactory(map),
      new WPS.Result.MultiPoint.ComplexFactory(map),
      new WPS.Result.MultiLineString.ComplexFactory(map),
      new WPS.Result.MultiPolygon.ComplexFactory(map),
      new WPS.Result.Geometry.ComplexFactory(map)
    ];
    // WPS
    if (Legato.Lang.ObjectUtils.isObject(form)) {
      this.complexFactories.push (new WPS.Result.ProcessDescription.ComplexFactory(map, form));
    }
  },

  createResult : function(executeResponse, popupCallback, errorCallback) {
    if ( Legato.Lang.ObjectUtils.exists(executeResponse.processOutputs)) {
      if (Legato.Lang.ObjectUtils.exists(executeResponse.status) && Legato.Lang.ObjectUtils.exists(executeResponse.status.processFailed)) {
        if (Legato.Lang.ObjectUtils.exists(executeResponse.status.processFailed.exceptionReport))
        {
          return this.createExceptionReportResult(executeResponse.status.processFailed.exceptionReport, popupCallback, errorCallback);
        }
        else
        {
          var report = {
              exception : [
                  {
                      exceptionText : [
                        'Der Prozess schlug fehl, es wurde aber keine Fehlermeldung zurückgegeben'
                      ],
                      exceptionCode : 'NoExceptionReport'
                  }
              ]
          };
          return this.createExceptionReportResult(report, popupCallback, errorCallback);
        }
      }
      else {
        var outputData = executeResponse.processOutputs.output[0];
        return this.createSingleNormalResult(outputData, popupCallback, errorCallback);
      }
    } else if (Legato.Lang.ObjectUtils.exists(executeResponse.exception)) {
      return this.createExceptionReportResult(executeResponse, popupCallback, errorCallback);
    } else {
      throw new Legato.Lang.Exception("Unknown executeResponse");
    }
  },

  createSingleNormalResult : function(outputData, popupCallback, errorCallback) {
    var currentId = OpenLayers.Util.createUniqueID('WPS_Result_');

    /* Create options */
    var options = {};

    if(Legato.Lang.ObjectUtils.isFunction(popupCallback)){
      options.popupCallback = popupCallback;
    }

    if(Legato.Lang.ObjectUtils.isFunction(errorCallback)){
      options.errorCallback = errorCallback;
    }

    if (Legato.Lang.ObjectUtils.exists(outputData.title)
        && Legato.Lang.ObjectUtils.isString(outputData.title.value)) {
      options.title = outputData.title.value;
    }

    /*jslint sub:true */
    if (Legato.Lang.ObjectUtils.exists(outputData['abstract'])
        && Legato.Lang.ObjectUtils.isString(outputData['abstract'].value)) {
      /*jslint sub:true */
      options.description = outputData['abstract'].value;
    }
    // Literal output
    if (Legato.Lang.ObjectUtils.exists(outputData.data.literalData)) {
      return this.literalFactory.createResult(currentId, outputData,
          options);
    }
    // Bounding box output
    else if (Legato.Lang.ObjectUtils
        .exists(outputData.data.boundingBoxData)) {
      return this.boundingBoxFactory.createResult(currentId, outputData,
          options);
    }
    // Complex output
    else if (Legato.Lang.ObjectUtils.exists(outputData.data.complexData)) {
      for ( var factoryIndex = 0; factoryIndex < this.complexFactories.length; factoryIndex++) {
        var currentFactory = this.complexFactories[factoryIndex];
        if (currentFactory.schema === outputData.data.complexData.schema) {
          return currentFactory
              .createResult(currentId, outputData, options);
        }
      }
      // TODO: Implement further factories for complexData if needed
      throw new Legato.Lang.Exception('Unsupported complex data: ' + outputData.data.complexData.schema);
    } else {
      throw new Legato.Lang.Exception('Unsupported output data.');
    }
  },

  createExceptionReportResult : function(exceptionReport, popupCallback, errorCallback) {
    var currentId = OpenLayers.Util.createUniqueID('WPS_ExceptionReport_');
    /* Create options */
    var options = {};
    if(Legato.Lang.ObjectUtils.isFunction(popupCallback)){
      options.popupCallback = popupCallback;
    }

    if(Legato.Lang.ObjectUtils.isFunction(errorCallback)){
      options.errorCallback = errorCallback;
    }

    return this.exceptionReportFactory.createResult(currentId, exceptionReport,
          options);
  },

  destroy : function() {
  },

  CLASS_NAME :'WPS.Result.Factory'
});