/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component = OpenLayers.Class({
  EVENT_TYPES : [ 'activate', 'deactivate', 'validitychange' ],
  id : null,
  model : null,
  map : null,
  events : null,
  status : null,
  hidden : false,

  initialize : function(id, model, map, options) {
    Legato.Util.Ensure.ensureExists(id, 'Id must be defined.');
    Legato.Util.Ensure.ensureExists(model, 'Model must be defined.');
    Legato.Util.Ensure.ensureExists(map, 'Map must be defined.');
    OpenLayers.Util.extend(this, options);
    this.id = id;
    this.model = model;
    this.map = map;
    this.events = new OpenLayers.Events(this, null, this.EVENT_TYPES);

    this.model.events.on({
      'valuechange' : this.onModelValueChange,
      'validitychange' : this.onModelValidityChange,
      scope : this
    });

    this.initializeAdditionalElements(id, model, map, options);

    if (this.model.getValue() === null) {
      this.onDeactivation();
    } else {
      this.onActivation();
    }


    if (Legato.Lang.ObjectUtils.exists(this.model.getValue())) {
      this.onModelValueChange({
        value : this.model.getValue()
      });
    }

  },

  appendTo: function(componentsElement) {

  },

  initializeAdditionalElements : function(id, model, map, options) {

  },

  destroy : function() {

    this.container = null;

    if (Legato.Lang.ObjectUtils.exists(this.events)) {
      this.events.destroy();
      this.events = null;
    }

    this.model.events.un({
      'valuechange' : this.onModelValueChange,
      'validitychange' : this.onModelValidityChange,
      scope : this
    });
  },

  isActive : function() {
    return (WPS.Component.STATUS_ACTIVE_HOVER === this.status || WPS.Component.STATUS_ACTIVE === this.status);
  },

  isInactive : function() {
    return (WPS.Component.STATUS_INACTIVE_HOVER === this.status || WPS.Component.STATUS_INACTIVE === this.status);
  },

  hoverIn : function() {
    this.onHoverIn();
  },

  hoverOut : function() {
    this.onHoverOut();
  },

  checkedChanged : function(event) {
    var checked = (event.target || event.srcElement).checked;
    this.model.setChecked(checked);
  },


  onModelValueChange : function(event) {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
        ' must implement the onModelValueChange function from from abstract class ' +
        WPS.Component.CLASS_NAME);
  },

  onModelValidityChange : function(event) {
    this.events.triggerEvent('validitychange', {
      component : this
    });
  },

  activate : function() {
    this.onActivation();
  },

  isAccessable : function() {
    return false;
  },

  deactivate : function() {
    this.onDeactivation();
  },

  onHoverIn : function() {
    if (WPS.Component.STATUS_INACTIVE === this.status) {
      this.status = WPS.Component.STATUS_INACTIVE_HOVER;
    } else {
      this.status = WPS.Component.STATUS_ACTIVE_HOVER;
    }
  },

  onHoverOut : function(triggerEvent) {
    if (WPS.Component.STATUS_ACTIVE_HOVER === this.status) {
      this.status = WPS.Component.STATUS_ACTIVE;
    } else {
      this.status = WPS.Component.STATUS_INACTIVE;
    }
  },

  onActivation : function(triggerEvent) {
    this.status = WPS.Component.STATUS_ACTIVE_HOVER;
    if (triggerEvent) {
      this.events.triggerEvent('activate', {
        component : this
      });
    }
    this.model.setChecked(true);
  },

  onDeactivation : function(triggerEvent) {
    this.status = WPS.Component.STATUS_INACTIVE;
    if (triggerEvent) {
      this.events.triggerEvent('deactivate', {
        component : this
      });
    }
  },

  CLASS_NAME : 'WPS.Component'
});

WPS.Component.STATUS_ACTIVE_HOVER = 1;
WPS.Component.STATUS_ACTIVE = 2;
WPS.Component.STATUS_INACTIVE_HOVER = 3;
WPS.Component.STATUS_INACTIVE = 4;

