/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.ToolbarManager = OpenLayers.Class( {
  map :null,
  panel :null,
  form :null,
  wpsOperations :null,
  predicate :null,
  initialize : function(map, panel, options) {
    Legato.Util.Ensure.ensureObject(map);
    this.map = map;
    this.panel = panel;
    OpenLayers.Util.extend(this, options);
    this.map.events.on( {
      'legato.refresh' :this.manageToolbar,
      scope :this
    });
  },
  destroy : function() {
    this.map.events.un( {
      'legato.refresh' :this.manageToolbar,
      scope :this
    });
  },
  manageToolbar : function() {
    var getCapabilitiesRequest = {
      service :'WPS',
      acceptVersions : {
        version : [ '1.0.0' ]
      }
    };
    this.wpsOperations.getCapabilities(getCapabilitiesRequest,
        OpenLayers.Function.bind( function(capabilities) {

          //iterate over panel elements
          var panelButtons = new Legato.Util.HashSet();
          for (var ind = 0; ind < this.panel.controls.length; ind++) {
            var panelButton = this.panel.controls[ind];
            if (panelButton.CLASS_NAME == "WPS.Control.WpsButton") {
              panelButtons.add(panelButton.processIdentifier);
            }
          }

          var buttons = [];
          var processDescriptions = capabilities.processOfferings.process;
          var predicate;
          if (Legato.Lang.ObjectUtils.exists(this.predicate)) {
            predicate = this.predicate;
          } else {
            predicate = this.createDefaultPredicate();
          }
          for ( var index = 0; index < processDescriptions.length; index++) {
            var processDescription = processDescriptions[index];
            if (predicate.evaluate(processDescription) && !panelButtons.contains(processDescription.identifier.value)) {
              var button = new WPS.Control.WpsButton( {
                form :this.form,
                wpsOperations :this.wpsOperations,
                processDescription :processDescription
              });
              buttons.push(button);
            }
          }
          this.panel.addControls(buttons);
        }, this));
  },
  createDefaultPredicate : function() {
    return new WPS.Predicate.MapTags(this.map, {
      prefix :'wps:toolbar:',
      defaultIncludes :false
    });
  },
  CLASS_NAME :'WPS.ToolbarManager'
});
WPS.ToolbarManager.Bean = Legato.Beans.Object.Extend('WPS.ToolbarManager',
//
    WPS.QName('ToolbarManager'),
    //
    {
      _constructor :WPS.ToolbarManager,
      constructorArguments : {
        map :Legato.Beans.Object,
        panel :Legato.Beans.Object
      },
      constructorOrder : [ 'map', 'panel' ],
      options : {
        form :Legato.Beans.Object,
        wpsOperations :Legato.Lang.Function,
        predicate :Legato.Beans.Object
      }
    });