/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPSPD.Result.Marker = OpenLayers.Class(
  WPS.Result,
  {
    map : null,
    factory : null,
    marker : null,
    selectControl : null,
    layer: null,
    feature: null,

    initialize : function(id, map, factory, marker, options) {
      WPS.Result.prototype.initialize.apply(this, [ id,
          options ]);
      Legato.Util.Ensure.ensureExists(map, 'map should be defined');
      Legato.Util.Ensure.ensureExists(factory,
          'factory should be defined');
      Legato.Util.Ensure.ensureExists(marker, 'marker should be defined');
      this.map = map;
      this.factory = factory;
      this.marker = marker;
    },

    createFeature : function() {
      if (Legato.Lang.ObjectUtils.exists(this.marker.geometry)) {
        var outputData = {
          data : {
            complexData : {
              schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Geometry',
              mimeType : 'text/xml',
              encoding : 'utf-8',
              content : [ this.marker.geometry ]
            }
          }
        };
        var geometryResult = this.factory.createSingleNormalResult(outputData,
            null, null);
        this.feature = geometryResult.createFeature();
        return this.feature;
      } else if (Legato.Lang.ObjectUtils.exists(this.marker.position)) {
        throw new Legato.Lang.Exception("Position markers are not yet supported.");
      }
    },

    createLayer : function(feature) {
      var layerOptions = {
        displayInLayerSwitcher : true,
        calculateInRange : function() {
          return true;
        }
      };
      //Should be configurable (i18n)
      this.layer = new OpenLayers.Layer.Vector('Result marker layer', layerOptions);
      this.layer.style = WPS.Feature.Style.ACTIVE;
      this.layer.addFeatures([ feature ]);
    },

    createSelectControl : function(layer, feature) {
      if (Legato.Lang.ObjectUtils.exists(this.marker.message)) {

        // Create message
        // Add message to feature
        var messageOutputData = {
          data : {
            complexData : {
              schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Message',
              mimeType : 'text/xml',
              encoding : 'utf-8',
              content : [ this.marker.message ]
            }
          }
        };

        feature.messageResult = this.factory.createSingleNormalResult(messageOutputData, null, null);

        var selectControlOptions = {
          scope: feature,
          hover: true,
          highlightOnly : true
        };

        // REVIEW AV Control pro marker?
        this.selectControl = new OpenLayers.Control.SelectFeature(layer, selectControlOptions);
        this.selectControl.events.register('beforefeaturehighlighted', this, this.onBeforefeaturehighlighted);
        this.selectControl.events.register('featurehighlighted', this, this.onFeaturehighlighted);
        this.selectControl.events.register('featureunhighlighted', this, this.onFeatureunhighlighted);
      }
    },

    onBeforefeaturehighlighted: function(options){
      return options.feature === this.feature;
    },

    onFeaturehighlighted: function(options){
      if(options.feature !== this.feature){
        return false;
      }

      if (Legato.Lang.ObjectUtils.exists(this.feature.messageResult.message) &&
          !Legato.Lang.ObjectUtils.exists(this.feature.popup)) {

        var centroid = this.feature.geometry.getCentroid();
        var lonlat = new OpenLayers.LonLat(centroid.x, centroid.y);

        var popup = new OpenLayers.Popup.AnchoredBubble(
          //ID
          this.feature.id + '.Message',
          //Center to Geometry
          lonlat,
          //AutoSize!
          null,
          //content
          this.feature.messageResult.message,
          //not needed
          null,
          //no close button
          false,
          //not needed
          null
        );
        popup.panMapIfOutOfView = false;
        popup.closeOnMove = true;
        popup.autoSize = true;
        this.feature.popup = popup;
      }
      this.map.addPopup(this.feature.popup);
      this.feature.popup.show();
    },

    onFeatureunhighlighted: function(options){
      if(options.feature !== this.feature){
        return false;
      }

      if (!Legato.Lang.ObjectUtils.isNullOrUndefined(this.feature.popup)) {
        this.map.removePopup(this.feature.popup);
      }
      this.feature.popup.hide();
    },

    addLayerAndSelectControl : function() {
      this.map.addLayer(this.layer);
      if (Legato.Lang.ObjectUtils.exists(this.selectControl)) {
        this.map.addControl(this.selectControl);
      }
    },

    execute : function() {
      this.createFeature();
      this.createLayer(this.feature);
      this.createSelectControl(this.layer, this.feature);
      this.addLayerAndSelectControl();
    },

    destroy : function() {
      this.layer.destroy();
      this.marker = null;
      WPS.Result.prototype.destroy.apply(this, arguments);
    },

    CLASS_NAME : 'WPSPD.Result.Marker'
  }
);

WPSPD.Result.Marker.ComplexFactory = OpenLayers.Class(
  WPS.Result.ComplexFactory,
  {
    schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Marker',

    name : new Legato.XML.QName('http://www.disy.net/pd', 'Marker', 'pd'),

    map : null,

    factory : null,

    initialize : function(map, factory) {
      Legato.Util.Ensure.ensureExists(map, 'map should be defined');
      Legato.Util.Ensure.ensureExists(factory, 'factory should be defined');
      this.map = map;
      this.factory = factory;
    },

    createResult : function(id, outputData, options) {
      var complexData = outputData.data.complexData;
      var value = complexData.content[0].value;

      return new WPSPD.Result.Marker(id, this.map, this.factory, value,
          options);

    },
    CLASS_NAME : 'WPSPD.Result.Marker.ComplexFactory'
  }
);