/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.ExceptionReport = OpenLayers.Class(
  WPS.Result,
  {
    exceptionReport: null,

    initialize : function(id, exceptionReport, options) {
      Legato.Util.Ensure.ensureExists(exceptionReport, 'An exception report should be defined');
      WPS.Result.prototype.initialize.apply(
        this, [id, options ]
      );
      this.exceptionReport = exceptionReport;
    },

    showExceptionReport: function(report) {
      alert(this.createExceptionMessage(report, "\r\n"));
    },

    createExceptionMessage: function(report, lineBreak) {
      var message = 'Beim Ausführen des Dienstes ist ein Fehler aufgetreten.' + lineBreak;
      message += 'Fehler-Code: ' + report.exception[0].exceptionCode + lineBreak;
      message += 'Fehlernachricht: ';
      message += report.exception[0].exceptionText.join(' ');
      return message;
    },

    execute : function() {
      if (!Legato.Lang.ObjectUtils.isFunction(this.errorCallback)){
        this.showExceptionReport(this.exceptionReport);
        return;
      }
      this.errorCallback(this.createContent());
    },

    createContent : function() {
      var reportElement = document.createElement('div');
      reportElement.id = this.id;
      OpenLayers.Element.addClass(reportElement, 'error');
      reportElement.innerHTML = this.createExceptionMessage(this.exceptionReport, '<br />');
      return reportElement;
    },

    destroy : function() {
      this.report = null;
      WPS.Result.prototype.destroy.apply(this, arguments);
    },

    CLASS_NAME :'WPS.Result.ExceptionReport'
  }
);

WPS.Result.ExceptionReport.ExceptionReportFactory = OpenLayers.Class(
  WPS.Result.SimpleFactory, {

    createResult : function(id, exceptionReport, options) {
      return new WPS.Result.ExceptionReport(id, exceptionReport, options);
    },

    CLASS_NAME :'WPS.Result.ExceptionReport.ExceptionReportFactory'
});