/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Model = OpenLayers.Class({

  EVENT_TYPES : [ 'valuechange', 'validitychange' ],

  identifier :null,

  title :null,

  'abstract' :null,

  minOccurs :null,

  maxOccurs :1,

  value :null,

  defaultValue :null,

  events :null,

  valueProperty :null,

  checked: false,

  required: false,

  valid: false,

  validationMessages: null,

  initialize : function(modelFactory, options) {
    OpenLayers.Util.extend(this, options);
    this.events = new OpenLayers.Events(this, null, this.EVENT_TYPES);
    this.required = (this.minOccurs > 0);
    this.validationMessages = [];
    if (Legato.Lang.ObjectUtils.exists(this.defaultValue))
    {
      this.setValue(this.defaultValue);
      this.setChecked(true);
    }
    else
    {
      this.validate();
    }
  },

  getValue : function() {
    return this.value;
  },

  setValue : function(value) {
    if (value !== this.value)
    {
      this.value = value;
      this.events.triggerEvent('valuechange', {
        value :value
      });
    }
    this.validate();
  },

  resetValue : function() {
    this.setValue(this.getDefaultValue());
  },

  getDefaultValue: function(){
    return this.defaultValue;
  },

  setDefaultValue: function(defaultValue){
    this.defaultValue = defaultValue;
    if(this.getValue() === null){
      this.setValue(this.defaultValue);
    }
  },

  setChecked : function(checked) {
    this.checked = checked;
    if (! this.checked) {
      this.resetValue();
    }
    this.validate();
  },

  validate: function() {
    var oldValid = this.valid;
    this.validationMessages = [];
    if (this.required && !(this.getValue() && this.checked)) {
      this.valid = false;
      this.validationMessages.push(this.title + ' muss ausgef\u00FCllt werden');
    } else {
      this.valid = true;
    }
    //if (this.valid !== oldValid) {
    //}
    this.events.triggerEvent('validitychange', {
      valid :this.valid,
      validBefore: oldValid
    });
  },

  getData : function() {
    if (this.value === null || !this.checked) {
      return null;
    } else {
      var data = {
        identifier : {
          value :this.identifier
        },
        data : {}
      };
      return [ this.populateData(data) ];
    }
  },

  populateData : function(data) {
    return data;
  },

  destroy : function() {
    if (this.events) {
      this.events.destroy();
      this.events = null;
    }
    this.value = null;
  },

  CLASS_NAME :'WPS.Model'
});
