/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: WPS.Control.WpsButton
 *
 * A WPS Button which build a WPS specific map tool button for easy
 * access.
 *
 * Inherits from: - <WPS.Contro>
 *
 */
WPS.Control.WpsButton = OpenLayers.Class( WPS.Control, {

  type : OpenLayers.Control.TYPE_BUTTON,

  form : null,

  wpsOperations : null,

  processIdentifier : null,

  processDescription : null,

  initialize : function(options) {
    Legato.Util.Ensure.ensureExists(options.form, "form must be defined");
    OpenLayers.Control.prototype.initialize.apply(this, arguments);

    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.events.on( {
        'processSelectionCancellation' : this.deactivate,
        scope : this
      });
    }

    OpenLayers.Util.extend(this, options);

    if (!Legato.Lang.ObjectUtils.exists(this.processIdentifier) &&
        Legato.Lang.ObjectUtils.exists(this.processDescription)) {
      this.processIdentifier = this.processDescription.identifier.value;
    }

    if (this.wpsOperations === null) {
      this.wpsOperations = WpsOperations;
    }
  },

  parseDescriptions : function(processDesc) {
    if(this.panel_div === null){
      return;
    }

    var processDescriptions = processDesc.processDescription;
    for ( var index = 0; index < processDescriptions.length; index++) {
      var processDescription = processDescriptions[index];
      if (Legato.Lang.ObjectUtils.isArray(processDescription.metadata)) {
        for ( var i = 0; i < processDescription.metadata.length; i++) {
          if (processDescription.metadata[i].about == "shortcut icon") {
            this.panel_div.style.backgroundImage = "url("
                + processDescription.metadata[i].href + ")";
          }
        }
      }
    }
  },

  draw: function (px) {
    if (this.processDescription === null) {
      var describeProcessRequest = {
          identifier : [{
            value : this.processIdentifier
          }]
      };
      this.wpsOperations.describeProcess(
          describeProcessRequest,
          OpenLayers.Function.bind(this.parseDescriptions, this)
      );
    } else {
      var processDescriptions = {
          processDescription : [this.processDescription]
      };
      this.parseDescriptions(processDescriptions);
    }

    OpenLayers.Control.prototype.draw.apply(this, arguments);
    return this.div;
  },

  destroy : function() {
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  trigger : function() {
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.off();
      if (Legato.Lang.ObjectUtils.exists(this.form.processComponent)) {
        this.form.cancelExecution();
      }
      this.form.selectProcess(this.processIdentifier, true);
      this.form.on();
    }
  },

  CLASS_NAME : "WPS.Control.WpsButton"
});

WPS.Control.WpsButton.Bean = WPS.Control.Bean.Extend('WPS.Control.WpsButton',
  WPS.Control.QName('WpsButton'),
  {
    _constructor : WPS.Control.WpsButton,
    options : {
      form : WPS.Form,
      wpsOperations : Legato.Lang.Function,
      processIdentifier : Legato.Lang.String,
      processDescription : Legato.Lang.Object
    }
  }
);