/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Revision: 69543 $
 * @requires Legato.js
 * @requires OpenLayers/Control.js
 */

/**
 * Test utility methods
 */
Legato.Test.Util = {};

Legato.Test.Util.getTestOverlay = function(){
  return new OpenLayers.Layer.WMS(
    'Shaded Relief',
    'http://gisdata.usgs.gov/wmsconnector/com.esri.wms.Esrimap?ServiceName=USGS_EDC_Elev_NED_3',
    {
      layers :'HR-NED.IMAGE',
      reaspect :'false',
      transparent :'true'
    }, {
      isBaseLayer :false,
      opacity :0.3
    }
  );
};

Legato.Test.Util.getTestBaseLayer = function(){
  return new OpenLayers.Layer.WMS(
    'Topo Maps',
    'http://terraservice.net/ogcmap.ashx',
    {
      layers :'DRG'
    }
  );
};


/*
 * Creates a default test map which could been tested
 * for unit tests
 */
Legato.Test.Util.getTestMap = function(options){

  var map;

  //Merge options with default values
  options.maxExtent = options.maxExtent || new OpenLayers.Bounds(-180.0, -90.0, 180.0, 90.0);
  options.maxResolution = options.maxResolution || "auto";
  options.autoValidate = options.autoValidate || true;


  //Create common testmap
  map = new OpenLayers.Map('map', options);

  var testLayers = [
    Legato.Test.Util.getTestBaseLayer(),
    Legato.Test.Util.getTestOverlay()
  ];

  map.addLayers(testLayers);
  map.zoomToMaxExtent();

  if(options.autoValidate){
    assertNotNull(map);
    assertEquals(testLayers.length, map.layers.length);
    //logger.info('Testmap created. It contains ' + map.layers.length + ' testlayers');
  }

  return map;
};

Legato.Util.assertArrayValues = function(array1, array2){
  assertTrue(typeof array1 == 'object' && typeof array1.length != 'undefined');
  assertTrue(typeof array2 == 'object' && typeof array2.length != 'undefined');
  assertEquals(array1.length, array2.length);

  for(var i = 0; i < array1.length; i++){
    assertEquals(array1[i], array2[i]);
  }
};

Legato.Test.Util.formatForHtml = function(aString){
  return aString.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\n/g,"<br />");
};
