/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Structure: ll:RGBColor
 * XML based config for a <Legato.Lang.RGBColor>.
 *
 * See Also:
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for an RGBColor would be:
 * (start code)
 * <ll:RGBColor r="255" g="255" b="255" />
 * (end)
 */
Legato.Lang.RGBColor.Bean = Legato.Beans.Object.Extend('Legato.Lang.RGBColor',
    //
    Legato.Lang.QName('RGBColor'),
    //
    {
      _constructor : Legato.Lang.RGBColor,
      constructorArguments : {
    },
    constructorOrder : [],
    fields : {

    /*
     * Property: r
     * {Integer} the red value (0-255)
     */
    r : Legato.Lang.Integer,

    /*
     * Property: g
     * {Integer} the green value (0-255)
     */
    g : Legato.Lang.Integer,

    /*
     * Property: b
     * {Integer} the blue value (0-255)
     */
    b : Legato.Lang.Integer
  }
});

/*
 * Structure: ll:Null
 * XML based config for a <Legato.Lang.Null>.
 *
 * A config example would be:
 * (start code)
 * <ll:Null/>
 * (end)
 */
Legato.Lang.Null.Bean = Legato.Beans.Object.Extend('Legato.Lang.Null',
      //
      Legato.Lang.QName('Null'),
      //
      {
        _constructor : Legato.Lang.Null
      }
);