/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.ToggleDiv
 *
 * This simple control switches the visibility of an arbitrary div which is given in its "div" property.
 *
 * Inherits from:
 * - <Legato.Control>
 *
 */
Legato.Control.ToggleDiv = OpenLayers.Class(Legato.Control, {

  control :null,

  type :OpenLayers.Control.TYPE_TOGGLE,

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
  },

  /** Function: activate
   * Invoked when the control is activated in toggle mode
   */
  activate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.div)) {
      Legato.XML.ElementUtils.show(this.div);
    }
    this.active = true;
    Legato.Control.prototype.activate.apply(this, arguments);
  },

  /** Function: trigger
   * Invoked when the control is deactivated in toggle mode
   */
  deactivate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.div)) {
      Legato.XML.ElementUtils.hide(this.div);
    }
    this.active = false;
    Legato.Control.prototype.deactivate.apply(this, arguments);
  },

  CLASS_NAME :"Legato.Control.ToggleDiv"
});

/**
 * Structure: lc:ToggleDiv
 * XML based config for a <Legato.Control.ToggleDiv>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ToggleDiv would be:
 * (start code)
 * <lc:ToggleDiv div="overviewMap" displayClass="LegatoControlToggleOverviewMap"/>
 * (end)
 */
Legato.Control.ToggleDiv.Bean = OpenLayers.Control.Bean.Extend(
    'Legato.Control.ToggleDiv', Legato.Control.QName('ToggleDiv'), {
      _constructor :Legato.Control.ToggleDiv
    });
