/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ExtendedPanel = OpenLayers.Class(OpenLayers.Control.Panel,
    {
      visibleControls : [],

      addControls : function(controls) {
        if (!(OpenLayers.Util.isArray(controls))) {
          controls = [ controls ];
        }
        var dropDownControls = []; 

        this.visibleControls = this.visibleControls.concat(controls);
        this.controls = this.controls.concat(controls);

        for ( var i = 0, len = controls.length; i < len; i++) {
          var control = controls[i];
          if(this.isControlContainer(control)){
            control.setParentPanel(this);
            this.controls = this.controls.concat(control.controls);
            dropDownControls = dropDownControls.concat(control.controls);
          }else{
            control.panel_div = this.createControlPanelDiv(control);
          }
        }

        if (this.map) { // map.addControl() has already been called on the panel
          this.addControlsToMap(controls.concat(dropDownControls));
          this.redraw();
        }
      },
      
      iconOn: function() {
        OpenLayers.Control.Panel.prototype.iconOn.apply(this, arguments);
        OpenLayers.Element.removeClass(this.panel_div, "ItemInactive");
        OpenLayers.Element.addClass(this.panel_div, "ItemActive");
      },

      iconOff: function() {
        OpenLayers.Control.Panel.prototype.iconOff.apply(this, arguments);
        OpenLayers.Element.removeClass(this.panel_div, "ItemActive");
        OpenLayers.Element.addClass(this.panel_div, "ItemInactive");
      },

      redraw : function() {
        for ( var l = this.div.childNodes.length, i = l - 1; i >= 0; i--) {
          this.div.removeChild(this.div.childNodes[i]);
        }
        this.div.innerHTML = "";
        if (this.active) {
          for ( var j = 0, len = this.visibleControls.length; j < len; j++) {
            this.div.appendChild(this.visibleControls[j].panel_div);
          }
        }
      },
      
      createControlPanelDiv : function(control) {
        var panel_div = document.createElement("div");
        
        OpenLayers.Element.addClass(panel_div, control.displayClass
            + "ItemInactive");
        OpenLayers.Element.addClass(panel_div, "ItemInactive");
        OpenLayers.Element.addClass(panel_div, "olButton");
        
        if (control.title != "" && !panel_div.title) {
          panel_div.title = control.title;
        }
        
        return panel_div;
      },
      
      isControlContainer: function(control){
        return 'Legato.Control.ControlContainer' === control.CLASS_NAME 
            || 'LegatoJQuery.Control.ControlContainer' === control.CLASS_NAME;
      },
      
      CLASS_NAME : "Legato.Control.ExtendedPanel"
    });

/**
 * Class: Legato.Control.Panel
 * 
 * The Panel control is a container for other controls. With it toolbars may be
 * composed.
 * 
 * Inherits from: - <OpenLayers.Control.Panel>
 */
Legato.Control.ExtendedPanel.Bean = OpenLayers.Control.Panel.Bean.Extend(
    'Legato.Control.ExtendedPanel', Legato.Control.QName('ExtendedPanel'), {
      _constructor : Legato.Control.ExtendedPanel
    });