/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.DrawCircle = OpenLayers.Class(Legato.Control.DrawFeature, {
  handlerConstructor : Legato.Handler.RegularPolygon,
  measureDiv : null,

  initialize : function(layer, options) {
    if (options.measureDiv) {
      this.showLength = options.showLength;
      var callbacks = {
        move : this.measureRadius
      };

      this.callbacks = OpenLayers.Util.extend(callbacks, this.callbacks);
    }

    if(Legato.Lang.ObjectUtils.exists(options.handlerOptions)){
      if(!Legato.ObjectUtils.exists(options.handlerOptions.sides)){
        options.handlerOptions = OpenLayers.Util.extend(options.handlerOptions, {sides : 100});
      }
    }else{
      options.handlerOptions = {sides : 100};
    }

    Legato.Control.DrawFeature.prototype.initialize.apply(this, [ layer,
        options ]);
  },

  measureRadius : function(feature) {
    var radius = this.getRadius(feature);
    var out = 'Radius ' + radius[0] + ' ' + radius[1];
    this.measureDiv.innerHTML = out;
  },

  getRadius : function(geometry) {
    var units = [ 'km', 'm' ];
    var unit, length, radius;
    for ( var i = 0, len = units.length; i < len; ++i) {
      unit = units[i];
      length = this.getLength(geometry, unit);
      radius = (length / (2 * Math.PI));
      if (radius > 1) {
        break;
      }
    }
    return [ OpenLayers.Number.format(length / (2 * Math.PI), 3, ".", ","), unit ];
  },

  getLength : function(geometry, units) {
    var length = geometry.getLength();
    var geomUnits = this.map.getUnits();

    var inPerDisplayUnit = OpenLayers.INCHES_PER_UNIT[units];

    if (inPerDisplayUnit) {
      var inPerMapUnit = OpenLayers.INCHES_PER_UNIT[geomUnits];
      length *= (inPerMapUnit / inPerDisplayUnit);
    }

    return length;
  },

  deactivate : function() {
    if(this.measureDiv){
      this.measureDiv.innerHTML = '';
    }
    Legato.Control.DrawFeature.prototype.deactivate.apply(this, arguments);
  },

  CLASS_NAME : 'Legato.Control.DrawCircle'
});

Legato.Control.DrawCircle.Bean = Legato.Control.DrawFeature.Bean.Extend(
//
'Legato.Control.DrawCircle',
//
Legato.Control.QName('DrawCircle'),
//
{
  _constructor : Legato.Control.DrawCircle,
  constructorArguments : {
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ]
});