/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Rev: 72369 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: SelectLonLat
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.SelectLonLat = OpenLayers.Class(Legato.Control,
{
  /**
   * Property: type
   * {OpenLayers.Control.TYPE}
   */
  type: OpenLayers.Control.TYPE_TOOL,

  /**
   * Property: callback
   * {Function} callback function
   */
  callback: null,

  handler: null,

  /**
   * Constructor: Legato.Control.SelectLonLat
   *
   * Parameters:
   * options - {Object} An optional object whose properties will be set on this instance.
   *           currently no options are supported yet.
   */
  initialize : function(options) {
    Legato.Control.prototype.initialize.apply(this, arguments);
//    Legato.Util.Ensure.ensureFunction(this.callback,
//        'To use ' + this.CLASS_NAME + ' you must specify a callback function.');
  },

  /**
   * Method: draw
   */
  draw: function() {
    
    //Initializes the handler and callback methods
    this.handler = new OpenLayers.Handler.Point( this, {
      done: this.select
    },
    {
      persist: true
    });
  },
  
  select: function(draftPoint)
  {
    if (draftPoint instanceof OpenLayers.Geometry.Point)
    {
      var point = new OpenLayers.LonLat(draftPoint.x, draftPoint.y);
    
      if (Legato.Lang.ObjectUtils.isFunction(this.callback))
      {
        this.callback(point);
      }
    }
  },

  /**
   * APIMethod: destroy
   * Deconstruct the control
   */
  destroy: function() {
    if (Legato.Lang.ObjectUtils.exists(this.handler))
    {
      this.handler.destroy();
    }
  },

  CLASS_NAME: 'Legato.Control.SelectLonLat'
});

/**
 * Structure: lc:SelectLonLat
 * XML based config for a <Legato.Control.SelectLonLat>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 *
 * A valid config example for a SelectLonLat would be:
 * (start code)
 * <lc:SelectLonLat/>
 * (end)
 */
Legato.Control.SelectLonLat.Bean = Legato.Control.Bean.Extend(

  'Legato.Control.SelectLonLat',

  /*
   * Property: QName
   * The qualified name for this control. Needed by XML config to instantiate it.
   */
  Legato.Control.QName('SelectLonLat'),
  {
    _constructor: Legato.Control.SelectLonLat,
    options:
    {
      callback: Legato.Lang.Function,
      displayClass: Legato.Lang.String
    }
  }
);
