/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.PanZoom = OpenLayers.Class(OpenLayers.Control.PanZoom,
    {
      initialize : function(options) {
        OpenLayers.Control.PanZoom.prototype.initialize.apply(this, arguments);
      },
      
      cssDerivations : {
        'panup' : 'Up',
        'panleft': 'Left',
        'panright': 'Right',
        'pandown': 'Down',
        'zoomin': 'In',
        'zoomworld': 'World',
        'zoomout': 'Out'
      },
    
    _addButton : function(id, _class, xy, sz) {
      var btn = OpenLayers.Control.PanZoom.prototype._addButton.apply(this, arguments);
      btn.className = btn.className + ' ' + this.displayClass + this.cssDerivations[id];
      if (btn.hasChildNodes())
      {
        while (btn.childNodes.length >= 1)
        {
          btn.removeChild(btn.firstChild);       
        } 
      }
      return btn;
    },

    CLASS_NAME :"Legato.Control.PanZoom"
    });

Legato.Control.PanZoom.Bean = OpenLayers.Control.PanZoom.Bean.Extend(
//
    'Legato.Control.PanZoom',
    //
    Legato.Control.QName('PanZoom'),
    //
    {
      _constructor :Legato.Control.PanZoom
    });