/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.Legend = OpenLayers
		.Class(
				OpenLayers.Control,
				{
					div : null,
					legendDiv : null,
					baseLayersDiv : null,
					overlaysDiv : null,
					/**
					 * Container plugin factory.
					 */
					containerPlugin : null,
					/**
					 * Plugin factories.
					 */
					plugins : null,
					/**
					 * Containers (plugin instances) for base layers.
					 */
					baseLayerContainers : null,
					/**
					 * Containers (plugin instances) for overlays.
					 */
					overlayContainers : null,

					initialize : function(options) {
						OpenLayers.Control.prototype.initialize.apply(this,
								arguments);
						if (!Legato.Lang.ObjectUtils
								.exists(this.containerPlugin)) {
							this.containerPlugin = new Legato.Control.Legend.Plugin.Layer.Factory();
						}
						if (!Legato.Lang.ObjectUtils.exists(this.plugins)) {
							this.plugins = [];
						}
						if (!Legato.Lang.ObjectUtils
								.isBoolean(this.showBaseLayers)) {
							this.showBaseLayers = false;
						}
						if (this.showBaseLayers) {
							this.baseLayerContainers = [];
						}
						this.overlayContainers = [];
					},
					/*
					 * Function: setMap Set the map property for the control.
					 *
					 * Parameters: map - {<OpenLayers.Map>}
					 */
					setMap : function(map) {
						OpenLayers.Control.prototype.setMap.apply(this,
								arguments);

						this.map.events.on({
							'addlayer' : this.layerAdded,
							'changelayer' : this.layerChanged,
							'removelayer' : this.layerRemoved,
							scope : this
						});
					},
					/*
					 * Function: destroy APIMethod: called if destroyed
					 */
					destroy : function() {
						this.map.events.un({
							'addlayer' : this.layerAdded,
							'changelayer' : this.layerChanged,
							'removelayer' : this.layerRemoved,
							scope : this
						});

						this.div.removeChild(this.legendDiv);
						if (this.showBaseLayers) {
							this.legendDiv.removeChild(this.baseLayersDiv);
							this.destroyContainers(this.baseLayerContainers);
							this.baseLayerContainers = null;
							this.baseLayersDiv = null;
						}

						this.legendDiv.removeChild(this.overlaysDiv);
						this.destroyContainers(this.overlayContainers);
						this.overlayContainers = null;
						this.overlaysDiv = null;

						OpenLayers.Control.prototype.destroy.apply(this,
								arguments);
						this.div = null;
						this.legendDiv = null;
						this.plugins = null;
						this.containerPlugin = null;
					},
					layerAdded : function(event) {
						var layer = event.layer;
						if (this.showBaseLayers
								&& this.isListedBaseLayer(layer)) {
							this.doAddLayer(layer, this.baseLayerContainers,
									this.baseLayersDiv);
						}
						if (this.isListedOverlay(layer)) {
							this.doAddLayer(layer, this.overlayContainers,
									this.overlaysDiv);
						}
					},
					doAddLayer : function(layer, containers, element) {
						var container = this.createContainer(layer);
						containers.push(container);
						this.addContainer(element, container);
					},
					layerRemoved : function(event) {
						var layer = event.layer;
						if (this.showBaseLayers
								&& this.isListedBaseLayer(layer)) {
							this.doRemoveLayer(layer, this.baseLayerContainers,
									this.baseLayersDiv);
						}
						if (this.isListedOverlay(layer)) {
							this.doRemoveLayer(layer, this.overlayContainers,
									this.overlaysDiv);
						}
					},
					doRemoveLayer : function(layer, containers, element) {
						var containerIndex = this.findContainerIndex(
								containers, layer);
						if (containerIndex >= 0) {
							this.removeContainer(element,
									containers[containerIndex]);
							containers.splice(containerIndex, 1);
						}
					},
					layerChanged : function(event) {
						var property = event.property;
						if ('order' == event.property) {
							this.layerChangedOrder(event);
						}
					},
					layerChangedOrder : function(event) {
						var layer = event.layer;
						if (this.showBaseLayers
								&& this.isListedBaseLayer(layer)) {
							this.doChangeLayerOrder(layer,
									this.baseLayerContainers,
									this.baseLayersDiv);
						}
						if (this.isListedOverlay(layer)) {
							this.doChangeLayerOrder(layer,
									this.overlayContainers, this.overlaysDiv);
						}
					},
					doChangeLayerOrder : function(layer, containers, element) {
						var containerIndex = this.findContainerIndex(
								containers, layer);
						if (containerIndex >= 0) {
							var newContainerIndex = this.findNewContainerIndex(
									containers, layer);
							if (containerIndex != newContainerIndex) {
								var container = containers[containerIndex];
								element.removeChild(container.div);
								containers.splice(containerIndex, 1);
								if (newContainerIndex < containerIndex) {
									containers.splice(newContainerIndex, 0,
											container);
									if (newContainerIndex - 1 >= 0) {
										element
												.insertBefore(
														container.div,
														containers[newContainerIndex - 1].div);
									} else {
										element.appendChild(container.div);
									}
								} else {
									containers.splice(newContainerIndex - 1, 0,
											container);
									if (newContainerIndex - 2 >= 0) {
										element
												.insertBefore(
														container.div,
														containers[newContainerIndex - 2].div);
									} else {
										element.appendChild(container.div);
									}
								}
							}
						}

					},
					findNewContainerIndex : function(containers, layer) {
						var i = 0;
						var j = 0;
						while ((i < this.map.layers.length)
								&& (j < containers.length)) {
							if (this.map.layers[i] === layer) {
								return j;
							}
							if (this.map.layers[i] === containers[j].layer) {
								i++;
								j++;
							} else if (containers[j].layer === layer) {
								j++;
							} else {
								i++;
							}
						}
						return j;
					},
					findContainerIndex : function(containers, layer) {
						for ( var index = 0; index < containers.length; index++) {
							if (containers[index].layer === layer) {
								return index;
							}
						}
						return -1;
					},
					createContainers : function(layers) {
						var containers = [];
						for ( var index = 0; index < layers.length; index++) {
							containers[index] = this
									.createContainer(layers[index]);
						}
						return containers;
					},
					createContainer : function(layer) {
						var pluginFactories = [];
						for ( var i = 0; i < this.plugins.length; i++) {
							pluginFactories.push(this.plugins[i]);
						}
						//    if (Legato.Lang.ObjectUtils.isArray(layer.plugins))
						//    {
						//      for (var index = 0; index < layer.plugins.length; index++ )
						//      {
						//        pluginFactories.push(layer.plugins[index]);
						//      }
						//    }
						var plugins = [];
						for ( var j = 0; j < pluginFactories.length; j++) {
							if (pluginFactories[j].supports(layer)) {
								plugins.push(pluginFactories[j].create(layer));
							}
						}
						var containerFactory = this.containerPlugin;
						var container = containerFactory.create(layer, plugins);
						return container;
					},
					getListedBaseLayers : function() {
						return Legato.OpenLayers.Map.Util
								.getListedBaseLayers(this.map.layers);
					},
					getListedOverlays : function() {
						return Legato.OpenLayers.Map.Util
								.getListedOverlays(this.map.layers);
					},
					isListedBaseLayer : function(layer) {
						return Legato.OpenLayers.Map.Util
								.isListedBaseLayer(layer);
					},
					isListedOverlay : function(layer) {
						return Legato.OpenLayers.Map.Util
								.isListedOverlay(layer);
					},
					draw : function() {
						OpenLayers.Control.prototype.draw
								.apply(this, arguments);
						this.legendDiv = document.createElement('div');
						this.legendDiv.id = this.id + "_Legend";
						this.legendDiv.className = this.displayClass
								+ "Container";

						this.overlaysDiv = document.createElement('div');
						this.overlaysDiv.id = this.id + "_Overlays";
						this.overlaysDiv.className = this.displayClass
								+ "Overlays";
						this.legendDiv.appendChild(this.overlaysDiv);

						if (this.showBaseLayers) {
							this.baseLayersDiv = document.createElement('div');
							this.baseLayersDiv.id = this.id + "_BaseLayers";
							this.baseLayersDiv.className = this.displayClass
									+ "BaseLayers";
							this.legendDiv.appendChild(this.baseLayersDiv);
						}
						this.div.appendChild(this.legendDiv);
						this.update();
						return this.div;
					},

					update : function() {
						if (this.showBaseLayers) {
							this.removeContainers(this.baseLayersDiv,
									this.baseLayerContainers);
						}
						this.removeContainers(this.overlaysDiv,
								this.overlayContainers);
						if (this.showBaseLayers) {
							this.baseLayerContainers = this
									.createContainers(this
											.getListedBaseLayers());
							this.addContainers(this.baseLayersDiv,
									this.baseLayerContainers);
						}

						this.overlayContainers = this.createContainers(this
								.getListedOverlays());
						this.addContainers(this.overlaysDiv,
								this.overlayContainers);

					},
					addContainer : function(element, container) {
						var containerElement = container.draw();
						if (element.childNodes.length === 0) {
							element.appendChild(containerElement);
						} else {
							element.insertBefore(containerElement,
									element.childNodes[0]);
						}
					},
					addContainers : function(element, containers) {
						for ( var index = 0; index < containers.length; index++) {
							this.addContainer(element, containers[index]);
						}
					},
					removeContainer : function(element, container) {
						element.removeChild(container.div);
						container.destroy();
					},
					removeContainers : function(element, containers) {
						for ( var index = 0; index < containers.length; index++) {
							this.removeContainer(element, containers[index]);
						}
					},
					destroyContainer : function(container) {
						container.destroy();
					},
					destroyContainers : function(containers) {
						for ( var index = 0; index < containers.length; index++) {
							this.destroyContainer(containers[index]);
						}
					},
					CLASS_NAME : 'Legato.Control.Legend'
				});

/**
 * Component: lc:Legend
 * 
 * Inherits from:
 * - <olc:Control>
 * 
 * See also:
 * - <lc> namespace
 * - {<Legato.Control.Legend>}
 */
Legato.Control.Legend.Bean = OpenLayers.Control.Bean.Extend(

'Legato.Control.Legend',

Legato.Control.QName('Legend'), {
	_constructor : Legato.Control.Legend,
	options : {
		/**
		 * Element: div
		 * {DOMElement}
		 */
		div : Legato.Lang.Element,
		/**
		 * Element: showBaseLayers
		 * {Boolean}
		 */
		showBaseLayers : Legato.Lang.Boolean,
		/**
		 * Element: containerPlugin
		 * {<llp:Plugin>}
		 */
		containerPlugin : Legato.Beans.Object,
		/**
		 * Element: plugins
		 * {<llp:Plugin> []}
		 */
		plugins : Legato.Beans.Object.List()
	}
});
